/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import jakarta.persistence.metamodel.ManagedType;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphParser;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.spi.RuntimeMetamodelsImplementor;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.BindableType;
import org.hibernate.query.CommonQueryContract;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.TypedParameterValue;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractCommonQueryContract
implements CommonQueryContract {
    private final SharedSessionContractImplementor session;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();

    public AbstractCommonQueryContract(SharedSessionContractImplementor session) {
        this.session = session;
    }

    public SharedSessionContractImplementor getSession() {
        return this.session;
    }

    protected int getIntegerLiteral(JpaExpression<Number> expression, int defaultValue) {
        if (expression == null) {
            return defaultValue;
        }
        if (expression instanceof SqmLiteral) {
            return ((Number)((SqmLiteral)expression).getLiteralValue()).intValue();
        }
        if (expression instanceof Parameter) {
            Number parameterValue = (Number)this.getParameterValue((Parameter)expression);
            return parameterValue == null ? defaultValue : parameterValue.intValue();
        }
        throw new IllegalArgumentException("Can't get integer literal value from: " + expression);
    }

    protected int getMaxRows(SqmSelectStatement<?> selectStatement, int size) {
        Number fetchValue;
        JpaExpression<Number> expression = selectStatement.getFetch();
        if (expression == null) {
            return -1;
        }
        if (expression instanceof SqmLiteral) {
            fetchValue = (Number)((SqmLiteral)expression).getLiteralValue();
        } else if (expression instanceof SqmParameter) {
            fetchValue = (Number)this.getParameterValue((Parameter)expression);
            if (fetchValue == null) {
                return -1;
            }
        } else {
            throw new IllegalArgumentException("Can't get max rows value from: " + expression);
        }
        switch (selectStatement.getFetchClauseType()) {
            case ROWS_ONLY: 
            case ROWS_WITH_TIES: {
                return fetchValue.intValue();
            }
            case PERCENT_ONLY: 
            case PERCENT_WITH_TIES: {
                return (int)Math.ceil((double)size * fetchValue.doubleValue() / 100.0);
            }
        }
        throw new UnsupportedOperationException("Unsupported fetch clause type: " + selectStatement.getFetchClauseType());
    }

    public Map<String, Object> getHints() {
        this.getSession().checkOpen(false);
        HashMap<String, Object> hints = new HashMap<String, Object>();
        this.collectHints(hints);
        return hints;
    }

    protected void collectHints(Map<String, Object> hints) {
        LockOptions lockOptions;
        if (this.getQueryOptions().getTimeout() != null) {
            hints.put("org.hibernate.timeout", this.getQueryOptions().getTimeout());
            hints.put("jakarta.persistence.query.timeout", this.getQueryOptions().getTimeout() * 1000);
        }
        this.putIfNotNull(hints, "org.hibernate.comment", this.getComment());
        this.putIfNotNull(hints, "org.hibernate.flushMode", this.getHibernateFlushMode());
        this.putIfNotNull(hints, "org.hibernate.readOnly", this.getQueryOptions().isReadOnly());
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getQueryOptions().getFetchSize());
        this.putIfNotNull(hints, "org.hibernate.cacheable", this.getQueryOptions().isResultCachingEnabled());
        this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getQueryOptions().getResultCacheRegionName());
        this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getQueryOptions().getCacheMode());
        this.putIfNotNull(hints, "hibernate.query.plan.cacheable", this.getQueryOptions().getQueryPlanCachingEnabled());
        this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
        this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
        this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        AppliedGraph appliedGraph = this.getQueryOptions().getAppliedGraph();
        if (appliedGraph != null && appliedGraph.getSemantic() != null) {
            hints.put(appliedGraph.getSemantic().getJakartaHintName(), appliedGraph.getGraph());
            hints.put(appliedGraph.getSemantic().getJpaHintName(), appliedGraph.getGraph());
        }
        if (!(lockOptions = this.getQueryOptions().getLockOptions()).isEmpty()) {
            LockMode lockMode = lockOptions.getLockMode();
            if (lockMode != null && lockMode != LockMode.NONE) {
                hints.put("org.hibernate.lockMode", (Object)lockMode);
            }
            if (lockOptions.hasAliasSpecificLockModes()) {
                for (Map.Entry<String, LockMode> entry : lockOptions.getAliasSpecificLocks()) {
                    hints.put("org.hibernate.lockMode." + entry.getKey(), (Object)entry.getValue());
                }
            }
            if (lockOptions.getFollowOnLocking() == Boolean.TRUE) {
                hints.put("hibernate.query.followOnLocking", Boolean.TRUE);
            }
            if (lockOptions.getTimeOut() != -1) {
                hints.put("jakarta.persistence.lock.timeout", lockOptions.getTimeOut());
                hints.put("javax.persistence.lock.timeout", lockOptions.getTimeOut());
            }
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Enum<?> hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Object hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    @Override
    public CommonQueryContract setHint(String hintName, Object value) {
        this.applyHint(hintName, value);
        return this;
    }

    public final boolean applyHint(String hintName, Object value) {
        this.getSession().checkOpen(true);
        try {
            switch (hintName) {
                case "org.hibernate.flushMode": {
                    this.applyFlushModeHint(ConfigurationHelper.getFlushMode(value));
                    return true;
                }
                case "org.hibernate.timeout": {
                    this.applyTimeoutHint(ConfigurationHelper.getInteger(value));
                    return true;
                }
                case "javax.persistence.query.timeout": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.query.timeout", "jakarta.persistence.query.timeout");
                }
                case "jakarta.persistence.query.timeout": {
                    int timeout = (int)Math.round(ConfigurationHelper.getInteger(value).doubleValue() / 1000.0);
                    this.applyTimeoutHint(timeout);
                    return true;
                }
                case "org.hibernate.comment": {
                    this.applyCommentHint((String)value);
                    return true;
                }
                case "org.hibernate.query.native.spaces": {
                    this.applySynchronizeSpacesHint(value);
                    return true;
                }
                case "hibernate.query.database": {
                    this.applyDatabaseHint((String)value);
                    return true;
                }
            }
            if (this.applySelectionHint(hintName, value) || this.applyAdditionalPossibleHints(hintName, value)) {
                return true;
            }
            QueryLogging.QUERY_MESSAGE_LOGGER.ignoringUnrecognizedQueryHint(hintName);
            return false;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Incorrect value for query hint: " + hintName, e);
        }
    }

    protected void applySynchronizeSpacesHint(Object value) {
        QueryLogging.QUERY_LOGGER.debug((Object)"Query spaces hint was specified for non-native query; ignoring");
    }

    protected final boolean applySelectionHint(String hintName, Object value) {
        if (this.applyLockingHint(hintName, value)) {
            return true;
        }
        switch (hintName) {
            case "org.hibernate.readOnly": {
                this.applyReadOnlyHint(ConfigurationHelper.getBoolean(value));
                return true;
            }
            case "org.hibernate.fetchSize": {
                this.applyFetchSizeHint(ConfigurationHelper.getInteger(value));
                return true;
            }
            case "hibernate.query.plan.cacheable": {
                this.applyQueryPlanCacheableHint(ConfigurationHelper.getBoolean(value));
                return true;
            }
            case "org.hibernate.cacheable": {
                this.applyCacheableHint(ConfigurationHelper.getBoolean(value));
                return true;
            }
            case "org.hibernate.cacheRegion": {
                this.applyCacheRegionHint((String)value);
                return true;
            }
            case "org.hibernate.cacheMode": {
                this.applyCacheModeHint(ConfigurationHelper.getCacheMode(value));
                return true;
            }
            case "javax.persistence.cache.retrieveMode": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.cache.retrieveMode", "jakarta.persistence.cache.retrieveMode");
            }
            case "jakarta.persistence.cache.retrieveMode": {
                this.applyJpaCacheRetrieveModeHint(value != null ? CacheRetrieveMode.valueOf((String)value.toString()) : null);
                return true;
            }
            case "javax.persistence.cache.storeMode": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.cache.storeMode", "jakarta.persistence.cache.storeMode");
            }
            case "jakarta.persistence.cache.storeMode": {
                this.applyJpaCacheStoreModeHint(value != null ? CacheStoreMode.valueOf((String)value.toString()) : null);
                return true;
            }
            case "javax.persistence.fetchgraph": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.fetchgraph", "jakarta.persistence.fetchgraph");
            }
            case "jakarta.persistence.fetchgraph": {
                this.applyEntityGraphHint(hintName, value);
                return true;
            }
            case "javax.persistence.loadgraph": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.loadgraph", "jakarta.persistence.loadgraph");
            }
            case "jakarta.persistence.loadgraph": {
                this.applyEntityGraphHint(hintName, value);
                return true;
            }
        }
        return false;
    }

    protected void applyFetchSizeHint(int fetchSize) {
        this.getQueryOptions().setFetchSize(fetchSize);
    }

    protected void applyQueryPlanCacheableHint(boolean isCacheable) {
        this.getQueryOptions().setQueryPlanCachingEnabled(isCacheable);
    }

    protected void applyCacheModeHint(CacheMode cacheMode) {
        this.getQueryOptions().setCacheMode(cacheMode);
    }

    protected void applyCacheableHint(boolean isCacheable) {
        this.getQueryOptions().setResultCachingEnabled(isCacheable);
    }

    protected void applyCacheRegionHint(String regionName) {
        this.getQueryOptions().setResultCacheRegionName(regionName);
    }

    private void applyReadOnlyHint(Boolean readOnly) {
        this.getQueryOptions().setReadOnly(readOnly);
    }

    protected void applyEntityGraphHint(String hintName, Object value) {
        GraphSemantic graphSemantic = GraphSemantic.fromHintName(hintName);
        if (value instanceof RootGraphImplementor) {
            this.applyGraph((RootGraphImplementor)value, graphSemantic);
        } else if (value instanceof String) {
            this.applyGraph((String)value, graphSemantic);
        } else {
            throw new IllegalArgumentException("The value of the hint '" + hintName + "' must be an instance of EntityGraph or the string name of a named EntityGraph");
        }
    }

    protected void applyGraph(String graphString, GraphSemantic graphSemantic) {
        int separatorPosition = graphString.indexOf(40);
        int terminatorPosition = graphString.lastIndexOf(41);
        if (separatorPosition < 0 || terminatorPosition < 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid entity-graph definition `%s`; expected form `${EntityName}( ${property1} ... )", graphString));
        }
        RuntimeMetamodelsImplementor runtimeMetamodels = this.getSession().getFactory().getRuntimeMetamodels();
        JpaMetamodel jpaMetamodel = runtimeMetamodels.getJpaMetamodel();
        String entityName = runtimeMetamodels.getImportedName(graphString.substring(0, separatorPosition).trim());
        String graphNodes = graphString.substring(separatorPosition + 1, terminatorPosition);
        RootGraphImpl rootGraph = new RootGraphImpl(null, jpaMetamodel.entity(entityName));
        GraphParser.parseInto(rootGraph, (CharSequence)graphNodes, (EntityManagerFactory)this.getSession().getSessionFactory());
        this.applyGraph(rootGraph, graphSemantic);
    }

    protected void applyGraph(RootGraphImplementor<?> entityGraph, GraphSemantic graphSemantic) {
        this.getQueryOptions().applyGraph(entityGraph, graphSemantic);
    }

    private boolean applyLockingHint(String hintName, Object value) {
        switch (hintName) {
            case "javax.persistence.lock.timeout": {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.lock.timeout", "jakarta.persistence.lock.timeout");
            }
            case "jakarta.persistence.lock.timeout": {
                if (value != null) {
                    this.applyLockTimeoutHint(ConfigurationHelper.getInteger(value));
                    return true;
                }
                return false;
            }
            case "hibernate.query.followOnLocking": {
                this.applyFollowOnLockingHint(ConfigurationHelper.getBoolean(value));
                return true;
            }
            case "org.hibernate.lockMode": {
                this.applyLockModeHint(value);
                return true;
            }
        }
        if (hintName.startsWith("org.hibernate.lockMode")) {
            this.applyAliasSpecificLockModeHint(hintName, value);
            return true;
        }
        return false;
    }

    protected void applyLockTimeoutHint(Integer timeout) {
        if (timeout != null) {
            this.applyLockTimeoutHint((int)timeout);
        }
    }

    protected void applyLockTimeoutHint(int timeout) {
        this.getQueryOptions().getLockOptions().setTimeOut(timeout);
    }

    protected void applyHibernateLockMode(LockMode value) {
        this.getQueryOptions().getLockOptions().setLockMode(value);
    }

    protected void applyLockModeType(LockModeType value) {
        this.applyHibernateLockMode(LockMode.fromJpaLockMode(value));
    }

    protected final void applyLockModeHint(Object value) {
        if (value instanceof LockMode) {
            this.applyHibernateLockMode((LockMode)((Object)value));
        } else if (value instanceof LockModeType) {
            this.applyLockModeType((LockModeType)value);
        } else if (value instanceof String) {
            this.applyHibernateLockMode(LockModeTypeHelper.interpretLockMode(value));
        } else {
            throw new IllegalArgumentException(String.format("Native lock-mode hint [%s] must specify %s or %s.  Encountered type : %s", "org.hibernate.lockMode", LockMode.class.getName(), LockModeType.class.getName(), value.getClass().getName()));
        }
    }

    protected void applyAliasSpecificLockModeHint(String hintName, Object value) {
        String alias = hintName.substring("org.hibernate.lockMode".length() + 1);
        try {
            this.getQueryOptions().getLockOptions().setAliasSpecificLockMode(alias, LockModeTypeHelper.interpretLockMode(value));
        }
        catch (Exception e) {
            QueryLogging.QUERY_MESSAGE_LOGGER.unableToDetermineLockModeValue(hintName, value);
        }
    }

    protected void applyFollowOnLockingHint(Boolean followOnLocking) {
        this.getQueryOptions().getLockOptions().setFollowOnLocking(followOnLocking);
    }

    protected boolean applyAdditionalPossibleHints(String hintName, Object value) {
        return false;
    }

    @Override
    public String getComment() {
        return this.getQueryOptions().getComment();
    }

    @Override
    public CommonQueryContract setComment(String comment) {
        this.getQueryOptions().setComment(comment);
        return this;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return this.getQueryOptions().getFlushMode();
    }

    @Override
    public CommonQueryContract setHibernateFlushMode(FlushMode flushMode) {
        this.getQueryOptions().setFlushMode(flushMode);
        return this;
    }

    protected boolean applyJpaCacheRetrieveModeHint(CacheRetrieveMode retrieveMode) {
        this.getQueryOptions().setCacheRetrieveMode(retrieveMode);
        return true;
    }

    protected boolean applyJpaCacheStoreModeHint(CacheStoreMode storeMode) {
        this.getQueryOptions().setCacheStoreMode(storeMode);
        return true;
    }

    protected void applyTimeoutHint(int timeout) {
        this.setTimeout(timeout);
    }

    protected void applyCommentHint(String comment) {
        this.setComment(comment);
    }

    protected void applyFlushModeHint(FlushMode flushMode) {
        this.setHibernateFlushMode(flushMode);
    }

    protected void applyDatabaseHint(String hint) {
        this.getQueryOptions().addDatabaseHint(hint);
    }

    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public Integer getTimeout() {
        return this.getQueryOptions().getTimeout();
    }

    @Override
    public CommonQueryContract setTimeout(int timeout) {
        this.getQueryOptions().setTimeout(timeout);
        return this;
    }

    public int getMaxResults() {
        this.getSession().checkOpen();
        return this.getQueryOptions().getLimit().getMaxRowsJpa();
    }

    public void applyMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("max-results cannot be negative");
        }
        this.getSession().checkOpen();
        this.getQueryOptions().getLimit().setMaxRows(maxResult);
    }

    public int getFirstResult() {
        this.getSession().checkOpen();
        return this.getQueryOptions().getLimit().getFirstRowJpa();
    }

    public void applyFirstResult(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException("first-result value cannot be negative : " + startPosition);
        }
        this.getSession().checkOpen();
        this.getQueryOptions().getLimit().setFirstRow(startPosition);
    }

    protected FlushModeType getJpaFlushMode() {
        this.getSession().checkOpen();
        FlushMode flushMode = this.getQueryOptions().getFlushMode() == null ? this.getSession().getHibernateFlushMode() : this.getQueryOptions().getFlushMode();
        return FlushModeTypeHelper.getFlushModeType(flushMode);
    }

    protected void applyJpaFlushMode(FlushModeType flushModeType) {
        this.getSession().checkOpen();
        this.setHibernateFlushMode(FlushModeTypeHelper.getFlushMode(flushModeType));
    }

    public boolean applyTupleTransformer(TupleTransformer<?> transformer) {
        this.getQueryOptions().setTupleTransformer(transformer);
        return true;
    }

    public boolean applyResultListTransformer(ResultListTransformer<?> transformer) {
        this.getQueryOptions().setResultListTransformer(transformer);
        return true;
    }

    protected abstract ParameterMetadataImplementor getParameterMetadata();

    public Set<Parameter<?>> getParameters() {
        this.getSession().checkOpen(false);
        return this.getParameterMetadata().getRegistrations();
    }

    public QueryParameterImplementor<?> getParameter(String name) {
        this.getSession().checkOpen(false);
        try {
            return this.getParameterMetadata().getQueryParameter(name);
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public <T> QueryParameterImplementor<T> getParameter(String name, Class<T> type) {
        this.getSession().checkOpen(false);
        try {
            QueryParameter parameter = this.getParameterMetadata().getQueryParameter(name);
            if (!type.isAssignableFrom(parameter.getParameterType())) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to name [" + name + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public QueryParameterImplementor<?> getParameter(int position) {
        this.getSession().checkOpen(false);
        try {
            return this.getParameterMetadata().getQueryParameter(position);
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public <T> QueryParameterImplementor<T> getParameter(int position, Class<T> type) {
        this.getSession().checkOpen(false);
        try {
            QueryParameter parameter = this.getParameterMetadata().getQueryParameter(position);
            if (!type.isAssignableFrom(parameter.getParameterType())) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to position [" + position + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    protected abstract QueryParameterBindings getQueryParameterBindings();

    protected abstract boolean resolveJdbcParameterTypeIfNecessary();

    protected <P> QueryParameterBinding<P> locateBinding(Parameter<P> parameter) {
        if (parameter instanceof QueryParameterImplementor) {
            return this.locateBinding((QueryParameterImplementor)parameter);
        }
        if (parameter.getName() != null) {
            return this.locateBinding(parameter.getName());
        }
        if (parameter.getPosition() != null) {
            return this.locateBinding(parameter.getPosition());
        }
        throw this.getSession().getExceptionConverter().convert(new IllegalArgumentException("Could not resolve binding for given parameter reference [" + parameter + "]"));
    }

    protected <P> QueryParameterBinding<P> locateBinding(QueryParameterImplementor<P> parameter) {
        this.getSession().checkOpen();
        return this.getQueryParameterBindings().getBinding(parameter);
    }

    protected <P> QueryParameterBinding<P> locateBinding(String name) {
        this.getSession().checkOpen();
        return this.getQueryParameterBindings().getBinding(name);
    }

    protected <P> QueryParameterBinding<P> locateBinding(int position) {
        this.getSession().checkOpen();
        return this.getQueryParameterBindings().getBinding(position);
    }

    public boolean isBound(Parameter<?> param) {
        this.getSession().checkOpen();
        QueryParameter qp = this.getParameterMetadata().resolve((Parameter)param);
        return qp != null && this.getQueryParameterBindings().isBound((QueryParameterImplementor<?>)qp);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        QueryLogging.QUERY_LOGGER.tracef("#getParameterValue(%s)", param);
        this.getSession().checkOpen(false);
        QueryParameter qp = this.getParameterMetadata().resolve((Parameter)param);
        if (qp == null) {
            throw new IllegalArgumentException("The parameter [" + param + "] is not part of this Query");
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(qp);
        if (binding == null || !binding.isBound()) {
            throw new IllegalStateException("Parameter value not yet bound : " + param.toString());
        }
        if (binding.isMultiValued()) {
            return (T)binding.getBindValues();
        }
        return (T)binding.getBindValue();
    }

    public Object getParameterValue(String name) {
        this.getSession().checkOpen(false);
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(name);
        if (!binding.isBound()) {
            throw new IllegalStateException("The parameter [" + name + "] has not yet been bound");
        }
        if (binding.isMultiValued()) {
            return binding.getBindValues();
        }
        return binding.getBindValue();
    }

    public Object getParameterValue(int position) {
        this.getSession().checkOpen(false);
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(position);
        if (!binding.isBound()) {
            throw new IllegalStateException("The parameter [" + position + "] has not yet been bound");
        }
        if (binding.isMultiValued()) {
            return binding.getBindValues();
        }
        return binding.getBindValue();
    }

    @Override
    public CommonQueryContract setParameter(String name, Object value) {
        BindableType hibernateType;
        this.getSession().checkOpen(false);
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedValue = (TypedParameterValue)value;
            BindableType type = typedValue.getType();
            if (type != null) {
                return this.setParameter(name, typedValue.getValue(), type);
            }
            return this.setParameter(name, typedValue.getValue(), typedValue.getTypeReference());
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(name);
        QueryParameter param = binding.getQueryParameter();
        if (param.allowsMultiValuedBinding() && ((hibernateType = param.getHibernateType()) == null || this.isInstance(hibernateType, value)) && value instanceof Collection && !this.isRegisteredAsBasicType(value.getClass())) {
            return this.setParameterList(name, (Collection)value);
        }
        binding.setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        return this;
    }

    private boolean isInstance(BindableType<?> parameterType, Object value) {
        SqmExpressible<?> sqmExpressible = parameterType.resolveExpressible(this.getSession().getFactory());
        assert (sqmExpressible != null);
        return sqmExpressible.getExpressibleJavaType().isInstance(value);
    }

    @Override
    public <P> CommonQueryContract setParameter(String name, P value, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameter(name, value);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine BindableType : " + javaType.getName());
                }
            }
            this.setParameter(name, value, (BindableType<P>)paramType);
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameter(String name, P value, BindableType<P> type) {
        this.locateBinding(name).setBindValue(value, type);
        return this;
    }

    @Override
    public CommonQueryContract setParameter(String name, Instant value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public CommonQueryContract setParameter(int position, Object value) {
        BindableType hibernateType;
        this.getSession().checkOpen(false);
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedValue = (TypedParameterValue)value;
            BindableType type = typedValue.getType();
            if (type != null) {
                return this.setParameter(position, typedValue.getValue(), type);
            }
            return this.setParameter(position, typedValue.getValue(), typedValue.getTypeReference());
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(position);
        QueryParameter param = binding.getQueryParameter();
        if (param.allowsMultiValuedBinding() && ((hibernateType = param.getHibernateType()) == null || this.isInstance(hibernateType, value)) && value instanceof Collection && !this.isRegisteredAsBasicType(value.getClass())) {
            return this.setParameterList(position, (Collection)value);
        }
        binding.setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        return this;
    }

    private boolean isRegisteredAsBasicType(Class<?> valueClass) {
        return this.getSession().getTypeConfiguration().getBasicTypeForJavaType(valueClass) != null;
    }

    @Override
    public <P> CommonQueryContract setParameter(int position, P value, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameter(position, value);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine BindableType : " + javaType.getName());
                }
            }
            this.setParameter(position, value, (BindableType<P>)paramType);
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameter(int position, P value, BindableType<P> type) {
        this.locateBinding(position).setBindValue(value, type);
        return this;
    }

    @Override
    public CommonQueryContract setParameter(int position, Instant value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    public <P> CommonQueryContract setParameter(QueryParameter<P> parameter, P value) {
        this.locateBinding(parameter).setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameter(parameter, value);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine BindableType : " + javaType.getName());
                }
            }
            this.setParameter(parameter, value, (BindableType<P>)paramType);
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameter(QueryParameter<P> parameter, P value, BindableType<P> type) {
        this.locateBinding(parameter).setBindValue(value, type);
        return this;
    }

    public <P> CommonQueryContract setParameter(Parameter<P> parameter, P value) {
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedValue = (TypedParameterValue)value;
            BindableType type = typedValue.getType();
            if (type != null) {
                this.setParameter(parameter, typedValue.getValue(), type);
            } else {
                this.setParameter(parameter, typedValue.getValue(), typedValue.getTypeReference());
            }
        } else {
            this.locateBinding(parameter).setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        }
        return this;
    }

    private <P> void setParameter(Parameter<P> parameter, P value, BindableType<P> type) {
        if (parameter instanceof QueryParameter) {
            this.setParameter((QueryParameter)parameter, value, type);
        } else if (value == null) {
            this.locateBinding(parameter).setBindValue(null, type);
        } else if (value instanceof Collection) {
            this.locateBinding(parameter).setBindValues((Collection)value);
        } else {
            this.locateBinding(parameter).setBindValue(value, type);
        }
    }

    @Override
    public CommonQueryContract setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public CommonQueryContract setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public CommonQueryContract setParameter(String name, Calendar value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public CommonQueryContract setParameter(String name, Date value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public CommonQueryContract setParameter(int position, Calendar value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public CommonQueryContract setParameter(int position, Date value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public CommonQueryContract setParameterList(String name, Collection values) {
        this.locateBinding(name).setBindValues(values);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(name, values);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine BindableType : " + javaType.getName());
                }
            }
            this.setParameterList(name, values, (BindableType<P>)paramType);
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        this.locateBinding(name).setBindValues(values, type);
        return this;
    }

    @Override
    public CommonQueryContract setParameterList(String name, Object[] values) {
        this.locateBinding(name).setBindValues(Arrays.asList(values));
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(String name, P[] values, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(name, (Object[])values);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine BindableType : " + javaType.getName());
                }
            }
            this.setParameterList(name, values, (BindableType<P>)paramType);
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(String name, P[] values, BindableType<P> type) {
        this.locateBinding(name).setBindValues(Arrays.asList(values), type);
        return this;
    }

    @Override
    public CommonQueryContract setParameterList(int position, Collection values) {
        this.locateBinding(position).setBindValues(values);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(position, values);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine BindableType : " + javaType.getName());
                }
            }
            this.setParameterList(position, values, (BindableType<P>)paramType);
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        this.locateBinding(position).setBindValues(values, type);
        return this;
    }

    @Override
    public CommonQueryContract setParameterList(int position, Object[] values) {
        this.locateBinding(position).setBindValues(Arrays.asList(values));
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(int position, P[] values, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(position, (Object[])values);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine BindableType : " + javaType.getName());
                }
            }
            this.setParameterList(position, values, (BindableType<P>)paramType);
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(int position, P[] values, BindableType<P> type) {
        this.locateBinding(position).setBindValues(Arrays.asList(values), type);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        this.locateBinding(parameter).setBindValues(values);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(parameter, values);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine BindableType : " + javaType.getName());
                }
            }
            this.setParameterList(parameter, values, (BindableType<P>)paramType);
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        this.locateBinding(parameter).setBindValues(values, type);
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, P[] values) {
        this.locateBinding(parameter).setBindValues(values == null ? null : Arrays.asList(values));
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(parameter, values);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine BindableType : " + javaType.getName());
                }
            }
            this.setParameterList(parameter, values, (BindableType<P>)paramType);
        }
        return this;
    }

    @Override
    public <P> CommonQueryContract setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        this.locateBinding(parameter).setBindValues(Arrays.asList(values), type);
        return this;
    }

    @Override
    public CommonQueryContract setProperties(Map map) {
        for (String paramName : this.getParameterMetadata().getNamedParameterNames()) {
            Object object = map.get(paramName);
            if (object == null) {
                if (!map.containsKey(paramName)) continue;
                this.setParameter(paramName, null, this.determineType(paramName, null));
                continue;
            }
            if (object instanceof Collection) {
                this.setParameterList(paramName, (Collection)object);
                continue;
            }
            if (object instanceof Object[]) {
                this.setParameterList(paramName, (Object[])object);
                continue;
            }
            this.setParameter(paramName, object, this.determineType(paramName, object.getClass()));
        }
        return this;
    }

    protected BindableType<Object> determineType(String namedParam, Class<?> retType) {
        BindableType<Object> type = this.locateBinding(namedParam).getBindType();
        if (type == null) {
            type = this.getParameterMetadata().getQueryParameter(namedParam).getHibernateType();
        }
        if (type == null && retType != null) {
            type = this.getSession().getFactory().getMappingMetamodel().resolveParameterBindType(retType);
        }
        return type;
    }

    @Override
    public CommonQueryContract setProperties(Object bean) {
        Class<?> clazz = bean.getClass();
        for (String paramName : this.getParameterMetadata().getNamedParameterNames()) {
            try {
                PropertyAccess propertyAccess = BuiltInPropertyAccessStrategies.BASIC.getStrategy().buildPropertyAccess(clazz, paramName, true);
                Getter getter = propertyAccess.getGetter();
                Class<?> retType = getter.getReturnTypeClass();
                Object object = getter.get(bean);
                if (Collection.class.isAssignableFrom(retType)) {
                    this.setParameterList(paramName, (Collection)object);
                    continue;
                }
                if (retType.isArray()) {
                    this.setParameterList(paramName, (Object[])object);
                    continue;
                }
                BindableType<Object> type = this.determineType(paramName, retType);
                this.setParameter(paramName, object, type);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {}
        }
        return this;
    }
}

