/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.cbor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCtapCanonicalCborSerializer<T>
extends StdSerializer<T> {
    private final transient List<FieldSerializationRule<T, ?>> rules;

    protected AbstractCtapCanonicalCborSerializer(@NonNull Class<T> t, @NonNull List<FieldSerializationRule<T, ?>> rules) {
        super(t);
        this.rules = rules;
    }

    public void serialize(@NonNull T value, @NonNull JsonGenerator gen, @NonNull SerializerProvider provider) throws IOException {
        List nonNullValues = this.rules.stream().map(rule -> {
            Object fieldValue = rule.getGetter().apply(value);
            return new KeyValue(rule.getName(), fieldValue);
        }).filter(item -> ((KeyValue)item).value != null).collect(Collectors.toList());
        ((CBORGenerator)gen).writeStartObject(nonNullValues.size());
        for (KeyValue nonNullValue : nonNullValues) {
            if (nonNullValue.name instanceof String) {
                gen.writeFieldName((String)nonNullValue.name);
            } else {
                gen.writeFieldId((long)((Integer)nonNullValue.name).intValue());
            }
            gen.writeObject(nonNullValue.value);
        }
        gen.writeEndObject();
    }

    private static class KeyValue {
        private final @NonNull Object name;
        private final @Nullable Object value;

        public KeyValue(@NonNull Object name, @Nullable Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class FieldSerializationRule<T, R> {
        private final @NonNull Object name;
        private final @NonNull Function<T, R> getter;

        public FieldSerializationRule(int name, @NonNull Function<T, @Nullable R> getter) {
            this.name = name;
            this.getter = getter;
        }

        public FieldSerializationRule(@NonNull String name, @NonNull Function<T, @Nullable R> getter) {
            this.name = name;
            this.getter = getter;
        }

        public @NonNull Object getName() {
            return this.name;
        }

        public @NonNull Function<T, @NonNull R> getGetter() {
            return this.getter;
        }
    }
}

