/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ResidentKeyRequirement
implements Serializable {
    public static final ResidentKeyRequirement DISCOURAGED = new ResidentKeyRequirement("discouraged");
    public static final ResidentKeyRequirement PREFERRED = new ResidentKeyRequirement("preferred");
    public static final ResidentKeyRequirement REQUIRED = new ResidentKeyRequirement("required");
    private final String value;

    private ResidentKeyRequirement(@NonNull String value) {
        this.value = value;
    }

    @JsonCreator
    public static @NonNull ResidentKeyRequirement create(@NonNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        switch (value) {
            case "discouraged": {
                return DISCOURAGED;
            }
            case "preferred": {
                return PREFERRED;
            }
            case "required": {
                return REQUIRED;
            }
        }
        return new ResidentKeyRequirement(value);
    }

    @JsonValue
    public @NonNull String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResidentKeyRequirement that = (ResidentKeyRequirement)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

