/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.SharedErrors;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.Messages;
import jakarta.enterprise.inject.build.compatible.spi.ObserverInfo;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.lang.model.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.Logger;

class MessagesImpl
implements Messages {
    private final SharedErrors errors;
    private final Logger log;

    MessagesImpl(SharedErrors errors, ClassInfo extensionClass) {
        this.errors = errors;
        this.log = Logger.getLogger((String)extensionClass.name().toString());
    }

    public void info(String message) {
        this.log.info((Object)message);
    }

    public void info(String message, AnnotationTarget relatedTo) {
        this.log.info((Object)(message + " at " + relatedTo));
    }

    public void info(String message, BeanInfo relatedTo) {
        this.log.info((Object)(message + " at " + relatedTo));
    }

    public void info(String message, ObserverInfo relatedTo) {
        this.log.info((Object)(message + " at " + relatedTo));
    }

    public void warn(String message) {
        this.log.warn((Object)message);
    }

    public void warn(String message, AnnotationTarget relatedTo) {
        this.log.warn((Object)(message + " at " + relatedTo));
    }

    public void warn(String message, BeanInfo relatedTo) {
        this.log.warn((Object)(message + " at " + relatedTo));
    }

    public void warn(String message, ObserverInfo relatedTo) {
        this.log.warn((Object)(message + " at " + relatedTo));
    }

    public void error(String message) {
        this.log.error((Object)message);
        this.errors.add(new DeploymentException(message));
    }

    public void error(String message, AnnotationTarget relatedTo) {
        this.log.error((Object)(message + " at " + relatedTo));
        this.errors.add(new DeploymentException(message + " at " + relatedTo));
    }

    public void error(String message, BeanInfo relatedTo) {
        this.log.error((Object)(message + " at " + relatedTo));
        this.errors.add(new DeploymentException(message + " at " + relatedTo));
    }

    public void error(String message, ObserverInfo relatedTo) {
        this.log.error((Object)(message + " at " + relatedTo));
        this.errors.add(new DeploymentException(message + " at " + relatedTo));
    }

    public void error(Exception exception) {
        this.log.error((Object)exception.getMessage());
        this.errors.add(exception);
    }
}

