/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.scheduler;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.quarkus.scheduler.spi.JobInstrumenter;
import jakarta.inject.Singleton;
import java.util.concurrent.CompletionStage;

@Singleton
public class OpenTelemetryJobInstrumenter
implements JobInstrumenter {
    private final Instrumenter<JobInstrumenter.JobInstrumentationContext, Void> instrumenter;

    public OpenTelemetryJobInstrumenter(OpenTelemetry openTelemetry) {
        InstrumenterBuilder instrumenterBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)new SpanNameExtractor<JobInstrumenter.JobInstrumentationContext>(){

            public String extract(JobInstrumenter.JobInstrumentationContext context) {
                return context.getSpanName();
            }
        });
        instrumenterBuilder.setErrorCauseExtractor(new ErrorCauseExtractor(){

            public Throwable extract(Throwable throwable) {
                return throwable;
            }
        });
        this.instrumenter = instrumenterBuilder.buildInstrumenter();
    }

    public CompletionStage<Void> instrument(JobInstrumenter.JobInstrumentationContext instrumentationContext) {
        Context parentCtx = Context.current();
        Context context = this.instrumenter.start(parentCtx, (Object)instrumentationContext);
        try (Scope scope = context.makeCurrent();){
            CompletionStage<Void> completionStage = instrumentationContext.executeJob().whenComplete((result, throwable) -> this.instrumenter.end(context, (Object)instrumentationContext, null, throwable));
            return completionStage;
        }
    }
}

