/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.SharedSessionContract;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.BlobProxy;
import org.hibernate.engine.jdbc.WrappedBlob;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class BlobJavaType
extends AbstractClassJavaType<Blob> {
    public static final BlobJavaType INSTANCE = new BlobJavaType();

    public BlobJavaType() {
        super(Blob.class, BlobMutabilityPlan.INSTANCE, IncomparableComparator.INSTANCE);
    }

    @Override
    public String extractLoggableRepresentation(Blob value) {
        return value == null ? "null" : "{blob}";
    }

    @Override
    public String toString(Blob value) {
        byte[] bytes;
        try {
            bytes = DataHelper.extractBytes(value.getBinaryStream());
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access blob stream", e);
        }
        return PrimitiveByteArrayJavaType.INSTANCE.toString(bytes);
    }

    @Override
    public Blob fromString(CharSequence string) {
        return BlobProxy.generateProxy(PrimitiveByteArrayJavaType.INSTANCE.fromString(string));
    }

    @Override
    public int extractHashCode(Blob value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(Blob one, Blob another) {
        return one == another;
    }

    @Override
    public Blob getReplacement(Blob original, Blob target, SharedSessionContractImplementor session) {
        return session.getJdbcServices().getJdbcEnvironment().getDialect().getLobMergeStrategy().mergeBlob(original, target, session);
    }

    @Override
    public <X> X unwrap(Blob value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        try {
            if (BinaryStream.class.isAssignableFrom(type)) {
                if (value instanceof BlobImplementer) {
                    return (X)((BlobImplementer)((Object)value)).getUnderlyingStream();
                }
                return (X)new BinaryStreamImpl(DataHelper.extractBytes(value.getBinaryStream()));
            }
            if (byte[].class.isAssignableFrom(type)) {
                if (value instanceof BlobImplementer) {
                    return (X)((BlobImplementer)((Object)value)).getUnderlyingStream().getBytes();
                }
                return (X)DataHelper.extractBytes(value.getBinaryStream());
            }
            if (Blob.class.isAssignableFrom(type)) {
                Blob blob = value instanceof WrappedBlob ? ((WrappedBlob)((Object)value)).getWrappedBlob() : this.getOrCreateBlob(value, options);
                return (X)blob;
            }
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access blob stream", e);
        }
        throw this.unknownUnwrap(type);
    }

    private Blob getOrCreateBlob(Blob value, WrapperOptions options) throws SQLException {
        if (options.getDialect().useConnectionToCreateLob()) {
            if (value.length() == 0L) {
                return options.getLobCreator().createBlob(new byte[0]);
            }
            return options.getLobCreator().createBlob(value.getBytes(1L, (int)value.length()));
        }
        return value;
    }

    @Override
    public <X> Blob wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Blob.class.isAssignableFrom(value.getClass())) {
            return options.getLobCreator().wrap((Blob)value);
        }
        if (byte[].class.isAssignableFrom(value.getClass())) {
            return options.getLobCreator().createBlob((byte[])value);
        }
        if (InputStream.class.isAssignableFrom(value.getClass())) {
            InputStream inputStream = (InputStream)value;
            try {
                return options.getLobCreator().createBlob(inputStream, inputStream.available());
            }
            catch (IOException e) {
                throw this.unknownWrap(value.getClass());
            }
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultLobLength();
    }

    public static class BlobMutabilityPlan
    implements MutabilityPlan<Blob> {
        public static final BlobMutabilityPlan INSTANCE = new BlobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public Blob deepCopy(Blob value) {
            return value;
        }

        @Override
        public Serializable disassemble(Blob value, SharedSessionContract session) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }

        @Override
        public Blob assemble(Serializable cached, SharedSessionContract session) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }
    }
}

