/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.server.runtime.QuarkusContextProducers;
import io.quarkus.resteasy.reactive.server.spi.SubResourcesAsBeansBuildItem;
import io.quarkus.resteasy.reactive.spi.DynamicFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.JaxrsFeatureBuildItem;
import jakarta.ws.rs.BeanParam;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.server.injection.ContextProducers;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;

public class ResteasyReactiveCDIProcessor {
    @BuildStep
    AutoInjectAnnotationBuildItem contextInjection(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        additionalBeanBuildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{ContextProducers.class, QuarkusContextProducers.class}).build());
        return new AutoInjectAnnotationBuildItem(new DotName[]{ResteasyReactiveServerDotNames.CONTEXT, DotName.createSimple((String)BeanParam.class.getName())});
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyReactiveDotNames.PATH, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyReactiveDotNames.APPLICATION_PATH, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyReactiveDotNames.PROVIDER, BuiltinScope.SINGLETON.getName()));
    }

    @BuildStep
    void unremovableContextMethodParams(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<UnremovableBeanBuildItem> producer) {
        if (resourceScanningResultBuildItem.isEmpty()) {
            return;
        }
        Collection resourceClasses = resourceScanningResultBuildItem.get().getResult().getScannedResources().values();
        for (ClassInfo resourceClass : resourceClasses) {
            if (!resourceClass.annotationsMap().containsKey(ResteasyReactiveDotNames.CONTEXT)) continue;
            for (AnnotationInstance instance : (List)resourceClass.annotationsMap().get(ResteasyReactiveDotNames.CONTEXT)) {
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) continue;
                producer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{instance.target().asMethodParameter().type().name()}));
            }
        }
    }

    @BuildStep
    void perClassExceptionMapperSupport(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<AnnotationsTransformerBuildItem> producer) {
        if (resourceScanningResultBuildItem.isEmpty()) {
            return;
        }
        List methodExceptionMapper = resourceScanningResultBuildItem.get().getResult().getClassLevelExceptionMappers();
        if (methodExceptionMapper.isEmpty()) {
            return;
        }
        producer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                Collection annotations = ctx.getAnnotations();
                AnnotationInstance serverExceptionMapper = Annotations.find((Collection)annotations, (DotName)ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER);
                if (serverExceptionMapper == null) {
                    return;
                }
                ctx.transform().add(DotNames.NO_CLASS_INTERCEPTORS, new AnnotationValue[0]).done();
            }
        }));
    }

    @BuildStep
    void subResourcesAsBeans(ResourceScanningResultBuildItem setupEndpointsResult, List<SubResourcesAsBeansBuildItem> subResourcesAsBeans, BuildProducer<UnremovableBeanBuildItem> unremovableProducer, BuildProducer<AdditionalBeanBuildItem> additionalProducer) {
        Map possibleSubResources = setupEndpointsResult.getResult().getPossibleSubResources();
        if (possibleSubResources.isEmpty()) {
            return;
        }
        unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(possibleSubResources.keySet()));
        if (subResourcesAsBeans.isEmpty()) {
            return;
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        for (DotName subResourceClass : possibleSubResources.keySet()) {
            builder.addBeanClass(subResourceClass.toString());
        }
        additionalProducer.produce((BuildItem)builder.build());
    }

    @BuildStep
    void pathInterfaceImpls(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        ResourceScanningResult resourceScanningResult = resourceScanningResultBuildItem.get().getResult();
        Map pathInterfaces = resourceScanningResult.getPathInterfaces();
        ArrayList<String> impls = new ArrayList<String>();
        for (Map.Entry i : pathInterfaces.entrySet()) {
            ArrayList<ClassInfo> candidateBeans = new ArrayList<ClassInfo>(1);
            for (ClassInfo clazz : resourceScanningResult.getIndex().getAllKnownImplementors((DotName)i.getKey())) {
                if (Modifier.isAbstract(clazz.flags()) || clazz.enclosingClass() != null && !Modifier.isStatic(clazz.flags()) || clazz.enclosingMethod() != null) continue;
                candidateBeans.add(clazz);
            }
            if (candidateBeans.size() != 1) continue;
            impls.add(((ClassInfo)candidateBeans.get(0)).name().toString());
        }
        if (!impls.isEmpty()) {
            additionalBeanBuildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(impls.toArray(new String[0])).build());
        }
    }

    @BuildStep
    void additionalBeans(List<DynamicFeatureBuildItem> additionalDynamicFeatures, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, List<JaxrsFeatureBuildItem> featureBuildItems, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        AdditionalBeanBuildItem.Builder additionalProviders = AdditionalBeanBuildItem.builder();
        for (DynamicFeatureBuildItem dynamicFeature : additionalDynamicFeatures) {
            if (dynamicFeature.isRegisterAsBean()) {
                additionalProviders.addBeanClass(dynamicFeature.getClassName());
                continue;
            }
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{dynamicFeature.getClassName()}).build());
        }
        for (JaxrsFeatureBuildItem feature : featureBuildItems) {
            if (feature.isRegisterAsBean()) {
                additionalProviders.addBeanClass(feature.getClassName());
                continue;
            }
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{feature.getClassName()}).build());
        }
        additionalBean.produce((BuildItem)additionalProviders.setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
    }
}

