/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.infinispan.TaskCallback;
import org.keycloak.cluster.infinispan.WrapperClusterEvent;
import org.keycloak.common.util.ConcurrentMultivaluedHashMap;
import org.keycloak.common.util.Retry;
import org.keycloak.connections.infinispan.TopologyInfo;

@ClientListener
public class RemoteInfinispanNotificationManager {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final ConcurrentMap<String, TaskCallback> taskCallbacks = new ConcurrentHashMap<String, TaskCallback>();
    private final ConcurrentMultivaluedHashMap<String, ClusterListener> listeners = new ConcurrentMultivaluedHashMap();
    private final Executor executor;
    private final RemoteCache<String, Object> workCache;
    private final TopologyInfo topologyInfo;

    public RemoteInfinispanNotificationManager(Executor executor, RemoteCache<String, Object> workCache, TopologyInfo topologyInfo) {
        this.executor = executor;
        this.workCache = workCache;
        this.topologyInfo = topologyInfo;
    }

    public void addClientListener() {
        this.workCache.addClientListener((Object)this);
    }

    public void removeClientListener() {
        if (this.workCache.getRemoteCacheContainer().isStarted()) {
            this.workCache.removeClientListener((Object)this);
        }
    }

    public void registerListener(String taskKey, ClusterListener task) {
        this.listeners.add((Object)taskKey, (Object)task);
    }

    public TaskCallback registerTaskCallback(String taskKey, TaskCallback callback) {
        TaskCallback existing = this.taskCallbacks.putIfAbsent(taskKey, callback);
        return existing != null ? existing : callback;
    }

    public void notify(String taskKey, Collection<? extends ClusterEvent> events, boolean ignoreSender, ClusterProvider.DCNotify dcNotify) {
        if (events == null || events.isEmpty()) {
            return;
        }
        WrapperClusterEvent wrappedEvent = WrapperClusterEvent.wrap(taskKey, events, this.topologyInfo.getMyNodeName(), this.topologyInfo.getMySiteName(), dcNotify, ignoreSender);
        String eventKey = UUID.randomUUID().toString();
        if (logger.isTraceEnabled()) {
            logger.tracef("Sending event with key %s: %s", (Object)eventKey, events);
        }
        Retry.executeWithBackoff(iteration -> {
            try {
                this.workCache.put((Object)eventKey, (Object)wrappedEvent, 120L, TimeUnit.SECONDS);
            }
            catch (HotRodClientException re) {
                if (logger.isDebugEnabled()) {
                    logger.debugf((Throwable)re, "Failed sending notification to remote cache '%s'. Key: '%s', iteration '%s'. Will try to retry the task", (Object)this.workCache.getName(), (Object)eventKey, (Object)iteration);
                }
                throw re;
            }
        }, (int)10, (int)10);
    }

    public String getMyNodeName() {
        return this.topologyInfo.getMyNodeName();
    }

    @ClientCacheEntryCreated
    public void created(ClientCacheEntryCreatedEvent<String> event) {
        String key = (String)event.getKey();
        this.hotrodEventReceived(key);
    }

    @ClientCacheEntryModified
    public void updated(ClientCacheEntryModifiedEvent<String> event) {
        String key = (String)event.getKey();
        this.hotrodEventReceived(key);
    }

    @ClientCacheEntryRemoved
    public void removed(ClientCacheEntryRemovedEvent<String> event) {
        String key = (String)event.getKey();
        this.taskFinished(key);
    }

    private void hotrodEventReceived(String key) {
        this.workCache.getAsync((Object)key).thenAcceptAsync(value -> this.eventReceived(key, value), this.executor);
    }

    private void eventReceived(String key, Object obj) {
        List myListeners;
        if (!(obj instanceof WrapperClusterEvent)) {
            if (obj == null && !key.startsWith("task::")) {
                logger.warnf("Event object wasn't available in remote cache after event was received. Event key: %s", (Object)key);
            }
            return;
        }
        WrapperClusterEvent event = (WrapperClusterEvent)obj;
        if (event.rejectEvent(this.topologyInfo.getMyNodeName(), this.topologyInfo.getMySiteName())) {
            return;
        }
        String eventKey = event.getEventKey();
        if (logger.isTraceEnabled()) {
            logger.tracef("Received event: %s", (Object)event);
        }
        if ((myListeners = (List)this.listeners.get((Object)eventKey)) != null) {
            for (ClusterEvent clusterEvent : event.getDelegateEvents()) {
                myListeners.forEach(clusterEvent);
            }
        }
    }

    private void taskFinished(String taskKey) {
        TaskCallback callback = (TaskCallback)this.taskCallbacks.remove(taskKey);
        if (callback == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("Finished task '%s' with '%b'", (Object)taskKey, (Object)true);
        }
        callback.setSuccess(true);
        callback.getTaskCompletedLatch().countDown();
    }
}

