/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.organization;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.DefaultLazyLoader;
import org.keycloak.models.cache.infinispan.LazyLoader;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedOrganization
extends AbstractRevisioned
implements InRealm {
    private final String realm;
    private final String name;
    private final String alias;
    private final String description;
    private final String redirectUrl;
    private final boolean enabled;
    private final LazyLoader<OrganizationModel, MultivaluedHashMap<String, String>> attributes;
    private final Set<OrganizationDomainModel> domains;
    private final Set<IdentityProviderModel> idps;

    public CachedOrganization(Long revision, RealmModel realm, OrganizationModel organization) {
        super(revision, organization.getId());
        this.realm = realm.getId();
        this.name = organization.getName();
        this.alias = organization.getAlias();
        this.description = organization.getDescription();
        this.redirectUrl = organization.getRedirectUrl();
        this.enabled = organization.isEnabled();
        this.attributes = new DefaultLazyLoader<OrganizationModel, MultivaluedHashMap>(orgModel -> new MultivaluedHashMap(orgModel.getAttributes()), MultivaluedHashMap::new);
        this.domains = organization.getDomains().collect(Collectors.toSet());
        this.idps = organization.getIdentityProviders().collect(Collectors.toSet());
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MultivaluedHashMap<String, String> getAttributes(Supplier<OrganizationModel> organizationModel) {
        return this.attributes.get(organizationModel);
    }

    public Stream<OrganizationDomainModel> getDomains() {
        return this.domains.stream();
    }

    public Stream<IdentityProviderModel> getIdentityProviders() {
        return this.idps.stream();
    }
}

