/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.DotNames;
import io.quarkus.arc.processor.bcextensions.ExtensionMethod;
import io.quarkus.arc.processor.bcextensions.ExtensionPhase;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

enum ExtensionMethodParameter {
    META_ANNOTATIONS(DotNames.META_ANNOTATIONS, false, ExtensionPhase.DISCOVERY),
    SCANNED_CLASSES(DotNames.SCANNED_CLASSES, false, ExtensionPhase.DISCOVERY),
    CLASS_INFO(DotNames.CLASS_INFO, true, ExtensionPhase.ENHANCEMENT),
    METHOD_INFO(DotNames.METHOD_INFO, true, ExtensionPhase.ENHANCEMENT),
    FIELD_INFO(DotNames.FIELD_INFO, true, ExtensionPhase.ENHANCEMENT),
    CLASS_CONFIG(DotNames.CLASS_CONFIG, true, ExtensionPhase.ENHANCEMENT),
    METHOD_CONFIG(DotNames.METHOD_CONFIG, true, ExtensionPhase.ENHANCEMENT),
    FIELD_CONFIG(DotNames.FIELD_CONFIG, true, ExtensionPhase.ENHANCEMENT),
    BEAN_INFO(DotNames.BEAN_INFO, true, ExtensionPhase.REGISTRATION),
    INTERCEPTOR_INFO(DotNames.INTERCEPTOR_INFO, true, ExtensionPhase.REGISTRATION),
    OBSERVER_INFO(DotNames.OBSERVER_INFO, true, ExtensionPhase.REGISTRATION),
    INVOKER_FACTORY(DotNames.INVOKER_FACTORY, false, ExtensionPhase.REGISTRATION),
    SYNTHETIC_COMPONENTS(DotNames.SYNTHETIC_COMPONENTS, false, ExtensionPhase.SYNTHESIS),
    MESSAGES(DotNames.MESSAGES, false, ExtensionPhase.DISCOVERY, ExtensionPhase.ENHANCEMENT, ExtensionPhase.REGISTRATION, ExtensionPhase.SYNTHESIS, ExtensionPhase.VALIDATION),
    TYPES(DotNames.TYPES, false, ExtensionPhase.ENHANCEMENT, ExtensionPhase.REGISTRATION, ExtensionPhase.SYNTHESIS, ExtensionPhase.VALIDATION),
    UNKNOWN(null, false, new ExtensionPhase[0]);

    private final DotName typeName;
    private final boolean isQuery;
    private final Set<ExtensionPhase> validPhases;

    private ExtensionMethodParameter(DotName typeName, boolean isQuery, ExtensionPhase ... validPhases) {
        this.typeName = typeName;
        this.isQuery = isQuery;
        this.validPhases = validPhases == null || validPhases.length == 0 ? EnumSet.noneOf(ExtensionPhase.class) : EnumSet.copyOf(Arrays.asList(validPhases));
    }

    boolean isQuery() {
        return this.isQuery;
    }

    void verifyAvailable(ExtensionPhase phase, ExtensionMethod method) {
        if (!this.validPhases.contains((Object)phase)) {
            throw new IllegalArgumentException(phase + " methods can't declare a parameter of type " + (this.typeName != null ? this.typeName.withoutPackagePrefix() : this.name()) + ", found at " + method);
        }
    }

    static ExtensionMethodParameter of(Type type) {
        if (type.kind() == Type.Kind.CLASS) {
            for (ExtensionMethodParameter candidate : ExtensionMethodParameter.values()) {
                if (!candidate.typeName.equals((Object)type.name())) continue;
                return candidate;
            }
        }
        return UNKNOWN;
    }
}

