/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.JsonTransform;
import io.quarkus.builder.json.JsonArray;
import io.quarkus.builder.json.JsonBoolean;
import io.quarkus.builder.json.JsonInteger;
import io.quarkus.builder.json.JsonMember;
import io.quarkus.builder.json.JsonMultiValue;
import io.quarkus.builder.json.JsonObject;
import io.quarkus.builder.json.JsonString;
import io.quarkus.builder.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;

public final class Json {
    private static final String OBJECT_START = "{";
    private static final String OBJECT_END = "}";
    private static final String ARRAY_START = "[";
    private static final String ARRAY_END = "]";
    private static final String NAME_VAL_SEPARATOR = ":";
    private static final String ENTRY_SEPARATOR = ",";
    private static final int CONTROL_CHAR_START = 0;
    private static final int CONTROL_CHAR_END = 31;
    private static final char CHAR_QUOTATION_MARK = '\"';
    private static final Map<Character, String> REPLACEMENTS = new HashMap<Character, String>();

    private Json() {
    }

    public static JsonArrayBuilder array() {
        return new JsonArrayBuilder(false, false);
    }

    public static JsonArrayBuilder array(boolean ignoreEmptyBuilders, boolean skipEscapeCharacters) {
        return new JsonArrayBuilder(ignoreEmptyBuilders, skipEscapeCharacters);
    }

    public static JsonObjectBuilder object() {
        return new JsonObjectBuilder(false, false);
    }

    public static JsonObjectBuilder object(boolean ignoreEmptyBuilders, boolean skipEscapeCharacters) {
        return new JsonObjectBuilder(ignoreEmptyBuilders, skipEscapeCharacters);
    }

    static void appendValue(Appendable appendable, Object value, boolean skipEscapeCharacters) throws IOException {
        if (value instanceof JsonObjectBuilder) {
            appendable.append(((JsonObjectBuilder)value).build());
        } else if (value instanceof JsonArrayBuilder) {
            appendable.append(((JsonArrayBuilder)value).build());
        } else if (value instanceof String) {
            Json.appendStringValue(appendable, value.toString(), skipEscapeCharacters);
        } else if (value instanceof Boolean || value instanceof Integer || value instanceof Long) {
            appendable.append(value.toString());
        } else {
            throw new IllegalStateException("Unsupported value type: " + value);
        }
    }

    static void appendStringValue(Appendable appendable, String value, boolean skipEscapeCharacters) throws IOException {
        appendable.append('\"');
        if (skipEscapeCharacters) {
            appendable.append(value);
        } else {
            appendable.append(Json.escape(value));
        }
        appendable.append('\"');
    }

    static String escape(String value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String replacement = REPLACEMENTS.get(Character.valueOf(c));
            if (replacement != null) {
                builder.append(replacement);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            REPLACEMENTS.put(Character.valueOf((char)i), String.format("\\u%04x", i));
        }
        REPLACEMENTS.put(Character.valueOf('\"'), "\\\"");
        REPLACEMENTS.put(Character.valueOf('\\'), "\\\\");
    }

    public static class JsonArrayBuilder
    extends JsonBuilder<JsonArrayBuilder> {
        private final List<Object> values = new ArrayList<Object>();

        private JsonArrayBuilder(boolean ignoreEmptyBuilders, boolean skipEscapeCharacters) {
            super(ignoreEmptyBuilders, skipEscapeCharacters);
        }

        JsonArrayBuilder add(JsonArrayBuilder value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(JsonObjectBuilder value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(String value) {
            this.addInternal(value);
            return this;
        }

        JsonArrayBuilder add(boolean value) {
            this.addInternal(value);
            return this;
        }

        JsonArrayBuilder add(int value) {
            this.addInternal(value);
            return this;
        }

        JsonArrayBuilder add(long value) {
            this.addInternal(value);
            return this;
        }

        JsonArrayBuilder addAll(List<JsonObjectBuilder> value) {
            if (value != null && !value.isEmpty()) {
                this.values.addAll(value);
            }
            return this;
        }

        void addInternal(Object value) {
            if (value != null) {
                this.values.add(value);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.isValuesEmpty(this.values);
        }

        @Override
        String build() throws IOException {
            StringBuilder builder = new StringBuilder();
            this.appendTo(builder);
            return builder.toString();
        }

        @Override
        public void appendTo(Appendable appendable) throws IOException {
            appendable.append(Json.ARRAY_START);
            int idx = 0;
            ListIterator<Object> iterator = this.values.listIterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (this.isIgnored(value)) continue;
                if (++idx > 1) {
                    appendable.append(Json.ENTRY_SEPARATOR);
                }
                Json.appendValue(appendable, value, this.skipEscapeCharacters);
            }
            appendable.append(Json.ARRAY_END);
        }

        @Override
        protected JsonArrayBuilder self() {
            return this;
        }

        @Override
        void add(JsonValue element) {
            if (element instanceof JsonString) {
                this.add(((JsonString)element).value());
            } else if (element instanceof JsonInteger) {
                int intValue;
                long longValue = ((JsonInteger)element).longValue();
                if (longValue == (long)(intValue = (int)longValue)) {
                    this.add(intValue);
                } else {
                    this.add(longValue);
                }
            } else if (element instanceof JsonBoolean) {
                this.add(((JsonBoolean)element).value());
            } else if (element instanceof JsonArray) {
                JsonArrayBuilder arrayBuilder = Json.array(this.ignoreEmptyBuilders, this.skipEscapeCharacters);
                arrayBuilder.transform((JsonArray)element, this.transform);
                this.add(arrayBuilder);
            } else if (element instanceof JsonObject) {
                JsonObjectBuilder objectBuilder = Json.object(this.ignoreEmptyBuilders, this.skipEscapeCharacters);
                objectBuilder.transform((JsonObject)element, this.transform);
                if (!objectBuilder.isEmpty()) {
                    this.add(objectBuilder);
                }
            }
        }
    }

    public static class JsonObjectBuilder
    extends JsonBuilder<JsonObjectBuilder> {
        private final Map<String, Object> properties = new HashMap<String, Object>();

        private JsonObjectBuilder(boolean ignoreEmptyBuilders, boolean skipEscapeCharacters) {
            super(ignoreEmptyBuilders, skipEscapeCharacters);
        }

        public JsonObjectBuilder put(String name, String value) {
            this.putInternal(name, value);
            return this;
        }

        public JsonObjectBuilder put(String name, JsonObjectBuilder value) {
            this.putInternal(name, value);
            return this;
        }

        public JsonObjectBuilder put(String name, JsonArrayBuilder value) {
            this.putInternal(name, value);
            return this;
        }

        public JsonObjectBuilder put(String name, boolean value) {
            this.putInternal(name, value);
            return this;
        }

        JsonObjectBuilder put(String name, int value) {
            this.putInternal(name, value);
            return this;
        }

        JsonObjectBuilder put(String name, long value) {
            this.putInternal(name, value);
            return this;
        }

        boolean has(String name) {
            return this.properties.containsKey(name);
        }

        void putInternal(String name, Object value) {
            Objects.requireNonNull(name);
            if (value != null) {
                this.properties.put(name, value);
            }
        }

        @Override
        public boolean isEmpty() {
            if (this.properties.isEmpty()) {
                return true;
            }
            return this.isValuesEmpty(this.properties.values());
        }

        @Override
        String build() throws IOException {
            StringBuilder builder = new StringBuilder();
            this.appendTo(builder);
            return builder.toString();
        }

        @Override
        public void appendTo(Appendable appendable) throws IOException {
            appendable.append(Json.OBJECT_START);
            int idx = 0;
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                if (this.isIgnored(entry.getValue())) continue;
                if (++idx > 1) {
                    appendable.append(Json.ENTRY_SEPARATOR);
                }
                Json.appendStringValue(appendable, entry.getKey(), this.skipEscapeCharacters);
                appendable.append(Json.NAME_VAL_SEPARATOR);
                Json.appendValue(appendable, entry.getValue(), this.skipEscapeCharacters);
            }
            appendable.append(Json.OBJECT_END);
        }

        @Override
        protected JsonObjectBuilder self() {
            return this;
        }

        @Override
        void add(JsonValue element) {
            if (element instanceof JsonMember) {
                JsonMember member = (JsonMember)element;
                String attribute = member.attribute().value();
                JsonValue value = member.value();
                if (value instanceof JsonString) {
                    this.put(attribute, ((JsonString)value).value());
                } else if (value instanceof JsonInteger) {
                    int intValue;
                    long longValue = ((JsonInteger)value).longValue();
                    if (longValue == (long)(intValue = (int)longValue)) {
                        this.put(attribute, intValue);
                    } else {
                        this.put(attribute, longValue);
                    }
                } else if (value instanceof JsonBoolean) {
                    boolean booleanValue = ((JsonBoolean)value).value();
                    this.put(attribute, booleanValue);
                } else if (value instanceof JsonArray) {
                    JsonArrayBuilder arrayBuilder = Json.array(this.ignoreEmptyBuilders, this.skipEscapeCharacters);
                    arrayBuilder.transform((JsonArray)value, this.transform);
                    this.put(attribute, arrayBuilder);
                } else if (value instanceof JsonObject) {
                    JsonObjectBuilder objectBuilder = Json.object(this.ignoreEmptyBuilders, this.skipEscapeCharacters);
                    objectBuilder.transform((JsonObject)value, this.transform);
                    if (!objectBuilder.isEmpty()) {
                        this.put(attribute, objectBuilder);
                    }
                }
            }
        }
    }

    private static final class ResolvedTransform
    implements JsonTransform {
        private final JsonBuilder<?> resolvedBuilder;
        private final JsonTransform transform;

        private ResolvedTransform(JsonBuilder<?> resolvedBuilder, JsonTransform transform) {
            this.resolvedBuilder = resolvedBuilder;
            this.resolvedBuilder.setTransform(transform);
            this.transform = transform;
        }

        @Override
        public void accept(JsonBuilder<?> builder, JsonValue element) {
            if (builder == null) {
                this.transform.accept(this.resolvedBuilder, element);
            }
        }
    }

    public static abstract class JsonBuilder<T> {
        protected final boolean ignoreEmptyBuilders;
        protected final boolean skipEscapeCharacters;
        protected JsonTransform transform;

        JsonBuilder(boolean ignoreEmptyBuilders, boolean skipEscapeCharacters) {
            this.ignoreEmptyBuilders = ignoreEmptyBuilders;
            this.skipEscapeCharacters = skipEscapeCharacters;
        }

        abstract boolean isEmpty();

        abstract String build() throws IOException;

        abstract void appendTo(Appendable var1) throws IOException;

        protected boolean isIgnored(Object value) {
            return value == null || this.ignoreEmptyBuilders && value instanceof JsonBuilder && ((JsonBuilder)value).isEmpty();
        }

        protected boolean isValuesEmpty(Collection<Object> values) {
            if (values.isEmpty()) {
                return true;
            }
            for (Object object : values) {
                if (object instanceof JsonBuilder) {
                    if (((JsonBuilder)object).isEmpty()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        protected abstract T self();

        abstract void add(JsonValue var1);

        void setTransform(JsonTransform transform) {
            this.transform = transform;
        }

        public void transform(JsonMultiValue value, JsonTransform transform) {
            ResolvedTransform resolved = new ResolvedTransform(this, transform);
            value.forEach(resolved);
        }
    }
}

