/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.KeyProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigurationBuilder;

public abstract class AbstractEcKeyProviderFactory<T extends KeyProvider>
implements KeyProviderFactory<T> {
    public static final String DEFAULT_EC_ELLIPTIC_CURVE = "P-256";

    public static final ProviderConfigurationBuilder configurationBuilder() {
        return ProviderConfigurationBuilder.create().property(Attributes.PRIORITY_PROPERTY).property(Attributes.ENABLED_PROPERTY).property(Attributes.ACTIVE_PROPERTY);
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)model).checkLong(Attributes.PRIORITY_PROPERTY, false).checkBoolean(Attributes.ENABLED_PROPERTY, false).checkBoolean(Attributes.ACTIVE_PROPERTY, false);
    }

    public static KeyPair generateEcKeyPair(String keySpecName) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
            SecureRandom randomGen = SecureRandom.getInstance("SHA1PRNG");
            ECGenParameterSpec ecSpec = new ECGenParameterSpec(keySpecName);
            keyGen.initialize(ecSpec, randomGen);
            return keyGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertECDomainParmNistRepToSecRep(String ecInNistRep) {
        String ecInSecRep = null;
        switch (ecInNistRep) {
            case "P-256": {
                ecInSecRep = "secp256r1";
                break;
            }
            case "P-384": {
                ecInSecRep = "secp384r1";
                break;
            }
            case "P-521": {
                ecInSecRep = "secp521r1";
                break;
            }
        }
        return ecInSecRep;
    }
}

