/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public abstract class RoleResource {
    protected RealmModel realm;

    public RoleResource(RealmModel realm) {
        this.realm = realm;
    }

    protected RoleRepresentation getRole(RoleModel roleModel) {
        return ModelToRepresentation.toRepresentation((RoleModel)roleModel);
    }

    protected void deleteRole(RoleModel role) {
        if (!role.getContainer().removeRole(role)) {
            throw new NotFoundException("Role not found");
        }
    }

    protected void updateRole(RoleRepresentation rep, final RoleModel role, final RealmModel realm, final KeycloakSession session) {
        final String newName = rep.getName();
        final String previousName = role.getName();
        if (!Objects.equals(previousName, newName)) {
            role.setName(newName);
            session.getKeycloakSessionFactory().publish((ProviderEvent)new RoleModel.RoleNameChangeEvent(){

                public RealmModel getRealm() {
                    return realm;
                }

                public String getNewName() {
                    return newName;
                }

                public String getPreviousName() {
                    return previousName;
                }

                public String getClientId() {
                    if (!role.isClientRole()) {
                        return null;
                    }
                    return ((ClientModel)role.getContainer()).getClientId();
                }

                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
        role.setDescription(rep.getDescription());
        if (rep.getAttributes() != null) {
            HashSet attrsToRemove = new HashSet(role.getAttributes().keySet());
            attrsToRemove.removeAll(rep.getAttributes().keySet());
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                role.setAttribute((String)entry.getKey(), (List)entry.getValue());
            }
            for (String string : attrsToRemove) {
                role.removeAttribute(string);
            }
        }
    }

    protected void addComposites(AdminPermissionEvaluator auth, AdminEventBuilder adminEvent, UriInfo uriInfo, List<RoleRepresentation> roles, RoleModel role) {
        for (RoleRepresentation rep : roles) {
            if (rep.getId() == null) {
                throw new NotFoundException("Could not find composite role");
            }
            RoleModel composite = this.realm.getRoleById(rep.getId());
            if (composite == null) {
                throw new NotFoundException("Could not find composite role");
            }
            auth.roles().requireMapComposite(composite);
            role.addCompositeRole(composite);
        }
        if (role.isClientRole()) {
            adminEvent.resource(ResourceType.CLIENT_ROLE);
        } else {
            adminEvent.resource(ResourceType.REALM_ROLE);
        }
        adminEvent.operation(OperationType.CREATE).resourcePath(uriInfo).representation(roles).success();
    }

    protected Stream<RoleRepresentation> getRealmRoleComposites(RoleModel role) {
        return role.getCompositesStream().filter(composite -> composite.getContainer() instanceof RealmModel).map(ModelToRepresentation::toBriefRepresentation);
    }

    protected Stream<RoleRepresentation> getClientRoleComposites(ClientModel app, RoleModel role) {
        return role.getCompositesStream().filter(composite -> Objects.equals(composite.getContainer(), app)).map(ModelToRepresentation::toBriefRepresentation);
    }

    protected void deleteComposites(AdminEventBuilder adminEvent, UriInfo uriInfo, List<RoleRepresentation> roles, RoleModel role) {
        for (RoleRepresentation rep : roles) {
            RoleModel composite = this.realm.getRoleById(rep.getId());
            if (composite == null) {
                throw new NotFoundException("Could not find composite role");
            }
            role.removeCompositeRole(composite);
        }
        if (role.isClientRole()) {
            adminEvent.resource(ResourceType.CLIENT_ROLE);
        } else {
            adminEvent.resource(ResourceType.REALM_ROLE);
        }
        adminEvent.operation(OperationType.DELETE).resourcePath(uriInfo).representation(roles).success();
    }
}

