/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime;

import io.smallrye.common.vertx.VertxContext;
import io.smallrye.health.AsyncHealthCheckFactory;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import jakarta.inject.Singleton;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

@Singleton
public class QuarkusAsyncHealthCheckFactory
extends AsyncHealthCheckFactory {
    private final Vertx vertx;

    public QuarkusAsyncHealthCheckFactory(Vertx vertx) {
        this.vertx = vertx;
    }

    public Uni<HealthCheckResponse> callSync(HealthCheck healthCheck) {
        Uni healthCheckResponseUni = super.callSync(healthCheck);
        return healthCheckResponseUni.runSubscriptionOn(new Executor(){

            @Override
            public void execute(final Runnable command) {
                Context duplicatedContext = VertxContext.createNewDuplicatedContext((Context)QuarkusAsyncHealthCheckFactory.this.vertx.getOrCreateContext());
                duplicatedContext.executeBlocking((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        command.run();
                        return null;
                    }
                }, false);
            }
        });
    }

    public Uni<HealthCheckResponse> callAsync(AsyncHealthCheck asyncHealthCheck) {
        Uni healthCheckResponseUni = super.callAsync(asyncHealthCheck);
        return healthCheckResponseUni.runSubscriptionOn(MutinyHelper.executor((Vertx)this.vertx));
    }
}

