/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph;

import java.util.Locale;
import org.hibernate.AssertionFailure;

public enum GraphSemantic {
    FETCH,
    LOAD;


    public String getJakartaHintName() {
        switch (this) {
            case FETCH: {
                return "jakarta.persistence.fetchgraph";
            }
            case LOAD: {
                return "jakarta.persistence.loadgraph";
            }
        }
        throw new AssertionFailure("unknown GraphSemantic");
    }

    @Deprecated(since="6.0")
    public String getJpaHintName() {
        switch (this) {
            case FETCH: {
                return "javax.persistence.fetchgraph";
            }
            case LOAD: {
                return "javax.persistence.loadgraph";
            }
        }
        throw new AssertionFailure("unknown GraphSemantic");
    }

    public static GraphSemantic fromHintName(String hintName) {
        switch (hintName) {
            case "jakarta.persistence.fetchgraph": 
            case "javax.persistence.fetchgraph": {
                return FETCH;
            }
            case "jakarta.persistence.loadgraph": 
            case "javax.persistence.loadgraph": {
                return LOAD;
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown EntityGraph hint name - `%s`.  Expecting `%s` or `%s` (or `%s` and `%s`).", hintName, "jakarta.persistence.fetchgraph", "jakarta.persistence.loadgraph", "javax.persistence.fetchgraph", "javax.persistence.loadgraph"));
    }

    @Deprecated(since="6.0")
    public static GraphSemantic fromJpaHintName(String hintName) {
        return GraphSemantic.fromHintName(hintName);
    }
}

