/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniAndGroupIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.tuples.Tuple2;
import io.smallrye.mutiny.tuples.Tuples;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class UniAndGroup2<T1, T2>
extends UniAndGroupIterable<T1> {
    public UniAndGroup2(Uni<? extends T1> source, Uni<? extends T2> other) {
        super(source, Collections.singletonList(other), false);
    }

    @CheckReturnValue
    public UniAndGroup2<T1, T2> collectFailures() {
        super.collectFailures();
        return this;
    }

    @CheckReturnValue
    public Uni<Tuple2<T1, T2>> asTuple() {
        return this.combine(Tuple2::of);
    }

    @Deprecated(forRemoval=true)
    @CheckReturnValue
    public <O> Uni<O> combinedWith(BiFunction<T1, T2, O> combinator) {
        return this.with(combinator);
    }

    @CheckReturnValue
    public <O> Uni<O> with(BiFunction<T1, T2, O> combinator) {
        BiFunction<T1, T2, O> actual = Infrastructure.decorate(ParameterValidation.nonNull(combinator, "combinator"));
        return this.combine(actual);
    }

    private <O> Uni<O> combine(BiFunction<T1, T2, O> combinator) {
        Function<List, Object> function = list -> {
            Tuples.ensureArity(list, 2);
            Object item1 = list.get(0);
            Object item2 = list.get(1);
            return combinator.apply(item1, item2);
        };
        return super.with(function);
    }

    @CheckReturnValue
    public <O> Uni<O> withUni(BiFunction<T1, T2, Uni<O>> combinator) {
        BiFunction<T1, T2, Uni<O>> actual = Infrastructure.decorate(ParameterValidation.nonNull(combinator, "combinator"));
        return this.combineUni(actual);
    }

    private <O> Uni<O> combineUni(BiFunction<T1, T2, Uni<O>> combinator) {
        Function<List, Uni> function = list -> {
            Tuples.ensureArity(list, 2);
            Object item1 = list.get(0);
            Object item2 = list.get(1);
            return (Uni)combinator.apply(item1, item2);
        };
        return super.with(function).flatMap(Function.identity());
    }
}

