/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.jackson.SecureField;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.JacksonMapperUtil;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class JacksonSerializerFactory {
    private static final String SUPER_CLASS_NAME = StdSerializer.class.getName();
    private static final String JSON_GEN_CLASS_NAME = JsonGenerator.class.getName();
    private static final String SER_STRINGS_CLASS_NAME = "SerializedStrings$quarkusjacksonserializer";
    private final BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
    private final IndexView jandexIndex;
    private final Set<String> generatedClassNames = new HashSet<String>();
    private final Map<String, Set<String>> generatedFields = new HashMap<String, Set<String>>();
    private final Deque<ClassInfo> toBeGenerated = new ArrayDeque<ClassInfo>();

    public JacksonSerializerFactory(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, IndexView jandexIndex) {
        this.generatedClassBuildItemBuildProducer = generatedClassBuildItemBuildProducer;
        this.jandexIndex = jandexIndex;
    }

    public Collection<String> create(Collection<ClassInfo> classInfos) {
        HashSet<String> createdClasses = new HashSet<String>();
        this.toBeGenerated.addAll(classInfos);
        while (!this.toBeGenerated.isEmpty()) {
            this.create(this.toBeGenerated.removeFirst()).ifPresent(createdClasses::add);
        }
        this.createFieldNamesClass();
        return createdClasses;
    }

    public void createFieldNamesClass() {
        if (this.generatedFields.isEmpty()) {
            return;
        }
        MethodDescriptor serStringCtor = MethodDescriptor.ofConstructor(SerializedString.class, (Class[])new Class[]{String.class});
        for (Map.Entry<String, Set<String>> fieldsInPkg : this.generatedFields.entrySet()) {
            try (ClassCreator classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, true), fieldsInPkg.getKey() + ".SerializedStrings$quarkusjacksonserializer", null, "java.lang.Object", new String[0]);){
                MethodCreator clinit = (MethodCreator)classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8);
                for (String field : fieldsInPkg.getValue()) {
                    FieldCreator fieldCreator = (FieldCreator)classCreator.getFieldCreator(field, SerializedString.class.getName()).setModifiers(24);
                    clinit.writeStaticField(fieldCreator.getFieldDescriptor(), clinit.newInstance(serStringCtor, new ResultHandle[]{clinit.load(field)}));
                }
                clinit.returnVoid();
            }
        }
    }

    private Optional<String> create(ClassInfo classInfo) {
        String beanClassName = classInfo.name().toString();
        if (JacksonSerializerFactory.vetoedClassName(beanClassName) || !this.generatedClassNames.add(beanClassName)) {
            return Optional.empty();
        }
        String generatedClassName = beanClassName + "$quarkusjacksonserializer";
        try (ClassCreator classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, true), generatedClassName, null, SUPER_CLASS_NAME, new String[0]);){
            this.createConstructor(classCreator, beanClassName);
            boolean valid = this.createSerializeMethod(classInfo, classCreator, beanClassName);
            Optional<String> optional = valid ? Optional.of(generatedClassName) : Optional.empty();
            return optional;
        }
    }

    private void createConstructor(ClassCreator classCreator, String beanClassName) {
        MethodCreator constructor = classCreator.getConstructorCreator(new String[0]);
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)SUPER_CLASS_NAME, (String[])new String[]{"java.lang.Class"}), constructor.getThis(), new ResultHandle[]{constructor.loadClass(beanClassName)});
        constructor.returnVoid();
    }

    private boolean createSerializeMethod(ClassInfo classInfo, ClassCreator classCreator, String beanClassName) {
        MethodCreator serialize = ((MethodCreator)classCreator.getMethodCreator("serialize", "void", new String[]{"java.lang.Object", JSON_GEN_CLASS_NAME, "com.fasterxml.jackson.databind.SerializerProvider"}).setModifiers(1)).addException(IOException.class);
        boolean valid = this.serializeObject(classInfo, classCreator, beanClassName, serialize);
        serialize.returnVoid();
        return valid;
    }

    private boolean serializeObject(ClassInfo classInfo, ClassCreator classCreator, String beanClassName, MethodCreator serialize) {
        HashSet<String> serializedFields = new HashSet<String>();
        ResultHandle valueHandle = serialize.checkCast(serialize.getMethodParam(0), beanClassName);
        ResultHandle jsonGenerator = serialize.getMethodParam(1);
        ResultHandle serializerProvider = serialize.getMethodParam(2);
        MethodDescriptor writeStartObject = MethodDescriptor.ofMethod((String)JSON_GEN_CLASS_NAME, (String)"writeStartObject", (String)"void", (String[])new String[0]);
        serialize.invokeVirtualMethod(writeStartObject, jsonGenerator, new ResultHandle[0]);
        boolean valid = this.serializeObjectData(classInfo, classCreator, serialize, valueHandle, jsonGenerator, serializerProvider, serializedFields);
        MethodDescriptor writeEndObject = MethodDescriptor.ofMethod((String)JSON_GEN_CLASS_NAME, (String)"writeEndObject", (String)"void", (String[])new String[0]);
        serialize.invokeVirtualMethod(writeEndObject, jsonGenerator, new ResultHandle[0]);
        if (serializedFields.isEmpty()) {
            this.throwExceptionForEmptyBean(beanClassName, serialize, jsonGenerator);
        }
        ((MethodCreator)classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8)).returnVoid();
        return valid;
    }

    private boolean serializeObjectData(ClassInfo classInfo, ClassCreator classCreator, MethodCreator serialize, ResultHandle valueHandle, ResultHandle jsonGenerator, ResultHandle serializerProvider, Set<String> serializedFields) {
        return this.serializeFields(classInfo, classCreator, serialize, valueHandle, jsonGenerator, serializerProvider, serializedFields) && this.serializeMethods(classInfo, classCreator, serialize, valueHandle, jsonGenerator, serializerProvider, serializedFields);
    }

    private boolean serializeFields(ClassInfo classInfo, ClassCreator classCreator, MethodCreator serialize, ResultHandle valueHandle, ResultHandle jsonGenerator, ResultHandle serializerProvider, Set<String> serializedFields) {
        for (FieldInfo fieldInfo : this.classFields(classInfo)) {
            FieldSpecs fieldSpecs;
            if (Modifier.isStatic(fieldInfo.flags()) || (fieldSpecs = this.fieldSpecsFromField(classInfo, fieldInfo)) == null || !serializedFields.add(fieldSpecs.fieldName)) continue;
            if (fieldSpecs.hasUnknownAnnotation()) {
                return false;
            }
            this.writeField(classInfo, fieldSpecs, this.writeFieldBranch(classCreator, serialize, fieldSpecs), jsonGenerator, serializerProvider, valueHandle);
        }
        return true;
    }

    private boolean serializeMethods(ClassInfo classInfo, ClassCreator classCreator, MethodCreator serialize, ResultHandle valueHandle, ResultHandle jsonGenerator, ResultHandle serializerProvider, Set<String> serializedFields) {
        for (MethodInfo methodInfo : this.classMethods(classInfo)) {
            FieldSpecs fieldSpecs;
            if (Modifier.isStatic(methodInfo.flags()) || (fieldSpecs = this.fieldSpecsFromMethod(methodInfo)) == null || !serializedFields.add(fieldSpecs.fieldName)) continue;
            if (fieldSpecs.hasUnknownAnnotation()) {
                return false;
            }
            this.writeField(classInfo, fieldSpecs, (BytecodeCreator)serialize, jsonGenerator, serializerProvider, valueHandle);
        }
        return true;
    }

    private void writeField(ClassInfo classInfo, FieldSpecs fieldSpecs, BytecodeCreator bytecode, ResultHandle jsonGenerator, ResultHandle serializerProvider, ResultHandle valueHandle) {
        String pkgName = classInfo.name().packagePrefixName().toString();
        this.generatedFields.computeIfAbsent(pkgName, pkg -> new HashSet()).add(fieldSpecs.jsonName);
        ResultHandle arg = fieldSpecs.toValueReaderHandle(bytecode, valueHandle);
        String typeName = fieldSpecs.fieldType.name().toString();
        String primitiveMethodName = this.writeMethodForPrimitiveFields(typeName);
        if (primitiveMethodName != null) {
            BytecodeCreator primitiveBytecode = this.isBoxedPrimitive(typeName) ? bytecode.ifNotNull(arg).trueBranch() : bytecode;
            JacksonSerializerFactory.writeFieldName(fieldSpecs, primitiveBytecode, jsonGenerator, pkgName);
            MethodDescriptor primitiveWriter = MethodDescriptor.ofMethod((String)JSON_GEN_CLASS_NAME, (String)primitiveMethodName, (String)"void", (String[])new String[]{fieldSpecs.writtenType()});
            primitiveBytecode.invokeVirtualMethod(primitiveWriter, jsonGenerator, new ResultHandle[]{arg});
            return;
        }
        this.registerTypeToBeGenerated(fieldSpecs.fieldType, typeName);
        JacksonSerializerFactory.writeFieldName(fieldSpecs, bytecode, jsonGenerator, pkgName);
        MethodDescriptor writeMethod = MethodDescriptor.ofMethod((Object)JSON_GEN_CLASS_NAME, (String)"writePOJO", Void.TYPE, (Object[])new Object[]{Object.class});
        bytecode.invokeVirtualMethod(writeMethod, jsonGenerator, new ResultHandle[]{arg});
    }

    private static void writeFieldName(FieldSpecs fieldSpecs, BytecodeCreator bytecode, ResultHandle jsonGenerator, String pkgName) {
        MethodDescriptor writeFieldName = MethodDescriptor.ofMethod((Object)JSON_GEN_CLASS_NAME, (String)"writeFieldName", Void.TYPE, (Object[])new Object[]{SerializableString.class});
        ResultHandle serStringHandle = bytecode.readStaticField(FieldDescriptor.of((String)(pkgName + ".SerializedStrings$quarkusjacksonserializer"), (String)fieldSpecs.jsonName, (String)SerializedString.class.getName()));
        bytecode.invokeVirtualMethod(writeFieldName, jsonGenerator, new ResultHandle[]{serStringHandle});
    }

    private boolean isBoxedPrimitive(String typeName) {
        return "java.lang.Character".equals(typeName) || "java.lang.Short".equals(typeName) || "java.lang.Integer".equals(typeName) || "java.lang.Long".equals(typeName) || "java.lang.Float".equals(typeName) || "java.lang.Double".equals(typeName) || "java.lang.Boolean".equals(typeName);
    }

    private void registerTypeToBeGenerated(Type fieldType, String typeName) {
        if (!this.isCollectionType(fieldType, typeName)) {
            this.registerTypeToBeGenerated(typeName);
        }
    }

    private boolean isCollectionType(Type fieldType, String typeName) {
        if (fieldType instanceof ArrayType) {
            ArrayType aType = (ArrayType)fieldType;
            this.registerTypeToBeGenerated(aType.constituent());
            return true;
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)fieldType;
            if (pType.arguments().size() == 1 && (typeName.equals("java.util.List") || typeName.equals("java.util.Collection") || typeName.equals("java.util.Set") || typeName.equals("java.lang.Iterable"))) {
                this.registerTypeToBeGenerated((Type)pType.arguments().get(0));
                return true;
            }
            if (pType.arguments().size() == 2 && typeName.equals("java.util.Map")) {
                this.registerTypeToBeGenerated((Type)pType.arguments().get(1));
                this.registerTypeToBeGenerated((Type)pType.arguments().get(1));
                return true;
            }
        }
        return false;
    }

    private void registerTypeToBeGenerated(Type type) {
        this.registerTypeToBeGenerated(type.name().toString());
    }

    private void registerTypeToBeGenerated(String typeName) {
        ClassInfo classInfo;
        if (!JacksonSerializerFactory.vetoedClassName(typeName) && (classInfo = this.jandexIndex.getClassByName(typeName)) != null && !classInfo.isEnum()) {
            this.toBeGenerated.add(classInfo);
        }
    }

    private String writeMethodForPrimitiveFields(String typeName) {
        return switch (typeName) {
            case "java.lang.String", "char", "java.lang.Character" -> "writeString";
            case "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double" -> "writeNumber";
            case "boolean", "java.lang.Boolean" -> "writeBoolean";
            default -> null;
        };
    }

    private BytecodeCreator writeFieldBranch(ClassCreator classCreator, MethodCreator serialize, FieldSpecs fieldSpecs) {
        String[] rolesAllowed = fieldSpecs.rolesAllowed();
        if (rolesAllowed != null) {
            MethodCreator clinit = (MethodCreator)classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8);
            ResultHandle rolesArray = clinit.newArray(String.class, rolesAllowed.length);
            for (int i = 0; i < rolesAllowed.length; ++i) {
                clinit.writeArrayValue(rolesArray, clinit.load(i), clinit.load(rolesAllowed[i]));
            }
            FieldCreator fieldCreator = (FieldCreator)classCreator.getFieldCreator(fieldSpecs.fieldName + "_ROLES_ALLOWED", String[].class.getName()).setModifiers(24);
            clinit.writeStaticField(fieldCreator.getFieldDescriptor(), rolesArray);
            ResultHandle rolesArrayReader = serialize.readStaticField(FieldDescriptor.of((String)classCreator.getClassName(), (String)(fieldSpecs.fieldName + "_ROLES_ALLOWED"), (String)String[].class.getName()));
            MethodDescriptor includeSecureField = MethodDescriptor.ofMethod(JacksonMapperUtil.class, (String)"includeSecureField", Boolean.TYPE, (Class[])new Class[]{String[].class});
            ResultHandle included = serialize.invokeStaticMethod(includeSecureField, new ResultHandle[]{rolesArrayReader});
            return serialize.ifTrue(included).trueBranch();
        }
        return serialize;
    }

    private Collection<FieldInfo> classFields(ClassInfo classInfo) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        this.classFields(classInfo, fields);
        return fields;
    }

    private void classFields(ClassInfo classInfo, Collection<FieldInfo> fields) {
        fields.addAll(classInfo.fields());
        this.onSuperClass(classInfo, superClassInfo -> {
            this.classFields((ClassInfo)superClassInfo, fields);
            return null;
        });
    }

    private Collection<MethodInfo> classMethods(ClassInfo classInfo) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        this.classMethods(classInfo, methods);
        return methods;
    }

    private void classMethods(ClassInfo classInfo, Collection<MethodInfo> methods) {
        methods.addAll(classInfo.methods());
        this.onSuperClass(classInfo, superClassInfo -> {
            this.classMethods((ClassInfo)superClassInfo, methods);
            return null;
        });
    }

    private <T> T onSuperClass(ClassInfo classInfo, Function<ClassInfo, T> f) {
        ClassInfo superClassInfo;
        Type superType = classInfo.superClassType();
        if (superType != null && !JacksonSerializerFactory.vetoedClassName(superType.name().toString()) && (superClassInfo = this.jandexIndex.getClassByName(superType.name())) != null) {
            return f.apply(superClassInfo);
        }
        return null;
    }

    private boolean isGetterMethod(MethodInfo methodInfo) {
        String methodName = methodInfo.name();
        return Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags()) && methodInfo.parametersCount() == 0 && (methodName.startsWith("get") || methodName.startsWith("is"));
    }

    private void throwExceptionForEmptyBean(String beanClassName, MethodCreator serialize, ResultHandle jsonGenerator) {
        String serializationFeatureClassName = SerializationFeature.class.getName();
        ResultHandle serializerProvider = serialize.getMethodParam(2);
        MethodDescriptor isEnabled = MethodDescriptor.ofMethod((String)SerializerProvider.class.getName(), (String)"isEnabled", (String)"boolean", (String[])new String[]{serializationFeatureClassName});
        FieldDescriptor failField = FieldDescriptor.of((String)serializationFeatureClassName, (String)"FAIL_ON_EMPTY_BEANS", (String)serializationFeatureClassName);
        ResultHandle failOnEmptyBeans = serialize.readStaticField(failField);
        ResultHandle isFailEnabled = serialize.invokeVirtualMethod(isEnabled, serializerProvider, new ResultHandle[]{failOnEmptyBeans});
        BytecodeCreator isFailEnabledBranch = serialize.ifTrue(isFailEnabled).trueBranch();
        ResultHandle javaType = isFailEnabledBranch.invokeStaticMethod(MethodDescriptor.ofMethod(SimpleType.class, (String)"constructUnsafe", SimpleType.class, (Class[])new Class[]{Class.class}), new ResultHandle[]{isFailEnabledBranch.loadClass(beanClassName)});
        MethodDescriptor exceptionConstructor = MethodDescriptor.ofMethod(InvalidDefinitionException.class, (String)"from", InvalidDefinitionException.class, (Class[])new Class[]{JsonGenerator.class, String.class, JavaType.class});
        String errorMsg = String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", beanClassName);
        ResultHandle invalidException = isFailEnabledBranch.invokeStaticMethod(exceptionConstructor, new ResultHandle[]{jsonGenerator, isFailEnabledBranch.load(errorMsg), javaType});
        isFailEnabledBranch.throwException(invalidException);
    }

    private MethodInfo getterMethodInfo(ClassInfo classInfo, FieldInfo fieldInfo) {
        MethodInfo namedAccessor = this.findMethod(classInfo, fieldInfo.name(), new Type[0]);
        if (namedAccessor != null) {
            return namedAccessor;
        }
        String methodName = (fieldInfo.type().name().toString().equals("boolean") ? "is" : "get") + JacksonSerializerFactory.ucFirst(fieldInfo.name());
        return this.findMethod(classInfo, methodName, new Type[0]);
    }

    private MethodInfo findMethod(ClassInfo classInfo, String methodName, Type ... parameters) {
        MethodInfo method = classInfo.method(methodName, parameters);
        return method != null ? method : this.onSuperClass(classInfo, superClassInfo -> this.findMethod((ClassInfo)superClassInfo, methodName, parameters));
    }

    private static String ucFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static boolean vetoedClassName(String className) {
        return className.startsWith("java.") || className.startsWith("jakarta.") || className.startsWith("io.vertx.core.json.");
    }

    private FieldSpecs fieldSpecsFromField(ClassInfo classInfo, FieldInfo fieldInfo) {
        MethodInfo getterMethodInfo = this.getterMethodInfo(classInfo, fieldInfo);
        if (getterMethodInfo != null) {
            return new FieldSpecs(fieldInfo, getterMethodInfo);
        }
        if (Modifier.isPublic(fieldInfo.flags())) {
            return new FieldSpecs(fieldInfo);
        }
        return null;
    }

    private FieldSpecs fieldSpecsFromMethod(MethodInfo methodInfo) {
        return this.isGetterMethod(methodInfo) ? new FieldSpecs(methodInfo) : null;
    }

    private static class FieldSpecs {
        private final String fieldName;
        private final String jsonName;
        private final Type fieldType;
        private final Map<String, AnnotationInstance> annotations = new HashMap<String, AnnotationInstance>();
        private MethodInfo methodInfo;
        private FieldInfo fieldInfo;

        FieldSpecs(FieldInfo fieldInfo) {
            this(fieldInfo, null);
        }

        FieldSpecs(MethodInfo methodInfo) {
            this(null, methodInfo);
        }

        FieldSpecs(FieldInfo fieldInfo, MethodInfo methodInfo) {
            if (fieldInfo != null) {
                this.fieldInfo = fieldInfo;
                fieldInfo.annotations().forEach(a -> this.annotations.put(a.name().toString(), (AnnotationInstance)a));
            }
            if (methodInfo != null) {
                this.methodInfo = methodInfo;
                methodInfo.annotations().forEach(a -> this.annotations.put(a.name().toString(), (AnnotationInstance)a));
            }
            this.fieldType = this.fieldType();
            this.fieldName = this.fieldName();
            this.jsonName = this.jsonName();
        }

        private Type fieldType() {
            return this.fieldInfo != null ? this.fieldInfo.type() : this.methodInfo.returnType();
        }

        private String jsonName() {
            AnnotationValue value;
            AnnotationInstance jsonProperty = this.annotations.get(JsonProperty.class.getName());
            if (jsonProperty != null && (value = jsonProperty.value()) != null && !value.asString().isEmpty()) {
                return value.asString();
            }
            return this.fieldName();
        }

        private String fieldName() {
            return this.fieldInfo != null ? this.fieldInfo.name() : this.fieldNameFromMethod(this.methodInfo);
        }

        private String fieldNameFromMethod(MethodInfo methodInfo) {
            String methodName = methodInfo.name();
            if (methodName.startsWith("is")) {
                return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
            }
            if (methodName.startsWith("get")) {
                return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            }
            return methodName;
        }

        boolean hasUnknownAnnotation() {
            return this.annotations.keySet().stream().anyMatch(ann -> ann.startsWith("com.fasterxml.jackson.") && !ann.equals(JsonProperty.class.getName()));
        }

        ResultHandle toValueReaderHandle(BytecodeCreator bytecode, ResultHandle valueHandle) {
            ResultHandle handle = this.accessorHandle(bytecode, valueHandle);
            handle = switch (this.fieldType.name().toString()) {
                case "char", "java.lang.Character" -> bytecode.invokeStaticMethod(MethodDescriptor.ofMethod(Character.class, (String)"toString", String.class, (Class[])new Class[]{Character.TYPE}), new ResultHandle[]{handle});
                default -> handle;
            };
            return handle;
        }

        private ResultHandle accessorHandle(BytecodeCreator bytecode, ResultHandle valueHandle) {
            if (this.methodInfo != null) {
                if (this.methodInfo.declaringClass().isInterface()) {
                    return bytecode.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)this.methodInfo), valueHandle, new ResultHandle[0]);
                }
                return bytecode.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)this.methodInfo), valueHandle, new ResultHandle[0]);
            }
            return bytecode.readInstanceField(FieldDescriptor.of((FieldInfo)this.fieldInfo), valueHandle);
        }

        String writtenType() {
            return switch (this.fieldType.name().toString()) {
                case "char", "java.lang.Character" -> "java.lang.String";
                case "java.lang.Integer" -> "int";
                case "java.lang.Short" -> "short";
                case "java.lang.Long" -> "long";
                case "java.lang.Double" -> "double";
                case "java.lang.Float" -> "float";
                case "java.lang.Boolean" -> "boolean";
                default -> this.fieldType.name().toString();
            };
        }

        private String[] rolesAllowed() {
            AnnotationInstance secureField = this.annotations.get(SecureField.class.getName());
            if (secureField != null) {
                AnnotationValue rolesAllowed = secureField.value("rolesAllowed");
                return rolesAllowed != null ? rolesAllowed.asStringArray() : null;
            }
            return null;
        }
    }
}

