/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.execactions.ExecuteActionsActionToken;
import org.keycloak.authentication.actiontoken.verifyemail.VerifyEmailActionToken;
import org.keycloak.authentication.requiredactions.util.RequiredActionsValidator;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.models.utils.SystemClientUtil;
import org.keycloak.policy.PasswordPolicyNotMetException;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.UserConsentManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RoleMapperResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.validation.Validation;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;
import org.keycloak.utils.ProfileHelper;
import org.keycloak.utils.StringUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class UserResource {
    private static final Logger logger = Logger.getLogger(UserResource.class);
    protected final RealmModel realm;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private final UserModel user;
    protected final ClientConnection clientConnection;
    protected final KeycloakSession session;
    protected final HttpHeaders headers;

    public UserResource(KeycloakSession session, UserModel user, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.clientConnection = session.getContext().getConnection();
        this.user = user;
        this.adminEvent = adminEvent.resource(ResourceType.USER);
        this.headers = session.getContext().getRequestHeaders();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Update the user")
    public Response updateUser(UserRepresentation rep) {
        this.auth.users().requireManage(this.user);
        try {
            UserProfile profile;
            Response response;
            boolean wasPermanentlyLockedOut = false;
            if (rep.isEnabled() != null && rep.isEnabled().booleanValue()) {
                UserLoginFailureModel failureModel;
                if ((!this.user.isEnabled() || ((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, this.realm, this.user)) && (failureModel = this.session.loginFailures().getUserLoginFailure(this.realm, this.user.getId())) != null) {
                    this.session.loginFailures().removeUserLoginFailure(this.realm, this.user.getId());
                    this.adminEvent.clone(this.session).resource(ResourceType.USER_LOGIN_FAILURE).resourcePath((UriInfo)this.session.getContext().getUri()).operation(OperationType.DELETE).success();
                }
                wasPermanentlyLockedOut = ((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isPermanentlyLockedOut(this.session, this.realm, this.user);
            }
            HashMap<String, List> attributes = new HashMap<String, List>(rep.getRawAttributes());
            if (rep.getAttributes() == null) {
                for (Map.Entry entry : this.user.getAttributes().entrySet()) {
                    attributes.putIfAbsent((String)entry.getKey(), (List)entry.getValue());
                }
            }
            if ((response = UserResource.validateUserProfile(profile = ((UserProfileProvider)this.session.getProvider(UserProfileProvider.class)).create(UserProfileContext.USER_API, attributes, this.user), this.session, this.auth.adminAuth())) != null) {
                return response;
            }
            profile.update(rep.getAttributes() != null, new AttributeChangeListener[0]);
            UserResource.updateUserFromRep(profile, this.user, rep, this.session, true);
            RepresentationToModel.createCredentials((UserRepresentation)rep, (KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)this.user, (boolean)true);
            if (wasPermanentlyLockedOut) {
                ((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).cleanUpPermanentLockout(this.session, this.realm, this.user);
            }
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            this.session.getTransactionManager().setRollbackOnly();
            throw ErrorResponse.exists("User exists with same username or email");
        }
        catch (ReadOnlyException re) {
            this.session.getTransactionManager().setRollbackOnly();
            throw ErrorResponse.error(re.getMessage() == null ? "User is read only!" : re.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (PasswordPolicyNotMetException e) {
            logger.warn((Object)("Password policy not met for user " + e.getUsername()), (Throwable)e);
            this.session.getTransactionManager().setRollbackOnly();
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(e.getMessage(), MessageFormat.format(messages.getProperty(e.getMessage(), e.getMessage()), e.getParameters()), Response.Status.BAD_REQUEST);
        }
        catch (ModelIllegalStateException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ModelException me) {
            logger.warn((Object)"Could not update user!", (Throwable)me);
            this.session.getTransactionManager().setRollbackOnly();
            throw ErrorResponse.error("Could not update user!", Response.Status.BAD_REQUEST);
        }
        catch (ForbiddenException | ErrorResponseException e) {
            this.session.getTransactionManager().setRollbackOnly();
            throw e;
        }
        catch (Exception me) {
            this.session.getTransactionManager().setRollbackOnly();
            logger.warn((Object)"Could not update user!", (Throwable)me);
            throw ErrorResponse.error("Could not update user!", Response.Status.BAD_REQUEST);
        }
    }

    public static Response validateUserProfile(UserProfile profile, KeycloakSession session, AdminAuth adminAuth) {
        try {
            profile.validate();
        }
        catch (ValidationException pve) {
            ArrayList<ErrorRepresentation> errors = new ArrayList<ErrorRepresentation>();
            for (ValidationException.Error error : pve.getErrors()) {
                switch (error.getMessage()) {
                    case "missingUsernameMessage": {
                        throw ErrorResponse.error("User name is missing", Response.Status.BAD_REQUEST);
                    }
                    case "usernameExistsMessage": {
                        throw ErrorResponse.exists("User exists with same username");
                    }
                    case "emailExistsMessage": {
                        throw ErrorResponse.exists("User exists with same email");
                    }
                }
                errors.add(new ErrorRepresentation(error.getAttribute(), error.getMessage(), error.getMessageParameters()));
            }
            throw ErrorResponse.errors(errors, Response.Status.BAD_REQUEST);
        }
        return null;
    }

    public static void updateUserFromRep(UserProfile profile, UserModel user, UserRepresentation rep, KeycloakSession session, boolean isUpdateExistingUser) {
        List credentials;
        List reqActions;
        boolean removeMissingRequiredActions = isUpdateExistingUser;
        if (rep.isEnabled() != null) {
            user.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isEmailVerified() != null) {
            user.setEmailVerified(rep.isEmailVerified().booleanValue());
        }
        if (rep.getCreatedTimestamp() != null && !isUpdateExistingUser) {
            user.setCreatedTimestamp(rep.getCreatedTimestamp());
        }
        if (rep.getFederationLink() != null) {
            user.setFederationLink(rep.getFederationLink());
        }
        if ((reqActions = rep.getRequiredActions()) != null) {
            session.getKeycloakSessionFactory().getProviderFactoriesStream(RequiredActionProvider.class).map(ProviderFactory::getId).distinct().sorted().forEach(action -> {
                if (reqActions.contains(action)) {
                    user.addRequiredAction(action);
                } else if (removeMissingRequiredActions) {
                    user.removeRequiredAction(action);
                }
            });
        }
        if ((credentials = rep.getCredentials()) != null) {
            for (CredentialRepresentation credential : credentials) {
                if (!"password".equals(credential.getType()) || credential.isTemporary() == null || !credential.isTemporary().booleanValue()) continue;
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
            }
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Get representation of the user")
    public UserRepresentation getUser(@Parameter(description="Indicates if the user profile metadata should be added to the response") @QueryParam(value="userProfileMetadata") boolean userProfileMetadata) {
        this.auth.users().requireView(this.user);
        UserProfileProvider provider = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.USER_API, this.user);
        UserRepresentation rep = (UserRepresentation)profile.toRepresentation();
        if (this.realm.isIdentityFederationEnabled()) {
            List reps = this.getFederatedIdentities(this.user).collect(Collectors.toList());
            rep.setFederatedIdentities(reps);
        }
        if (((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, this.realm, this.user)) {
            rep.setEnabled(Boolean.valueOf(false));
        }
        rep.setAccess(this.auth.users().getAccess(this.user));
        if (!userProfileMetadata) {
            rep.setUserProfileMetadata(null);
        }
        return rep;
    }

    @Path(value="impersonation")
    @POST
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Impersonate the user")
    public Map<String, Object> impersonate() {
        ProfileHelper.requireFeature(Profile.Feature.IMPERSONATION);
        this.auth.users().requireImpersonate(this.user);
        if (!this.user.isEnabled()) {
            throw ErrorResponse.error("User is disabled", Response.Status.BAD_REQUEST);
        }
        if (this.user.getServiceAccountClientLink() != null) {
            throw ErrorResponse.error("Service accounts cannot be impersonated", Response.Status.BAD_REQUEST);
        }
        RealmModel authenticatedRealm = this.auth.adminAuth().getRealm();
        boolean sameRealm = false;
        String sessionState = this.auth.adminAuth().getToken().getSessionState();
        if (authenticatedRealm.getId().equals(this.realm.getId()) && sessionState != null) {
            sameRealm = true;
            UserSessionModel userSession = this.session.sessions().getUserSession(authenticatedRealm, sessionState);
            AuthenticationManager.expireIdentityCookie(this.session);
            AuthenticationManager.expireRememberMeCookie(this.session);
            AuthenticationManager.expireAuthSessionCookie(this.session);
            AuthenticationManager.backchannelLogout(this.session, authenticatedRealm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, true);
        }
        EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
        UserSessionModel userSession = new UserSessionManager(this.session).createUserSession(this.realm, this.user, this.user.getUsername(), this.clientConnection.getRemoteAddr(), "impersonate", false, null, null);
        UserModel adminUser = this.auth.adminAuth().getUser();
        String impersonatorId = adminUser.getId();
        String impersonator = adminUser.getUsername();
        userSession.setNote(ImpersonationSessionNote.IMPERSONATOR_ID.toString(), impersonatorId);
        userSession.setNote(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString(), impersonator);
        AuthenticationManager.createLoginCookie(this.session, this.realm, userSession.getUser(), userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection);
        URI redirect = Urls.accountBase(this.session.getContext().getUri().getBaseUri()).build(new Object[]{this.realm.getName()});
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sameRealm", sameRealm);
        result.put("redirect", redirect.toString());
        event.event(EventType.IMPERSONATE).session(userSession).user(this.user).detail("impersonator_realm", authenticatedRealm.getName()).detail("impersonator", impersonator).success();
        return result;
    }

    @Path(value="sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Get sessions associated with the user")
    public Stream<UserSessionRepresentation> getSessions() {
        this.auth.users().requireView(this.user);
        return this.session.sessions().getUserSessionsStream(this.realm, this.user).map(ModelToRepresentation::toRepresentation);
    }

    @Path(value="offline-sessions/{clientUuid}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Get offline sessions associated with the user and client")
    public Stream<UserSessionRepresentation> getOfflineSessions(@PathParam(value="clientUuid") String clientUuid) {
        this.auth.users().requireView(this.user);
        ClientModel client = this.realm.getClientById(clientUuid);
        if (client == null) {
            throw new NotFoundException("Client not found");
        }
        return new UserSessionManager(this.session).findOfflineSessionsStream(this.realm, this.user).map(session -> this.toUserSessionRepresentation((UserSessionModel)session, clientUuid)).filter(Objects::nonNull);
    }

    @Path(value="federated-identity")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Get social logins associated with the user")
    public Stream<FederatedIdentityRepresentation> getFederatedIdentity() {
        this.auth.users().requireView(this.user);
        return this.getFederatedIdentities(this.user);
    }

    private Stream<FederatedIdentityRepresentation> getFederatedIdentities(UserModel user) {
        return this.session.users().getFederatedIdentitiesStream(this.realm, user).filter(identity -> this.session.identityProviders().getByAlias(identity.getIdentityProvider()) != null).map(ModelToRepresentation::toRepresentation);
    }

    @Path(value="federated-identity/{provider}")
    @POST
    @NoCache
    @Tag(name="Users")
    @Operation(summary="Add a social login provider to the user")
    public Response addFederatedIdentity(@Parameter(description="Social login provider id") @PathParam(value="provider") String provider, FederatedIdentityRepresentation rep) {
        this.auth.users().requireManage(this.user);
        if (this.session.users().getFederatedIdentity(this.realm, this.user, provider) != null) {
            throw ErrorResponse.exists("User is already linked with provider");
        }
        FederatedIdentityModel socialLink = new FederatedIdentityModel(provider, rep.getUserId(), rep.getUserName());
        this.session.users().addFederatedIdentity(this.realm, this.user, socialLink);
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        return Response.noContent().build();
    }

    @Path(value="federated-identity/{provider}")
    @DELETE
    @NoCache
    @Tag(name="Users")
    @Operation(summary="Remove a social login provider from user")
    public void removeFederatedIdentity(@Parameter(description="Social login provider id") @PathParam(value="provider") String provider) {
        this.auth.users().requireManage(this.user);
        if (!this.session.users().removeFederatedIdentity(this.realm, this.user, provider)) {
            throw new NotFoundException("Link not found");
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="consents")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Get consents granted by the user")
    public Stream<Map<String, Object>> getConsents() {
        this.auth.users().requireView(this.user);
        Set<ClientModel> offlineClients = new UserSessionManager(this.session).findClientsWithOfflineToken(this.realm, this.user);
        HashSet clientsWithUserConsents = new HashSet();
        List userConsents = UserConsentManager.getConsentsStream(this.session, this.realm, this.user).peek(ucm -> clientsWithUserConsents.add(ucm.getClient())).collect(Collectors.toList());
        return Stream.concat(userConsents.stream().map(consent -> this.toConsent((UserConsentModel)consent, offlineClients)), offlineClients.stream().filter(c -> !clientsWithUserConsents.contains(c)).map(this::toConsent));
    }

    private Map<String, Object> toConsent(ClientModel client) {
        HashMap<String, Object> currentRep = new HashMap<String, Object>();
        currentRep.put("clientId", client.getClientId());
        currentRep.put("grantedClientScopes", Collections.emptyList());
        currentRep.put("createdDate", null);
        currentRep.put("lastUpdatedDate", null);
        LinkedList additionalGrants = new LinkedList();
        HashMap<String, String> offlineTokens = new HashMap<String, String>();
        offlineTokens.put("client", client.getId());
        offlineTokens.put("key", "Offline Token");
        additionalGrants.add(offlineTokens);
        currentRep.put("additionalGrants", additionalGrants);
        return currentRep;
    }

    private Map<String, Object> toConsent(UserConsentModel consent, Set<ClientModel> offlineClients) {
        UserConsentRepresentation rep = ModelToRepresentation.toRepresentation((UserConsentModel)consent);
        HashMap<String, Object> currentRep = new HashMap<String, Object>();
        currentRep.put("clientId", consent.getClient().getClientId());
        currentRep.put("grantedClientScopes", rep.getGrantedClientScopes());
        currentRep.put("createdDate", rep.getCreatedDate());
        currentRep.put("lastUpdatedDate", rep.getLastUpdatedDate());
        LinkedList additionalGrants = new LinkedList();
        if (offlineClients.contains(consent.getClient())) {
            HashMap<String, String> offlineTokens = new HashMap<String, String>();
            offlineTokens.put("client", consent.getClient().getId());
            offlineTokens.put("key", "Offline Token");
            additionalGrants.add(offlineTokens);
        }
        currentRep.put("additionalGrants", additionalGrants);
        return currentRep;
    }

    @Path(value="consents/{client}")
    @DELETE
    @NoCache
    @Tag(name="Users")
    @Operation(summary="Revoke consent and offline tokens for particular client from user")
    public void revokeConsent(@Parameter(description="Client id") @PathParam(value="client") String clientId) {
        this.auth.users().requireManage(this.user);
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            throw new NotFoundException("Client not found");
        }
        boolean revokedConsent = UserConsentManager.revokeConsentToClient(this.session, client, this.user);
        if (!revokedConsent) {
            throw new NotFoundException("Consent nor offline token not found");
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="logout")
    @POST
    @Tag(name="Users")
    @Operation(summary="Remove all user sessions associated with the user Also send notification to all clients that have an admin URL to invalidate the sessions for the particular user.")
    @APIResponse(responseCode="204", description="No Content")
    public void logout() {
        this.auth.users().requireManage(this.user);
        if (!LightweightUserAdapter.isLightweightUser((UserModel)this.user)) {
            this.session.users().setNotBeforeForUser(this.realm, this.user, Time.currentTime());
        }
        this.session.sessions().getUserSessionsStream(this.realm, this.user).collect(Collectors.toList()).forEach(userSession -> AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, true));
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @DELETE
    @NoCache
    @Tag(name="Users")
    @Operation(summary="Delete the user")
    public Response deleteUser() {
        this.auth.users().requireManage(this.user);
        boolean removed = new UserManager(this.session).removeUser(this.realm, this.user);
        if (removed) {
            this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
            return Response.noContent().build();
        }
        throw ErrorResponse.error("User couldn't be deleted", Response.Status.BAD_REQUEST);
    }

    @Path(value="role-mappings")
    public RoleMapperResource getRoleMappings() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.users().requireMapRoles(this.user);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.users().requireView(this.user);
        return new RoleMapperResource(this.session, this.auth, (RoleMapperModel)this.user, this.adminEvent, manageCheck, viewCheck);
    }

    @Path(value="disable-credential-types")
    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Disable all credentials for a user of a specific type")
    public void disableCredentialType(List<String> credentialTypes) {
        this.auth.users().requireManage(this.user);
        if (credentialTypes == null) {
            return;
        }
        for (String type : credentialTypes) {
            this.user.credentialManager().disableCredentialType(type);
        }
    }

    @Path(value="reset-password")
    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Set up a new password for the user.")
    public void resetPassword(@Parameter(description="The representation must contain a rawPassword with the plain-text password") CredentialRepresentation cred) {
        this.auth.users().requireManage(this.user);
        if (cred == null || cred.getValue() == null) {
            throw new BadRequestException("No password provided");
        }
        if (Validation.isBlank(cred.getValue())) {
            throw new BadRequestException("Empty password not allowed");
        }
        try {
            this.user.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)cred.getValue(), (boolean)false));
        }
        catch (IllegalStateException ise) {
            throw new BadRequestException("Resetting to N old passwords is not allowed.");
        }
        catch (ReadOnlyException mre) {
            throw new BadRequestException("Can't reset password as account is read only");
        }
        catch (PasswordPolicyNotMetException e) {
            logger.warn((Object)("Password policy not met for user " + e.getUsername()), (Throwable)e);
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(e.getMessage(), MessageFormat.format(messages.getProperty(e.getMessage(), e.getMessage()), e.getParameters()), Response.Status.BAD_REQUEST);
        }
        catch (ModelIllegalStateException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ModelException e) {
            logger.warn((Object)"Could not update user password.", (Throwable)e);
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(e.getMessage(), MessageFormat.format(messages.getProperty(e.getMessage(), e.getMessage()), e.getParameters()), Response.Status.BAD_REQUEST);
        }
        if (cred.isTemporary() != null && cred.isTemporary().booleanValue()) {
            this.user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        } else {
            this.user.removeRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @GET
    @Path(value="credentials")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation
    public Stream<CredentialRepresentation> credentials() {
        this.auth.users().requireView(this.user);
        return this.user.credentialManager().getStoredCredentialsStream().map(ModelToRepresentation::toRepresentation).peek(credentialRepresentation -> credentialRepresentation.setSecretData(null));
    }

    @GET
    @Path(value="configured-user-storage-credential-types")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Return credential types, which are provided by the user storage where user is stored.", description="Returned values can contain for example \"password\", \"otp\" etc. This will always return empty list for \"local\" users, which are not backed by any user storage")
    public Stream<String> getConfiguredUserStorageCredentialTypes() {
        this.auth.users().requireView(this.user);
        return this.user.credentialManager().getConfiguredUserStorageCredentialTypesStream();
    }

    @Path(value="credentials/{credentialId}")
    @DELETE
    @NoCache
    @Tag(name="Users")
    @Operation(summary="Remove a credential for a user")
    public void removeCredential(@PathParam(value="credentialId") String credentialId) {
        this.auth.users().requireManage(this.user);
        CredentialModel credential = this.user.credentialManager().getStoredCredentialById(credentialId);
        if (credential == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("Credential not found");
            }
            throw new ForbiddenException();
        }
        this.user.credentialManager().removeStoredCredentialById(credentialId);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Path(value="credentials/{credentialId}/userLabel")
    @Tag(name="Users")
    @Operation(summary="Update a credential label for a user")
    public void setCredentialUserLabel(@PathParam(value="credentialId") String credentialId, String userLabel) {
        this.auth.users().requireManage(this.user);
        CredentialModel credential = this.user.credentialManager().getStoredCredentialById(credentialId);
        if (credential == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("Credential not found");
            }
            throw new ForbiddenException();
        }
        this.user.credentialManager().updateCredentialLabel(credentialId, userLabel);
    }

    @Path(value="credentials/{credentialId}/moveToFirst")
    @POST
    @Tag(name="Users")
    @Operation(summary="Move a credential to a first position in the credentials list of the user")
    @APIResponse(responseCode="204", description="No Content")
    public void moveCredentialToFirst(@Parameter(description="The credential to move") @PathParam(value="credentialId") String credentialId) {
        this.moveCredentialAfter(credentialId, null);
    }

    @Path(value="credentials/{credentialId}/moveAfter/{newPreviousCredentialId}")
    @POST
    @Tag(name="Users")
    @Operation(summary="Move a credential to a position behind another credential")
    @APIResponse(responseCode="204", description="No Content")
    public void moveCredentialAfter(@Parameter(description="The credential to move") @PathParam(value="credentialId") String credentialId, @Parameter(description="The credential that will be the previous element in the list. If set to null, the moved credential will be the first element in the list.") @PathParam(value="newPreviousCredentialId") String newPreviousCredentialId) {
        this.auth.users().requireManage(this.user);
        CredentialModel credential = this.user.credentialManager().getStoredCredentialById(credentialId);
        if (credential == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("Credential not found");
            }
            throw new ForbiddenException();
        }
        this.user.credentialManager().moveStoredCredentialTo(credentialId, newPreviousCredentialId);
    }

    @Deprecated
    @Path(value="reset-password-email")
    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Send an email to the user with a link they can click to reset their password.", description="The redirectUri and clientId parameters are optional. The default for the redirect is the account client. This endpoint has been deprecated.  Please use the execute-actions-email passing a list with UPDATE_PASSWORD within it.", deprecated=true)
    public Response resetPasswordEmail(@Parameter(description="redirect uri") @QueryParam(value="redirect_uri") String redirectUri, @Parameter(description="client id") @QueryParam(value="client_id") String clientId) {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        return this.executeActionsEmail(redirectUri, clientId, null, actions);
    }

    @Path(value="execute-actions-email")
    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Send an email to the user with a link they can click to execute particular actions.", description="An email contains a link the user can click to perform a set of required actions. The redirectUri and clientId parameters are optional. If no redirect is given, then there will be no link back to click after actions have completed. Redirect uri must be a valid uri for the particular clientId.")
    public Response executeActionsEmail(@Parameter(description="Redirect uri") @QueryParam(value="redirect_uri") String redirectUri, @Parameter(description="Client id") @QueryParam(value="client_id") String clientId, @Parameter(description="Number of seconds after which the generated token expires") @QueryParam(value="lifespan") Integer lifespan, @Parameter(description="Required actions the user needs to complete") List<String> actions) {
        this.auth.users().requireManage(this.user);
        SendEmailParams result = this.verifySendEmailParams(redirectUri, clientId, lifespan);
        if (CollectionUtil.isNotEmpty(actions) && !RequiredActionsValidator.validRequiredActions(this.session, actions)) {
            throw ErrorResponse.error("Provided invalid required actions", Response.Status.BAD_REQUEST);
        }
        int expiration = Time.currentTime() + result.lifespan;
        ExecuteActionsActionToken token = new ExecuteActionsActionToken(this.user.getId(), this.user.getEmail(), expiration, actions, result.redirectUri, result.clientId);
        try {
            UriBuilder builder = LoginActionsService.actionTokenProcessor((UriInfo)this.session.getContext().getUri());
            builder.queryParam("key", new Object[]{token.serialize(this.session, this.realm, (UriInfo)this.session.getContext().getUri())});
            String link = builder.build(new Object[]{this.realm.getName()}).toString();
            ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setAttribute("requiredActions", token.getRequiredActions()).setRealm(this.realm).setUser(this.user).sendExecuteActions(link, TimeUnit.SECONDS.toMinutes(result.lifespan));
            this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
            return Response.noContent().build();
        }
        catch (EmailException e) {
            ServicesLogger.LOGGER.failedToSendActionsEmail(e);
            throw ErrorResponse.error("Failed to send execute actions email: " + e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="send-verify-email")
    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Send an email-verification email to the user An email contains a link the user can click to verify their email address.", description="The redirectUri, clientId and lifespan parameters are optional. The default for the redirect is the account client. The default for the lifespan is 12 hours")
    public Response sendVerifyEmail(@Parameter(description="Redirect uri") @QueryParam(value="redirect_uri") String redirectUri, @Parameter(description="Client id") @QueryParam(value="client_id") String clientId, @Parameter(description="Number of seconds after which the generated token expires") @QueryParam(value="lifespan") Integer lifespan) {
        this.auth.users().requireManage(this.user);
        SendEmailParams result = this.verifySendEmailParams(redirectUri, clientId, lifespan);
        int expiration = Time.currentTime() + result.lifespan;
        VerifyEmailActionToken token = new VerifyEmailActionToken(this.user.getId(), expiration, null, this.user.getEmail(), result.clientId);
        token.setRedirectUri(result.redirectUri);
        String link = LoginActionsService.actionTokenProcessor((UriInfo)this.session.getContext().getUri()).queryParam("key", new Object[]{token.serialize(this.session, this.realm, (UriInfo)this.session.getContext().getUri())}).build(new Object[]{this.realm.getName()}).toString();
        try {
            ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setRealm(this.realm).setUser(this.user).sendVerifyEmail(link, TimeUnit.SECONDS.toMinutes(result.lifespan));
        }
        catch (EmailException e) {
            ServicesLogger.LOGGER.failedToSendEmail((Exception)((Object)e));
            throw ErrorResponse.error("Failed to send verify email", Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        return Response.noContent().build();
    }

    @GET
    @Path(value="groups")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation
    public Stream<GroupRepresentation> groupMembership(@QueryParam(value="search") String search, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.auth.users().requireView(this.user);
        return this.user.getGroupsStream(search, firstResult, maxResults).map(g -> ModelToRepresentation.toRepresentation((GroupModel)g, (!briefRepresentation ? 1 : 0) != 0));
    }

    @GET
    @NoCache
    @Path(value="groups/count")
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation
    public Map<String, Long> getGroupMembershipCount(@QueryParam(value="search") String search) {
        this.auth.users().requireView(this.user);
        Long results = Objects.nonNull(search) ? Long.valueOf(this.user.getGroupsCountByNameContaining(search)) : Long.valueOf(this.user.getGroupsCount());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("count", results);
        return map;
    }

    @DELETE
    @Path(value="groups/{groupId}")
    @NoCache
    @Tag(name="Users")
    @Operation
    public void removeMembership(@PathParam(value="groupId") String groupId) {
        this.auth.users().requireManageGroupMembership(this.user);
        GroupModel group = this.session.groups().getGroupById(this.realm, groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.auth.groups().requireManageMembership(group);
        try {
            if (this.user.isMemberOf(group)) {
                this.user.leaveGroup(group);
                this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.GROUP_MEMBERSHIP).representation(ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)true)).resourcePath((UriInfo)this.session.getContext().getUri()).detail("username", this.user.getUsername()).detail("email", this.user.getEmail()).success();
            }
        }
        catch (ModelIllegalStateException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ModelException me) {
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(me.getMessage(), MessageFormat.format(messages.getProperty(me.getMessage(), me.getMessage()), me.getParameters()), Response.Status.BAD_REQUEST);
        }
    }

    @PUT
    @Path(value="groups/{groupId}")
    @NoCache
    @Tag(name="Users")
    @Operation
    public void joinGroup(@PathParam(value="groupId") String groupId) {
        this.auth.users().requireManageGroupMembership(this.user);
        GroupModel group = this.session.groups().getGroupById(this.realm, groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.auth.groups().requireManageMembership(group);
        if (!RoleUtils.isDirectMember((Stream)this.user.getGroupsStream(), (GroupModel)group)) {
            this.user.joinGroup(group);
            this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.GROUP_MEMBERSHIP).representation(ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)true)).resourcePath((UriInfo)this.session.getContext().getUri()).detail("username", this.user.getUsername()).detail("email", this.user.getEmail()).success();
        }
    }

    @GET
    @Path(value="unmanagedAttributes")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation
    public Map<String, List<String>> getUnmanagedAttributes() {
        this.auth.users().requireView(this.user);
        UserProfileProvider provider = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.USER_API, this.user);
        Map managedAttributes = profile.getAttributes().getReadable();
        Map unmanagedAttributes = profile.getAttributes().getUnmanagedAttributes();
        managedAttributes.entrySet().removeAll(unmanagedAttributes.entrySet());
        HashMap attributes = new HashMap(this.user.getAttributes());
        attributes.entrySet().removeAll(managedAttributes.entrySet());
        attributes.remove("username");
        attributes.remove("email");
        return attributes.entrySet().stream().filter(entry -> Optional.ofNullable((List)entry.getValue()).orElse(Collections.emptyList()).stream().anyMatch(StringUtil::isNotBlank)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private UserSessionRepresentation toUserSessionRepresentation(UserSessionModel userSession, String clientUuid) {
        UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)userSession);
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(clientUuid);
        if (clientSession == null) {
            return null;
        }
        rep.setLastAccess(Time.toMillis((long)clientSession.getTimestamp()));
        return rep;
    }

    private SendEmailParams verifySendEmailParams(String redirectUri, String clientId, Integer lifespan) {
        ClientModel client;
        if (this.user.getEmail() == null) {
            throw ErrorResponse.error("User email missing", Response.Status.BAD_REQUEST);
        }
        if (!this.user.isEnabled()) {
            throw ErrorResponse.error("User is disabled", Response.Status.BAD_REQUEST);
        }
        if (redirectUri != null && clientId == null) {
            throw ErrorResponse.error("Client id missing", Response.Status.BAD_REQUEST);
        }
        ClientModel clientModel = client = clientId != null ? this.realm.getClientByClientId(clientId) : SystemClientUtil.getSystemClient((RealmModel)this.realm);
        if (client == null) {
            logger.debugf("Client %s doesn't exist", (Object)clientId);
            throw ErrorResponse.error("Client doesn't exist", Response.Status.BAD_REQUEST);
        }
        if (!client.isEnabled()) {
            logger.debugf("Client %s is not enabled", (Object)clientId);
            throw ErrorResponse.error("Client is not enabled", Response.Status.BAD_REQUEST);
        }
        if (redirectUri != null && (redirectUri = RedirectUtils.verifyRedirectUri(this.session, redirectUri, client)) == null) {
            throw ErrorResponse.error("Invalid redirect uri.", Response.Status.BAD_REQUEST);
        }
        if (lifespan == null) {
            lifespan = this.realm.getActionTokenGeneratedByAdminLifespan();
        }
        return new SendEmailParams(redirectUri, clientId, lifespan);
    }

    private static class SendEmailParams {
        final String redirectUri;
        final String clientId;
        final int lifespan;

        public SendEmailParams(String redirectUri, String clientId, Integer lifespan) {
            this.redirectUri = redirectUri;
            this.clientId = clientId;
            this.lifespan = lifespan;
        }
    }
}

