/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import io.quarkus.bootstrap.util.PropertyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import org.jboss.logging.Logger;

public class IoUtils {
    private static final Path TMP_DIR = Paths.get(PropertyUtils.getProperty("java.io.tmpdir"), new String[0]);
    private static final Logger log = Logger.getLogger(IoUtils.class);

    private static void failedToMkDir(Path dir) {
        throw new IllegalStateException("Failed to create directory " + dir);
    }

    public static Path createTmpDir(String name) {
        return IoUtils.mkdirs(TMP_DIR.resolve(name));
    }

    public static Path createRandomTmpDir() {
        return IoUtils.createTmpDir(UUID.randomUUID().toString());
    }

    public static Path createRandomDir(Path parentDir) {
        return IoUtils.mkdirs(parentDir.resolve(UUID.randomUUID().toString()));
    }

    public static Path mkdirs(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            IoUtils.failedToMkDir(dir);
        }
        return dir;
    }

    public static void recursiveDelete(Path root) {
        block15: {
            log.debugf("Recursively delete path %s", (Object)root);
            if (root == null || !Files.exists(root, new LinkOption[0])) {
                return;
            }
            try {
                if (Files.isDirectory(root, new LinkOption[0])) {
                    try (DirectoryStream<Path> ds = Files.newDirectoryStream(root);){
                        IoUtils.recursiveDelete(ds);
                    }
                    try {
                        Files.delete(root);
                    }
                    catch (IOException e) {
                        log.debugf((Throwable)e, "Unable to delete directory %s", (Object)root);
                    }
                    break block15;
                }
                log.debugf("Delete file %s", (Object)root);
                try {
                    Files.delete(root);
                }
                catch (IOException e) {
                    log.debugf((Throwable)e, "Unable to delete file %s", (Object)root);
                }
            }
            catch (IOException e) {
                log.debugf((Throwable)e, "Error recursively deleting directory", new Object[0]);
            }
        }
    }

    public static void createOrEmptyDir(Path dir) throws IOException {
        log.debugf("Create or empty directory %s", (Object)dir);
        Objects.requireNonNull(dir);
        if (!Files.exists(dir, new LinkOption[0])) {
            log.debugf("Directory %s does not exist, create directories", (Object)dir);
            Files.createDirectories(dir, new FileAttribute[0]);
            return;
        }
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
            IoUtils.recursiveDelete(ds);
        }
    }

    private static void recursiveDelete(DirectoryStream<Path> ds) {
        if (ds instanceof SecureDirectoryStream) {
            SecureDirectoryStream sds = (SecureDirectoryStream)ds;
            IoUtils.recursiveDeleteSecure(sds);
        } else {
            for (Path p : ds) {
                IoUtils.recursiveDelete(p);
            }
        }
    }

    private static void recursiveDeleteSecure(SecureDirectoryStream<Path> sds) {
        for (Path p : sds) {
            BasicFileAttributes attrs;
            Path file = p.getFileName();
            try {
                attrs = sds.getFileAttributeView(file, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            }
            catch (IOException e) {
                log.debugf((Throwable)e, "Unable to query file type of %s", (Object)p);
                continue;
            }
            if (attrs.isDirectory()) {
                try {
                    try (SecureDirectoryStream<Path> nested = sds.newDirectoryStream(file, new LinkOption[0]);){
                        IoUtils.recursiveDeleteSecure(nested);
                    }
                    sds.deleteDirectory(file);
                }
                catch (IOException e) {
                    log.debugf((Throwable)e, "Unable to delete directory %s", (Object)p);
                }
                continue;
            }
            log.debugf("Delete file %s", (Object)p);
            try {
                sds.deleteFile(file);
            }
            catch (IOException e) {
                log.debugf((Throwable)e, "Unable to delete file %s", (Object)p);
            }
        }
    }

    public static Path copy(final Path source, final Path target) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
            Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    block2: {
                        Path targetDir = target.resolve(source.relativize(dir).toString());
                        try {
                            Files.copy(dir, targetDir, new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, target.resolve(source.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        return target;
    }

    @Deprecated(forRemoval=true)
    public static String readFile(Path file) throws IOException {
        return Files.readString(file, StandardCharsets.UTF_8);
    }

    public static void copy(OutputStream out, InputStream in) throws IOException {
        in.transferTo(out);
    }

    public static void writeFile(Path file, String content) throws IOException {
        Files.writeString(file, (CharSequence)content, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

