/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.AbstractEcKeyProvider;
import org.keycloak.models.RealmModel;

public class GeneratedEcdhKeyProvider
extends AbstractEcKeyProvider {
    private static final Logger logger = Logger.getLogger(GeneratedEcdhKeyProvider.class);

    public GeneratedEcdhKeyProvider(RealmModel realm, ComponentModel model) {
        super(realm, model);
    }

    @Override
    protected KeyWrapper loadKey(RealmModel realm, ComponentModel model) {
        String privateEcdhKeyBase64Encoded = (String)model.getConfig().getFirst((Object)"ecdhPrivateKey");
        String publicEcdhKeyBase64Encoded = (String)model.getConfig().getFirst((Object)"ecdhPublicKey");
        String ecdhAlgorithm = (String)model.getConfig().getFirst((Object)"ecdhAlgorithm");
        try {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(Base64.decode((String)privateEcdhKeyBase64Encoded));
            KeyFactory kf = KeyFactory.getInstance("EC");
            PrivateKey decodedPrivateKey = kf.generatePrivate(privateKeySpec);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decode((String)publicEcdhKeyBase64Encoded));
            PublicKey decodedPublicKey = kf.generatePublic(publicKeySpec);
            KeyPair keyPair = new KeyPair(decodedPublicKey, decodedPrivateKey);
            return this.createKeyWrapper(keyPair, ecdhAlgorithm, KeyUse.ENC);
        }
        catch (Exception e) {
            logger.warnf("Exception at decodeEcdhPublicKey. %s", (Object)e.toString());
            return null;
        }
    }
}

