/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.PropertiesConfigSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.keycloak.quarkus.runtime.Environment;

public final class PersistedConfigSource
extends PropertiesConfigSource {
    public static final String NAME = "PersistedConfigSource";
    public static final String PERSISTED_PROPERTIES = "META-INF/keycloak-persisted.properties";
    private static final PersistedConfigSource INSTANCE = new PersistedConfigSource();
    private static final ThreadLocal<Boolean> ENABLED = ThreadLocal.withInitial(() -> true);

    private PersistedConfigSource() {
        super(PersistedConfigSource.readProperties(), NAME, 200);
    }

    public static PersistedConfigSource getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return NAME;
    }

    public ConfigValue getConfigValue(String propertyName) {
        if (this.isEnabled()) {
            ConfigValue value = super.getConfigValue(propertyName);
            if (value != null) {
                return value;
            }
            return super.getConfigValue(propertyName.replace('-', '.'));
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        if (this.isEnabled()) {
            return super.getPropertyNames();
        }
        return Set.of();
    }

    private static Map<String, String> readProperties() {
        if (Environment.isRuntimeMode().booleanValue()) {
            HashMap<String, String> hashMap;
            block11: {
                InputStream fileStream = PersistedConfigSource.loadPersistedConfig();
                if (fileStream == null) {
                    return Collections.emptyMap();
                }
                InputStream inputStream = fileStream;
                try {
                    Properties properties = new Properties();
                    properties.load(fileStream);
                    HashMap<String, String> props = new HashMap<String, String>();
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        props.put(entry.getKey().toString(), entry.getValue().toString());
                    }
                    hashMap = props;
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to load persisted properties.", e);
                    }
                }
                inputStream.close();
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream loadPersistedConfig() {
        Path homePath = Environment.getHomePath();
        if (homePath == null) {
            return null;
        }
        File configFile = homePath.resolve("lib").resolve("quarkus").resolve("generated-bytecode.jar").toFile();
        if (!configFile.exists()) {
            return null;
        }
        try (ZipInputStream is = new ZipInputStream(new FileInputStream(configFile));){
            ZipEntry entry;
            do {
                if ((entry = is.getNextEntry()) == null) return null;
            } while (!entry.getName().equals(PERSISTED_PROPERTIES));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(is.readAllBytes());
            return byteArrayInputStream;
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to load persisted properties from " + configFile, cause);
        }
    }

    public void enable() {
        ENABLED.set(true);
    }

    public void disable() {
        ENABLED.set(false);
    }

    private boolean isEnabled() {
        return Boolean.TRUE.equals(ENABLED.get());
    }

    public <T> T runWithDisabled(Supplier<T> execution) {
        try {
            this.disable();
            T t = execution.get();
            return t;
        }
        finally {
            this.enable();
        }
    }
}

