/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.PropertyName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ConfigMappingNames {
    private final Map<String, Map<PropertyName, List<PropertyName>>> names;

    ConfigMappingNames(Map<String, Map<String, Set<String>>> names) {
        this.names = new HashMap<String, Map<PropertyName, List<PropertyName>>>(names.size());
        for (Map.Entry<String, Map<String, Set<String>>> mappings : names.entrySet()) {
            HashMap<PropertyName, List> mappingPropertyNames = new HashMap<PropertyName, List>();
            for (Map.Entry<String, Set<String>> mappingNames : mappings.getValue().entrySet()) {
                PropertyName key = PropertyName.name(mappingNames.getKey());
                mappingPropertyNames.putIfAbsent(key, new ArrayList());
                if (key.getName().contains("*")) {
                    mappingPropertyNames.put(key, (List)mappingPropertyNames.remove(key));
                }
                for (String value : mappingNames.getValue()) {
                    ((List)mappingPropertyNames.get(key)).add(PropertyName.name(value));
                }
            }
            this.names.put(mappings.getKey(), mappingPropertyNames);
        }
    }

    public Map<String, Map<PropertyName, List<PropertyName>>> getNames() {
        return this.names;
    }

    boolean hasAnyName(String mapping, String rootPath, String path, Iterable<String> names) {
        Map<PropertyName, List<PropertyName>> mappings = this.names.get(mapping);
        if (mappings == null) {
            return false;
        }
        if (rootPath == null || rootPath.isEmpty()) {
            return this.hasAnyName(mappings, path, names);
        }
        if (!path.startsWith(rootPath) || path.length() > rootPath.length() && path.charAt(rootPath.length()) != '.' && path.charAt(rootPath.length()) != '[') {
            return false;
        }
        PropertyName mappingName = path.length() == rootPath.length() ? PropertyName.name("") : (path.charAt(rootPath.length()) == '.' ? PropertyName.name(path.substring(rootPath.length() + 1)) : PropertyName.name(path.substring(rootPath.length())));
        List<PropertyName> mappingNames = mappings.get(mappingName);
        if (mappingNames == null) {
            return false;
        }
        for (String name : names) {
            PropertyName propertyName;
            if (!name.startsWith(path) || !mappingNames.contains(propertyName = name.length() > rootPath.length() && name.charAt(rootPath.length()) == '.' ? PropertyName.name(name.substring(rootPath.length() + 1)) : PropertyName.name(name.substring(rootPath.length())))) continue;
            return true;
        }
        return false;
    }

    boolean hasAnyName(Map<PropertyName, List<PropertyName>> mappings, String path, Iterable<String> names) {
        List<PropertyName> mappingNames = mappings.get(PropertyName.name(path));
        if (mappingNames == null || mappingNames.isEmpty()) {
            return false;
        }
        for (String name : names) {
            if (!name.startsWith(path) || !mappingNames.contains(PropertyName.name(name))) continue;
            return true;
        }
        return false;
    }
}

