/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.Tuple;
import jakarta.persistence.metamodel.Type;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.internal.EntitySqmPathSource;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.IllegalSelectQueryException;
import org.hibernate.query.Order;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmPathVisitor;
import org.hibernate.query.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.jpa.ParameterCollector;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmUtil {
    private SqmUtil() {
    }

    public static boolean isSelect(SqmStatement<?> sqm) {
        return sqm instanceof SqmSelectStatement;
    }

    public static boolean isMutation(SqmStatement<?> sqm) {
        return sqm instanceof SqmDmlStatement;
    }

    public static void verifyIsSelectStatement(SqmStatement<?> sqm, String hqlString) {
        if (!SqmUtil.isSelect(sqm)) {
            throw new IllegalSelectQueryException(String.format(Locale.ROOT, "Expecting a SELECT Query [%s], but found %s", SqmSelectStatement.class.getName(), sqm.getClass().getName()), hqlString);
        }
    }

    public static void verifyIsNonSelectStatement(SqmStatement<?> sqm, String hqlString) {
        if (!SqmUtil.isMutation(sqm)) {
            throw SqmUtil.expectingNonSelect(sqm, hqlString);
        }
    }

    public static IllegalQueryOperationException expectingNonSelect(SqmStatement<?> sqm, String hqlString) {
        return new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a non-SELECT Query [%s], but found %s", SqmDmlStatement.class.getName(), sqm.getClass().getName()), hqlString, null);
    }

    public static ModelPartContainer getTargetMappingIfNeeded(SqmPath<?> sqmPath, ModelPartContainer modelPartContainer, SqmToSqlAstConverter sqlAstCreationState) {
        EntityAssociationMapping association;
        ModelPart modelPart;
        Clause clause;
        SqmQueryPart<?> queryPart = sqlAstCreationState.getCurrentSqmQueryPart();
        if (queryPart != null && (clause = sqlAstCreationState.getCurrentClauseStack().getCurrent()) != Clause.FROM && modelPartContainer.getPartMappingType() != modelPartContainer && sqmPath.getLhs() instanceof SqmFrom && (modelPart = modelPartContainer instanceof PluralAttributeMapping ? SqmUtil.getCollectionPart((PluralAttributeMapping)modelPartContainer, NullnessUtil.castNonNull(sqmPath.getNavigablePath().getParent())) : modelPartContainer) instanceof EntityAssociationMapping && (association = (EntityAssociationMapping)modelPart).getTargetKeyPropertyNames().contains(sqmPath.getReferencedPathSource().getPathName()) && (clause == Clause.GROUP || clause == Clause.ORDER || !SqmUtil.isFkOptimizationAllowed(sqmPath.getLhs()) || queryPart.getFirstQuerySpec().groupByClauseContains(sqmPath.getNavigablePath(), sqlAstCreationState) || queryPart.getFirstQuerySpec().orderByClauseContains(sqmPath.getNavigablePath(), sqlAstCreationState))) {
            return association.getAssociatedEntityMappingType();
        }
        return modelPartContainer;
    }

    private static CollectionPart getCollectionPart(PluralAttributeMapping attribute, NavigablePath path) {
        CollectionPart.Nature nature = CollectionPart.Nature.fromNameExact(path.getLocalName());
        if (nature != null) {
            switch (nature) {
                case ELEMENT: {
                    return attribute.getElementDescriptor();
                }
                case INDEX: {
                    return attribute.getIndexDescriptor();
                }
            }
        }
        return null;
    }

    public static boolean isFkOptimizationAllowed(SqmPath<?> sqmPath) {
        if (sqmPath instanceof SqmJoin) {
            SqmJoin sqmJoin = (SqmJoin)sqmPath;
            switch (sqmJoin.getSqmJoinType()) {
                case INNER: 
                case LEFT: {
                    return !(sqmJoin instanceof SqmQualifiedJoin) || ((SqmQualifiedJoin)sqmJoin).getJoinPredicate() == null;
                }
            }
            return false;
        }
        return false;
    }

    public static List<NavigablePath> getWhereClauseNavigablePaths(SqmQuerySpec<?> querySpec) {
        SqmWhereClause where = querySpec.getWhereClause();
        if (where == null || where.getPredicate() == null) {
            return Collections.emptyList();
        }
        return SqmUtil.collectNavigablePaths(List.of(where.getPredicate()));
    }

    public static List<NavigablePath> getGroupByNavigablePaths(SqmQuerySpec<?> querySpec) {
        List<SqmExpression<?>> expressions = querySpec.getGroupByClauseExpressions();
        if (expressions.isEmpty()) {
            return Collections.emptyList();
        }
        return SqmUtil.collectNavigablePaths(expressions);
    }

    public static List<NavigablePath> getOrderByNavigablePaths(SqmQuerySpec<?> querySpec) {
        SqmOrderByClause order = querySpec.getOrderByClause();
        if (order == null || order.getSortSpecifications().isEmpty()) {
            return Collections.emptyList();
        }
        List<SqmExpression<?>> expressions = order.getSortSpecifications().stream().map(SqmSortSpecification::getSortExpression).collect(Collectors.toList());
        return SqmUtil.collectNavigablePaths(expressions);
    }

    private static List<NavigablePath> collectNavigablePaths(List<SqmExpression<?>> expressions) {
        ArrayList<NavigablePath> navigablePaths = CollectionHelper.arrayList(expressions.size());
        SqmPathVisitor pathVisitor = new SqmPathVisitor(path -> navigablePaths.add(path.getNavigablePath()));
        for (SqmExpression<?> expression : expressions) {
            if (expression instanceof SqmAliasedNodeRef) {
                NavigablePath navigablePath = ((SqmAliasedNodeRef)expression).getNavigablePath();
                if (navigablePath == null) continue;
                navigablePaths.add(navigablePath);
                continue;
            }
            expression.accept(pathVisitor);
        }
        return navigablePaths;
    }

    public static <T, A> SqmAttributeJoin<T, A> findCompatibleFetchJoin(SqmFrom<?, T> sqmFrom, SqmPathSource<A> pathSource, SqmJoinType requestedJoinType) {
        for (SqmJoin<T, ?> join : sqmFrom.getSqmJoins()) {
            SqmAttributeJoin attributeJoin;
            if (join.getReferencedPathSource() != pathSource || !(attributeJoin = (SqmAttributeJoin)join).isFetched()) continue;
            SqmJoinType joinType = join.getSqmJoinType();
            if (joinType != requestedJoinType) {
                throw new IllegalStateException(String.format("Requested join fetch with association [%s] with '%s' join type, but found existing join fetch with '%s' join type.", new Object[]{pathSource.getPathName(), requestedJoinType, joinType}));
            }
            return attributeJoin;
        }
        return null;
    }

    public static Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> generateJdbcParamsXref(DomainParameterXref domainParameterXref, JdbcParameterBySqmParameterAccess jdbcParameterBySqmParameterAccess) {
        if (domainParameterXref == null || !domainParameterXref.hasParameters()) {
            return Collections.emptyMap();
        }
        int queryParameterCount = domainParameterXref.getQueryParameterCount();
        IdentityHashMap result = new IdentityHashMap(queryParameterCount);
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter<?>>> entry : domainParameterXref.getQueryParameters().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter<?>> sqmParams = entry.getValue();
            Map sqmParamMap = result.computeIfAbsent(queryParam, qp -> new IdentityHashMap(sqmParams.size()));
            for (SqmParameter<?> sqmParam : sqmParams) {
                List<List<JdbcParameter>> lists = jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(sqmParam);
                sqmParamMap.put(sqmParam, SqmUtil.convert(lists));
                List<SqmParameter<?>> expansions = domainParameterXref.getExpansions(sqmParam);
                if (expansions.isEmpty()) continue;
                for (SqmParameter<?> expansion : expansions) {
                    List<List<JdbcParameter>> innerList = jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(expansion);
                    sqmParamMap.put(expansion, SqmUtil.convert(innerList));
                    result.put(queryParam, sqmParamMap);
                }
            }
        }
        return result;
    }

    private static List<JdbcParametersList> convert(List<List<JdbcParameter>> lists) {
        if (lists == null) {
            return null;
        }
        ArrayList<JdbcParametersList> output = new ArrayList<JdbcParametersList>(lists.size());
        for (List<JdbcParameter> element : lists) {
            output.add(JdbcParametersList.fromList(element));
        }
        return output;
    }

    public static JdbcParameterBindings createJdbcParameterBindings(QueryParameterBindings domainParamBindings, DomainParameterXref domainParameterXref, Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamXref, MappingMetamodel domainModel, Function<NavigablePath, TableGroup> tableGroupLocator, SqmParameterMappingModelResolutionAccess mappingModelResolutionAccess, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(domainParameterXref.getSqmParameterCount());
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter<?>>> entry : domainParameterXref.getQueryParameters().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter<?>> sqmParameters = entry.getValue();
            QueryParameterBinding<?> domainParamBinding = domainParamBindings.getBinding(queryParam);
            Map<SqmParameter<?>, List<JdbcParametersList>> jdbcParamMap = jdbcParamXref.get(queryParam);
            for (SqmParameter<?> sqmParameter : sqmParameters) {
                BasicValueConverter valueConverter;
                MappingModelExpressible<?> resolvedMappingModelType = mappingModelResolutionAccess.getResolvedMappingModelType(sqmParameter);
                if (resolvedMappingModelType != null) {
                    domainParamBinding.setType(resolvedMappingModelType);
                }
                Bindable parameterType = SqmUtil.determineParameterType(domainParamBinding, queryParam, sqmParameters, mappingModelResolutionAccess, session.getFactory());
                List<JdbcParametersList> jdbcParamsBinds = jdbcParamMap.get(sqmParameter);
                if (jdbcParamsBinds == null) continue;
                if (!domainParamBinding.isBound()) {
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                        parameterType.forEachJdbcType((position, jdbcMapping) -> jdbcParameterBindings.addBinding(jdbcParams.get(position), new JdbcParameterBindingImpl((JdbcMapping)jdbcMapping, null)));
                    }
                    continue;
                }
                if (domainParamBinding.isMultiValued()) {
                    Collection<?> bindValues = domainParamBinding.getBindValues();
                    Iterator<?> valueItr = bindValues.iterator();
                    Object firstValue = valueItr.next();
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                        SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, jdbcParams, firstValue, tableGroupLocator, session);
                    }
                    List<SqmParameter<?>> expansions = domainParameterXref.getExpansions(sqmParameter);
                    int expansionCount = bindValues.size() - 1;
                    int parameterUseCount = jdbcParamsBinds.size();
                    assert (expansions.size() == expansionCount * parameterUseCount);
                    int expansionPosition = 0;
                    while (valueItr.hasNext()) {
                        Object expandedValue = valueItr.next();
                        for (int j = 0; j < parameterUseCount; ++j) {
                            SqmParameter<?> expansionSqmParam = expansions.get(expansionPosition + j * expansionCount);
                            List<JdbcParametersList> jdbcParamBinds = jdbcParamMap.get(expansionSqmParam);
                            for (int i = 0; i < jdbcParamBinds.size(); ++i) {
                                JdbcParametersList expansionJdbcParams = jdbcParamBinds.get(i);
                                SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, expansionJdbcParams, expandedValue, tableGroupLocator, session);
                            }
                        }
                        ++expansionPosition;
                    }
                    continue;
                }
                JdbcMapping jdbcMapping2 = domainParamBinding.getType() instanceof JdbcMapping ? (JdbcMapping)((Object)domainParamBinding.getType()) : (domainParamBinding.getBindType() instanceof BasicValuedMapping ? ((BasicValuedMapping)domainParamBinding.getType()).getJdbcMapping() : null);
                BasicValueConverter basicValueConverter = valueConverter = jdbcMapping2 == null ? null : jdbcMapping2.getValueConverter();
                if (valueConverter != null) {
                    Object convertedValue = valueConverter.toRelationalValue(domainParamBinding.getBindValue());
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                        assert (jdbcParams.size() == 1);
                        JdbcParameter jdbcParameter = jdbcParams.get(0);
                        jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping2, convertedValue));
                    }
                    continue;
                }
                Object bindValue = domainParamBinding.getBindValue();
                if (bindValue == null) {
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                        for (int j = 0; j < jdbcParams.size(); ++j) {
                            JdbcParameter jdbcParameter = jdbcParams.get(j);
                            jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping2, bindValue));
                        }
                    }
                    continue;
                }
                for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                    JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                    SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, jdbcParams, bindValue, tableGroupLocator, session);
                }
            }
        }
        return jdbcParameterBindings;
    }

    private static void createValueBindings(JdbcParameterBindings jdbcParameterBindings, QueryParameterImplementor<?> domainParam, QueryParameterBinding<?> domainParamBinding, Bindable parameterType, JdbcParametersList jdbcParams, Object bindValue, Function<NavigablePath, TableGroup> tableGroupLocator, SharedSessionContractImplementor session) {
        EntityIdentifierMapping identifierMapping;
        if (parameterType == null) {
            throw new SqlTreeCreationException("Unable to interpret mapping-model type for Query parameter : " + domainParam);
        }
        if (parameterType instanceof PluralAttributeMapping) {
            parameterType = ((PluralAttributeMapping)parameterType).getElementDescriptor();
        }
        if (parameterType instanceof EntityIdentifierMapping) {
            identifierMapping = parameterType;
            EntityMappingType entityMapping = identifierMapping.findContainingEntityMapping();
            if (entityMapping.getRepresentationStrategy().getInstantiator().isInstance(bindValue, session.getFactory())) {
                bindValue = identifierMapping.getIdentifierIfNotUnsaved(bindValue, session);
            }
        } else if (parameterType instanceof EntityMappingType) {
            identifierMapping = ((EntityMappingType)((Object)parameterType)).getIdentifierMapping();
            EntityMappingType entityMapping = identifierMapping.findContainingEntityMapping();
            parameterType = identifierMapping;
            if (entityMapping.getRepresentationStrategy().getInstantiator().isInstance(bindValue, session.getFactory())) {
                bindValue = identifierMapping.getIdentifierIfNotUnsaved(bindValue, session);
            }
        } else if (parameterType instanceof EntityAssociationMapping) {
            EntityAssociationMapping association = (EntityAssociationMapping)((Object)parameterType);
            if (association.getSideNature() == ForeignKeyDescriptor.Nature.TARGET) {
                bindValue = association.getAssociatedEntityMappingType().getIdentifierMapping().getIdentifier(bindValue);
                parameterType = association.getAssociatedEntityMappingType().getIdentifierMapping();
            } else {
                bindValue = association.getForeignKeyDescriptor().getAssociationKeyFromSide(bindValue, association.getSideNature().inverse(), session);
                parameterType = association.getForeignKeyDescriptor();
            }
        } else if (parameterType instanceof JavaObjectType) {
            parameterType = domainParamBinding.getType();
        }
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(bindValue, parameterType, jdbcParams, session);
        assert (offset == jdbcParams.size());
    }

    public static Bindable determineParameterType(QueryParameterBinding<?> binding, QueryParameterImplementor<?> parameter, List<SqmParameter<?>> sqmParameters, SqmParameterMappingModelResolutionAccess mappingModelResolutionAccess, SessionFactoryImplementor sessionFactory) {
        Bindable tryOne = SqmUtil.asBindable(binding.getBindType());
        if (tryOne != null) {
            return tryOne;
        }
        Bindable tryTwo = SqmUtil.asBindable(parameter.getHibernateType());
        if (tryTwo != null) {
            return tryTwo;
        }
        if (binding.getType() != null) {
            return binding.getType();
        }
        for (int i = 0; i < sqmParameters.size(); ++i) {
            MappingModelExpressible<?> mappingModelType = mappingModelResolutionAccess.getResolvedMappingModelType(sqmParameters.get(i));
            if (mappingModelType == null) continue;
            return mappingModelType;
        }
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        return typeConfiguration.standardBasicTypeForJavaType(parameter.getParameterType());
    }

    private static Bindable asBindable(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BasicTypeImpl) {
            return (BasicTypeImpl)o;
        }
        if (o instanceof ConvertedBasicTypeImpl) {
            return (ConvertedBasicTypeImpl)o;
        }
        if (o instanceof Bindable) {
            return (Bindable)o;
        }
        return null;
    }

    public static SqmStatement.ParameterResolutions resolveParameters(final SqmStatement<?> statement) {
        if (statement.getQuerySource() == SqmQuerySource.CRITERIA) {
            CriteriaParameterCollector parameterCollector = new CriteriaParameterCollector();
            ParameterCollector.collectParameters(statement, parameterCollector::process);
            return parameterCollector.makeResolution();
        }
        return new SqmStatement.ParameterResolutions(){

            @Override
            public Set<SqmParameter<?>> getSqmParameters() {
                return statement.getSqmParameters();
            }

            @Override
            public Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> getJpaCriteriaParamResolutions() {
                return Collections.emptyMap();
            }
        };
    }

    static JpaOrder sortSpecification(SqmSelectStatement<?> sqm, Order<?> order) {
        List<SqmSelectableNode<?>> items = ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelectionItems();
        int element = order.getElement();
        if (element < 1) {
            throw new IllegalQueryOperationException("Cannot order by element " + element + " (the first select item is element 1)");
        }
        if (element > items.size()) {
            throw new IllegalQueryOperationException("Cannot order by element " + element + " (there are only " + items.size() + " select items)");
        }
        SqmSelectableNode<?> selected = items.get(element - 1);
        NodeBuilder builder = sqm.nodeBuilder();
        if (order.getEntityClass() == null) {
            return new SqmSortSpecification(new SqmAliasedNodeRef(element, builder.getIntegerType(), builder), order.getDirection(), order.getNullPrecedence(), order.isCaseInsensitive());
        }
        if (items.size() == 1) {
            if (selected instanceof SqmRoot) {
                SqmFrom root = (SqmFrom)selected;
                if (!order.getEntityClass().isAssignableFrom(root.getJavaType())) {
                    throw new IllegalQueryOperationException("Select item was of wrong entity type");
                }
                StringTokenizer tokens = new StringTokenizer(order.getAttributeName(), ".");
                JpaPath path = root;
                while (tokens.hasMoreTokens()) {
                    path = path.get(tokens.nextToken());
                }
                return builder.sort((JpaExpression)path, order.getDirection(), order.getNullPrecedence(), order.isCaseInsensitive());
            }
            throw new IllegalQueryOperationException("Select item was not an entity type");
        }
        throw new IllegalQueryOperationException("Query has multiple items in the select list");
    }

    public static boolean isSelectionAssignableToResultType(SqmSelection<?> selection, Class<?> expectedResultType) {
        if (expectedResultType == null || selection != null && selection.getSelectableNode() instanceof SqmParameter) {
            return true;
        }
        if (selection == null || !SqmUtil.isHqlTuple(selection) && selection.getSelectableNode().isCompoundSelection()) {
            return false;
        }
        JavaType nodeJavaType = selection.getNodeJavaType();
        return nodeJavaType != null && expectedResultType.isAssignableFrom(nodeJavaType.getJavaTypeClass());
    }

    public static boolean isHqlTuple(SqmSelection<?> selection) {
        return selection != null && selection.getSelectableNode() instanceof SqmTuple;
    }

    public static Class<?> resolveExpressibleJavaTypeClass(SqmExpression<?> expression) {
        SqmExpressible expressible = expression.getExpressible();
        return expressible == null || expressible.getExpressibleJavaType() == null ? null : expressible.getExpressibleJavaType().getJavaTypeClass();
    }

    public static void validateQueryReturnType(SqmQueryPart<?> queryPart, @Nullable Class<?> expectedResultType) {
        if (expectedResultType != null && !SqmUtil.isResultTypeAlwaysAllowed(expectedResultType)) {
            SqmUtil.checkQueryReturnType(queryPart, expectedResultType);
        }
    }

    public static void checkQueryReturnType(SqmQueryPart<?> queryPart, Class<?> expectedResultType) {
        if (queryPart instanceof SqmQuerySpec) {
            SqmUtil.checkQueryReturnType((SqmQuerySpec)queryPart, expectedResultType);
        } else {
            SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
            for (SqmQueryPart sqmQueryPart : queryGroup.getQueryParts()) {
                SqmUtil.checkQueryReturnType(sqmQueryPart, expectedResultType);
            }
        }
    }

    private static void checkQueryReturnType(SqmQuerySpec<?> querySpec, Class<?> expectedResultClass) {
        block7: {
            List<SqmSelection<?>> selections;
            SessionFactoryImplementor sessionFactory;
            block8: {
                block5: {
                    block6: {
                        sessionFactory = querySpec.nodeBuilder().getSessionFactory();
                        selections = querySpec.getSelectClause().getSelections();
                        if (selections != null && !selections.isEmpty()) break block5;
                        List<SqmRoot<?>> sqmRoots = querySpec.getFromClause().getRoots();
                        if (sqmRoots == null || sqmRoots.isEmpty()) {
                            throw new IllegalArgumentException("Criteria did not define any query roots");
                        }
                        if (sqmRoots.size() != 1) break block6;
                        SqmUtil.verifySingularSelectionType(expectedResultClass, sessionFactory, (SqmSelectableNode)sqmRoots.get(0));
                        break block7;
                    }
                    throw new IllegalArgumentException("Criteria has multiple query roots");
                }
                if (selections.size() != 1) break block8;
                SqmSelection<?> sqmSelection = selections.get(0);
                SqmSelectableNode<?> selectableNode = sqmSelection.getSelectableNode();
                if (selectableNode.isCompoundSelection()) {
                    Class<?> expectedSelectItemType = expectedResultClass.isArray() ? expectedResultClass.getComponentType() : expectedResultClass;
                    for (JpaSelection<?> selection : selectableNode.getSelectionItems()) {
                        SqmUtil.verifySelectionType(expectedSelectItemType, sessionFactory, (SqmSelectableNode)selection);
                    }
                } else {
                    SqmUtil.verifySingularSelectionType(expectedResultClass, sessionFactory, sqmSelection.getSelectableNode());
                }
                break block7;
            }
            if (!expectedResultClass.isArray()) break block7;
            Class<?> componentType = expectedResultClass.getComponentType();
            for (SqmSelection<?> selection : selections) {
                SqmUtil.verifySelectionType(componentType, sessionFactory, selection.getSelectableNode());
            }
        }
    }

    private static void verifySingularSelectionType(Class<?> expectedResultClass, SessionFactoryImplementor sessionFactory, SqmSelectableNode<?> selectableNode) {
        block2: {
            try {
                SqmUtil.verifySelectionType(expectedResultClass, sessionFactory, selectableNode);
            }
            catch (QueryTypeMismatchException mismatchException) {
                Class selectedJavaType;
                JavaType javaTypeDescriptor = selectableNode.getJavaTypeDescriptor();
                if (javaTypeDescriptor == null || SqmUtil.hasMatchingConstructor(expectedResultClass, selectedJavaType = javaTypeDescriptor.getJavaTypeClass())) break block2;
                throw mismatchException;
            }
        }
    }

    private static <T> boolean hasMatchingConstructor(Class<T> expectedResultClass, Class<?> selectedJavaType) {
        try {
            expectedResultClass.getDeclaredConstructor(selectedJavaType);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static <T> void verifySelectionType(Class<T> expectedResultClass, SessionFactoryImplementor sessionFactory, SqmSelectableNode<?> selection) {
        SqmParameter sqmParameter;
        SqmExpressible nodeType;
        if (selection instanceof SqmParameter && ((nodeType = (sqmParameter = (SqmParameter)selection).getExpressible()) == null || nodeType.getExpressibleJavaType() == null)) {
            return;
        }
        if (!sessionFactory.getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled()) {
            SqmUtil.verifyResultType(expectedResultClass, selection.getExpressible());
        }
    }

    public static boolean isResultTypeAlwaysAllowed(Class<?> expectedResultClass) {
        return expectedResultClass == null || expectedResultClass == Object.class || expectedResultClass == Object[].class || expectedResultClass == List.class || expectedResultClass == Map.class || expectedResultClass == Tuple.class;
    }

    protected static void verifyResultType(Class<?> resultClass, @Nullable SqmExpressible<?> selectionExpressible) {
        if (selectionExpressible == null) {
            return;
        }
        JavaType<?> selectionExpressibleJavaType = selectionExpressible.getExpressibleJavaType();
        assert (selectionExpressibleJavaType != null);
        Class<?> selectionExpressibleJavaTypeClass = selectionExpressibleJavaType.getJavaTypeClass();
        if (selectionExpressibleJavaTypeClass == Object.class) {
            // empty if block
        }
        if (selectionExpressibleJavaTypeClass != Object.class) {
            PrimitiveJavaType primitiveJavaType;
            if (resultClass.isAssignableFrom(selectionExpressibleJavaTypeClass)) {
                return;
            }
            if (selectionExpressibleJavaType instanceof PrimitiveJavaType && (primitiveJavaType = (PrimitiveJavaType)selectionExpressibleJavaType).getPrimitiveClass() == resultClass) {
                return;
            }
            if (SqmUtil.isMatchingDateType(selectionExpressibleJavaTypeClass, resultClass, selectionExpressible)) {
                return;
            }
            if (SqmUtil.isEntityIdType(selectionExpressible, resultClass)) {
                return;
            }
            SqmUtil.throwQueryTypeMismatchException(resultClass, selectionExpressible);
        }
    }

    private static boolean isEntityIdType(SqmExpressible<?> selectionExpressible, Class<?> resultClass) {
        if (selectionExpressible instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableDomainType = (IdentifiableDomainType)selectionExpressible;
            Type idType = identifiableDomainType.getIdType();
            return resultClass.isAssignableFrom(idType.getBindableJavaType());
        }
        if (selectionExpressible instanceof EntitySqmPathSource) {
            EntitySqmPathSource entityPath = (EntitySqmPathSource)selectionExpressible;
            DomainType entityType = entityPath.getSqmPathType();
            Type idType = entityType.getIdType();
            return resultClass.isAssignableFrom(idType.getBindableJavaType());
        }
        return false;
    }

    private static boolean isMatchingDateType(Class<?> javaTypeClass, Class<?> resultClass, SqmExpressible<?> sqmExpressible) {
        return javaTypeClass == Date.class && SqmUtil.isMatchingDateJdbcType(resultClass, SqmUtil.getJdbcType(sqmExpressible));
    }

    private static JdbcType getJdbcType(SqmExpressible<?> sqmExpressible) {
        SqmPathSource pathSource;
        DomainType domainType;
        if (sqmExpressible instanceof BasicDomainType) {
            return ((BasicDomainType)sqmExpressible).getJdbcType();
        }
        if (sqmExpressible instanceof SqmPathSource && (domainType = (pathSource = (SqmPathSource)sqmExpressible).getSqmPathType()) instanceof BasicDomainType) {
            return ((BasicDomainType)domainType).getJdbcType();
        }
        return null;
    }

    private static boolean isMatchingDateJdbcType(Class<?> resultClass, JdbcType jdbcType) {
        if (jdbcType != null) {
            switch (jdbcType.getDefaultSqlTypeCode()) {
                case 91: {
                    return resultClass.isAssignableFrom(java.sql.Date.class);
                }
                case 92: {
                    return resultClass.isAssignableFrom(Time.class);
                }
                case 93: {
                    return resultClass.isAssignableFrom(Timestamp.class);
                }
            }
            return false;
        }
        return false;
    }

    private static void throwQueryTypeMismatchException(Class<?> resultClass, SqmExpressible<?> sqmExpressible) {
        throw new QueryTypeMismatchException(String.format("Specified result type [%s] did not match Query selection type [%s] - multiple selections: use Tuple or array", resultClass.getName(), sqmExpressible.getTypeName()));
    }

    private static class CriteriaParameterCollector {
        private Set<SqmParameter<?>> sqmParameters;
        private Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions;

        private CriteriaParameterCollector() {
        }

        public void process(SqmParameter<?> parameter) {
            if (this.sqmParameters == null) {
                this.sqmParameters = new LinkedHashSet();
            }
            if (parameter instanceof SqmJpaCriteriaParameterWrapper) {
                if (this.jpaCriteriaParamResolutions == null) {
                    this.jpaCriteriaParamResolutions = new IdentityHashMap();
                }
                SqmJpaCriteriaParameterWrapper wrapper = (SqmJpaCriteriaParameterWrapper)parameter;
                JpaCriteriaParameter criteriaParameter = wrapper.getJpaCriteriaParameter();
                List sqmParametersForCriteriaParameter = this.jpaCriteriaParamResolutions.computeIfAbsent(criteriaParameter, jcp -> new ArrayList());
                sqmParametersForCriteriaParameter.add(wrapper);
                this.sqmParameters.add(wrapper);
            } else {
                if (parameter instanceof JpaCriteriaParameter) {
                    throw new UnsupportedOperationException();
                }
                this.sqmParameters.add(parameter);
            }
        }

        private SqmStatement.ParameterResolutions makeResolution() {
            return new ParameterResolutionsImpl(this.sqmParameters == null ? Collections.emptySet() : this.sqmParameters, this.jpaCriteriaParamResolutions == null ? Collections.emptyMap() : this.jpaCriteriaParamResolutions);
        }
    }

    private static class ParameterResolutionsImpl
    implements SqmStatement.ParameterResolutions {
        private final Set<SqmParameter<?>> sqmParameters;
        private final Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> jpaCriteriaParamResolutions;

        public ParameterResolutionsImpl(Set<SqmParameter<?>> sqmParameters, Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions) {
            this.sqmParameters = sqmParameters;
            if (jpaCriteriaParamResolutions == null || jpaCriteriaParamResolutions.isEmpty()) {
                this.jpaCriteriaParamResolutions = Collections.emptyMap();
            } else {
                this.jpaCriteriaParamResolutions = new IdentityHashMap(CollectionHelper.determineProperSizing(jpaCriteriaParamResolutions));
                for (Map.Entry<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> entry : jpaCriteriaParamResolutions.entrySet()) {
                    Iterator<SqmJpaCriteriaParameterWrapper<?>> itr = entry.getValue().iterator();
                    if (!itr.hasNext()) {
                        throw new IllegalStateException("SqmJpaCriteriaParameterWrapper references for JpaCriteriaParameter [" + entry.getKey() + "] already exhausted");
                    }
                    this.jpaCriteriaParamResolutions.put(entry.getKey(), itr.next());
                }
            }
        }

        @Override
        public Set<SqmParameter<?>> getSqmParameters() {
            return this.sqmParameters;
        }

        @Override
        public Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> getJpaCriteriaParamResolutions() {
            return this.jpaCriteriaParamResolutions;
        }
    }
}

