/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.sessions.infinispan.InfinispanAuthenticationSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.ByRealmIdQueryConditionalRemover;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.remote.RemoteInfinispanAuthenticationSessionProvider;
import org.keycloak.models.sessions.infinispan.remote.transaction.AuthenticationSessionTransaction;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.sessions.AuthenticationSessionProviderFactory;

public class RemoteInfinispanAuthenticationSessionProviderFactory
implements AuthenticationSessionProviderFactory<RemoteInfinispanAuthenticationSessionProvider>,
EnvironmentDependentProviderFactory {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROTO_ENTITY = Marshalling.protoEntity(RootAuthenticationSessionEntity.class);
    private int authSessionsLimit;
    private volatile RemoteCache<String, RootAuthenticationSessionEntity> cache;

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isRemoteInfinispan();
    }

    public RemoteInfinispanAuthenticationSessionProvider create(KeycloakSession session) {
        return new RemoteInfinispanAuthenticationSessionProvider(session, this.authSessionsLimit, this.createAndEnlistTransaction(session));
    }

    public void init(Config.Scope config) {
        this.authSessionsLimit = InfinispanAuthenticationSessionProviderFactory.getAuthSessionsLimit(config);
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.cache = InfinispanConnectionProvider.getRemoteCache(factory, "authenticationSessions");
        logger.debugf("Provided initialized. session limit=%s", this.authSessionsLimit);
    }

    public void close() {
        this.cache = null;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("authSessionsLimit").type("int").helpText("The maximum number of concurrent authentication sessions per RootAuthenticationSession.").defaultValue((Object)300).add().build();
    }

    public String getId() {
        return "remote";
    }

    public int order() {
        return 1;
    }

    private AuthenticationSessionTransaction createAndEnlistTransaction(KeycloakSession session) {
        AuthenticationSessionTransaction tx = new AuthenticationSessionTransaction(this.cache, new ByRealmIdQueryConditionalRemover<String, RootAuthenticationSessionEntity>(PROTO_ENTITY));
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)tx);
        return tx;
    }
}

