/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.io.Serializable;
import org.hibernate.CacheMode;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CollectionCacheEntry;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.results.internal.StandardRowReader;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingResolution;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ResultsHelper {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ResultsHelper.class);

    public static <R> RowReader<R> createRowReader(SessionFactoryImplementor sessionFactory, RowTransformer<R> rowTransformer, Class<R> transformedResultJavaType, JdbcValues jdbcValues) {
        return ResultsHelper.createRowReader(sessionFactory, rowTransformer, transformedResultJavaType, jdbcValues.getValuesMapping());
    }

    public static <R> RowReader<R> createRowReader(SessionFactoryImplementor sessionFactory, RowTransformer<R> rowTransformer, Class<R> transformedResultJavaType, JdbcValuesMapping jdbcValuesMapping) {
        JdbcValuesMappingResolution jdbcValuesMappingResolution = jdbcValuesMapping.resolveAssemblers(sessionFactory);
        return new StandardRowReader<R>(jdbcValuesMappingResolution, rowTransformer, transformedResultJavaType);
    }

    public static void finalizeCollectionLoading(PersistenceContext persistenceContext, CollectionPersister collectionDescriptor, PersistentCollection<?> collectionInstance, Object key, boolean hasNoQueuedAdds) {
        StatisticsImplementor statistics;
        boolean addToCache;
        SharedSessionContractImplementor session = persistenceContext.getSession();
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(collectionInstance);
        if (collectionEntry == null) {
            collectionEntry = persistenceContext.addInitializedCollection(collectionDescriptor, collectionInstance, key);
        } else {
            collectionEntry.postInitialize(collectionInstance, session);
        }
        if (collectionDescriptor.getCollectionType().hasHolder()) {
            Object owner = collectionInstance.getOwner();
            EntityEntry entry = persistenceContext.getEntry(owner);
            PluralAttributeMapping mapping = collectionDescriptor.getAttributeMapping();
            int propertyIndex = mapping.getStateArrayPosition();
            Object[] loadedState = entry.getLoadedState();
            loadedState[propertyIndex] = mapping.getValue(owner);
            persistenceContext.addCollectionHolder(collectionInstance);
        }
        BatchFetchQueue batchFetchQueue = persistenceContext.getBatchFetchQueue();
        batchFetchQueue.removeBatchLoadableCollection(collectionEntry);
        boolean bl = addToCache = hasNoQueuedAdds && collectionDescriptor.hasCache() && session.getCacheMode().isPutEnabled() && !collectionEntry.isDoremove();
        if (addToCache) {
            ResultsHelper.addCollectionToCache(persistenceContext, collectionDescriptor, collectionInstance, key);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Collection fully initialized: %s", MessageHelper.collectionInfoString(collectionDescriptor, collectionInstance, key, session));
        }
        if ((statistics = session.getFactory().getStatistics()).isStatisticsEnabled()) {
            statistics.loadCollection(collectionDescriptor.getRole());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCollectionToCache(PersistenceContext persistenceContext, CollectionPersister collectionDescriptor, PersistentCollection<?> collectionInstance, Object key) {
        Object version;
        SharedSessionContractImplementor session = persistenceContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Caching collection: %s", MessageHelper.collectionInfoString(collectionDescriptor, collectionInstance, key, session));
        }
        if (session.getLoadQueryInfluencers().hasEnabledFilters() && collectionDescriptor.isAffectedByEnabledFilters(session)) {
            LOG.debug("Refusing to add to cache due to enabled filters");
            return;
        }
        if (collectionDescriptor.isVersioned()) {
            Object collectionOwner = persistenceContext.getCollectionOwner(key, collectionDescriptor);
            if (collectionOwner == null) {
                Object linkedOwner;
                if (collectionInstance != null && (linkedOwner = collectionInstance.getOwner()) != null) {
                    Object ownerKey = collectionDescriptor.getOwnerEntityPersister().getIdentifier(linkedOwner, session);
                    collectionOwner = persistenceContext.getCollectionOwner(ownerKey, collectionDescriptor);
                }
                if (collectionOwner == null) {
                    LOG.debugf("Unable to resolve owner of loading collection for second level caching. Refusing to add to cache.", new Object[0]);
                    return;
                }
            }
            version = persistenceContext.getEntry(collectionOwner).getVersion();
        } else {
            version = null;
        }
        CollectionCacheEntry entry = new CollectionCacheEntry(collectionInstance, collectionDescriptor);
        CollectionDataAccess cacheAccess = collectionDescriptor.getCacheAccessStrategy();
        Object cacheKey = cacheAccess.generateCacheKey(key, collectionDescriptor, session.getFactory(), session.getTenantIdentifier());
        boolean isPutFromLoad = true;
        if (collectionDescriptor.getElementType().isAssociationType()) {
            EntityPersister entityPersister = ((QueryableCollection)collectionDescriptor).getElementPersister();
            for (Serializable id : entry.getState()) {
                if (!persistenceContext.wasInsertedDuringTransaction(entityPersister, id)) continue;
                isPutFromLoad = false;
                break;
            }
        }
        if (isPutFromLoad) {
            SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
            EventManager eventManager = session.getEventManager();
            HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
            boolean put = false;
            try {
                eventListenerManager.cachePutStart();
                put = cacheAccess.putFromLoad(session, cacheKey, collectionDescriptor.getCacheEntryStructure().structure(entry), version, factory.getSessionFactoryOptions().isMinimalPutsEnabled() && session.getCacheMode() != CacheMode.REFRESH);
            }
            finally {
                eventManager.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cacheAccess, collectionDescriptor, put, EventManager.CacheActionDescription.COLLECTION_INSERT);
                eventListenerManager.cachePutEnd();
                StatisticsImplementor statistics = factory.getStatistics();
                if (put && statistics.isStatisticsEnabled()) {
                    statistics.collectionCachePut(collectionDescriptor.getNavigableRole(), collectionDescriptor.getCacheAccessStrategy().getRegion().getName());
                }
            }
        }
    }
}

