/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationStartBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.ShutdownListenerBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.logging.LoggingDecorateBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageRunnerBuildItem;
import io.quarkus.deployment.pkg.steps.GraalVM;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.pkg.steps.NoopNativeImageBuildRunner;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.netty.runtime.virtual.VirtualServerChannel;
import io.quarkus.runtime.ErrorPageAction;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.LiveReloadConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.runtime.logging.LogBuildTimeConfig;
import io.quarkus.runtime.shutdown.ShutdownConfig;
import io.quarkus.runtime.shutdown.ShutdownListener;
import io.quarkus.tls.TlsRegistryBuildItem;
import io.quarkus.utilities.OS;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.core.deployment.EventLoopCountBuildItem;
import io.quarkus.vertx.http.HttpServerOptionsCustomizer;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.ErrorPageActionsBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.InitialRouterBuildItem;
import io.quarkus.vertx.http.deployment.ManagementInterfaceFilterBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RequireBodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.RequireSocketHttpBuildItem;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.RouteConverter;
import io.quarkus.vertx.http.deployment.VertxWebRouterBuildItem;
import io.quarkus.vertx.http.deployment.WebsocketSubProtocolsBuildItem;
import io.quarkus.vertx.http.deployment.devmode.HttpRemoteDevClientProvider;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.spi.FrameworkEndpointsBuildItem;
import io.quarkus.vertx.http.deployment.spi.UseManagementInterfaceBuildItem;
import io.quarkus.vertx.http.runtime.BasicRoute;
import io.quarkus.vertx.http.runtime.CurrentRequestProducer;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpCertificateUpdateEventListener;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.VertxConfigBuilder;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.cors.CORSRecorder;
import io.quarkus.vertx.http.runtime.filters.GracefulShutdownFilter;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.impl.VertxImpl;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

class VertxHttpProcessor {
    private static final String META_INF_SERVICES_EXCHANGE_ATTRIBUTE_BUILDER = "META-INF/services/io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder";
    private static final Logger logger = Logger.getLogger(VertxHttpProcessor.class);
    private static final String HTTP_SSL_PREFIX = "quarkus.http.ssl.certificate.";
    private static final List<String> HTTP_SSL_PROPERTIES = List.of("key-store-file", "trust-store-file", "files", "key-files");

    VertxHttpProcessor() {
    }

    @BuildStep
    LogCategoryBuildItem logging() {
        return new LogCategoryBuildItem(Http1xServerRequest.class.getName(), Level.OFF);
    }

    @BuildStep
    HttpRootPathBuildItem httpRoot(HttpBuildTimeConfig httpBuildTimeConfig) {
        return new HttpRootPathBuildItem(httpBuildTimeConfig.rootPath);
    }

    @BuildStep
    List<RouteBuildItem> convertRoutes(List<io.quarkus.vertx.http.deployment.spi.RouteBuildItem> items, HttpRootPathBuildItem httpRootPathBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        ArrayList<RouteBuildItem> list = new ArrayList<RouteBuildItem>();
        for (io.quarkus.vertx.http.deployment.spi.RouteBuildItem item : items) {
            RouteBuildItem converted = RouteConverter.convert(item, httpRootPathBuildItem, nonApplicationRootPathBuildItem);
            list.add(converted);
        }
        return list;
    }

    @BuildStep
    NonApplicationRootPathBuildItem frameworkRoot(HttpBuildTimeConfig httpBuildTimeConfig, ManagementInterfaceBuildTimeConfig managementBuildTimeConfig) {
        String mrp = null;
        if (managementBuildTimeConfig.enabled) {
            mrp = managementBuildTimeConfig.rootPath;
        }
        return new NonApplicationRootPathBuildItem(httpBuildTimeConfig.rootPath, httpBuildTimeConfig.nonApplicationRootPath, mrp);
    }

    @BuildStep
    FrameworkEndpointsBuildItem frameworkEndpoints(NonApplicationRootPathBuildItem nonApplicationRootPath, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig, LaunchModeBuildItem launchModeBuildItem, List<RouteBuildItem> routes) {
        ArrayList<String> frameworkEndpoints = new ArrayList<String>();
        for (RouteBuildItem route : routes) {
            BasicRoute basicRoute;
            if (!RouteBuildItem.RouteType.FRAMEWORK_ROUTE.equals((Object)route.getRouteType())) continue;
            if (route.getConfiguredPathInfo() != null) {
                String endpointPath = route.getConfiguredPathInfo().getEndpointPath(nonApplicationRootPath, managementInterfaceBuildTimeConfig, launchModeBuildItem);
                frameworkEndpoints.add(endpointPath);
                continue;
            }
            if (route.getRouteFunction() == null || !(route.getRouteFunction() instanceof BasicRoute) || (basicRoute = (BasicRoute)route.getRouteFunction()).getPath() == null) continue;
            if (basicRoute.getPath().startsWith(nonApplicationRootPath.getNonApplicationRootPath())) {
                frameworkEndpoints.add(basicRoute.getPath());
                continue;
            }
            String adjustRoot = TemplateHtmlBuilder.adjustRoot((String)nonApplicationRootPath.getNonApplicationRootPath(), (String)basicRoute.getPath());
            frameworkEndpoints.add(adjustRoot);
        }
        return new FrameworkEndpointsBuildItem(frameworkEndpoints);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    FilterBuildItem cors(CORSRecorder recorder) {
        return new FilterBuildItem((Handler<RoutingContext>)recorder.corsHandler(), 300);
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(CurrentVertxRequest.class).addBeanClass(CurrentRequestProducer.class).addBeanClass(HttpCertificateUpdateEventListener.class).build();
    }

    @BuildStep
    UnremovableBeanBuildItem shouldNotRemoveHttpServerOptionsCustomizers() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{HttpServerOptionsCustomizer.class});
    }

    @BuildStep
    UseManagementInterfaceBuildItem useManagementInterfaceBuildItem(ManagementInterfaceBuildTimeConfig config) {
        if (config.enabled) {
            return new UseManagementInterfaceBuildItem();
        }
        return null;
    }

    @BuildStep
    void filterMultipleVertxInstancesWarning(LaunchModeBuildItem launchModeBuildItem, BuildProducer<LogCleanupFilterBuildItem> logCleanupFilterBuildItemBuildProducer) {
        if (launchModeBuildItem.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT)) {
            logCleanupFilterBuildItemBuildProducer.produce((BuildItem)new LogCleanupFilterBuildItem(VertxImpl.class.getName(), new String[]{"You're already on a Vert.x context, are you sure you want to create a new Vertx instance"}));
        }
    }

    @BuildStep
    public void kubernetes(BuildProducer<KubernetesPortBuildItem> kubernetesPorts) {
        kubernetesPorts.produce((BuildItem)KubernetesPortBuildItem.fromRuntimeConfiguration((String)"http", (String)"quarkus.http.port", (Integer)8080, (boolean)true));
        kubernetesPorts.produce((BuildItem)KubernetesPortBuildItem.fromRuntimeConfiguration((String)"https", (String)"quarkus.http.ssl-port", (Integer)8443, (boolean)VertxHttpProcessor.isSslConfigured()));
    }

    @BuildStep
    public KubernetesPortBuildItem kubernetesForManagement(ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
        return KubernetesPortBuildItem.fromRuntimeConfiguration((String)"management", (String)"quarkus.management.port", (Integer)9000, (boolean)managementInterfaceBuildTimeConfig.enabled);
    }

    @BuildStep
    void notFoundRoutes(List<RouteBuildItem> routes, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFound) {
        for (RouteBuildItem i : routes) {
            if (i.getNotFoundPageDisplayableEndpoint() == null) continue;
            notFound.produce((BuildItem)i.getNotFoundPageDisplayableEndpoint());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void preinitializeRouter(CoreVertxBuildItem vertx, VertxHttpRecorder recorder, BuildProducer<InitialRouterBuildItem> initialRouter, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        RuntimeValue httpRouteRouter = recorder.initializeRouter(vertx.getVertx());
        RuntimeValue mutinyRouter = recorder.createMutinyRouter(httpRouteRouter);
        initialRouter.produce((BuildItem)new InitialRouterBuildItem((RuntimeValue<Router>)httpRouteRouter, (RuntimeValue<io.vertx.mutiny.ext.web.Router>)mutinyRouter));
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Router.class).scope(BuiltinScope.APPLICATION.getInfo())).setRuntimeInit().runtimeValue(httpRouteRouter).done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(io.vertx.mutiny.ext.web.Router.class).scope(BuiltinScope.APPLICATION.getInfo())).setRuntimeInit().runtimeValue(mutinyRouter).done());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    VertxWebRouterBuildItem initializeRouter(VertxHttpRecorder recorder, InitialRouterBuildItem initialRouter, CoreVertxBuildItem vertx, List<RouteBuildItem> routes, HttpBuildTimeConfig httpBuildTimeConfig, ManagementInterfaceBuildTimeConfig managementBuildTimeConfig, NonApplicationRootPathBuildItem nonApplicationRootPath, ShutdownContextBuildItem shutdown) {
        RuntimeValue<Router> httpRouteRouter = initialRouter.getHttpRouter();
        RuntimeValue<io.vertx.mutiny.ext.web.Router> mutinyRouter = initialRouter.getMutinyRouter();
        RuntimeValue frameworkRouter = null;
        RuntimeValue mainRouter = null;
        RuntimeValue managementRouter = null;
        ArrayList redirectRoutes = new ArrayList();
        boolean frameworkRouterCreated = false;
        boolean mainRouterCreated = false;
        boolean isManagementInterfaceEnabled = managementBuildTimeConfig.enabled;
        if (isManagementInterfaceEnabled) {
            managementRouter = recorder.initializeRouter(vertx.getVertx());
        }
        for (RouteBuildItem route2 : routes) {
            if (route2.isManagement() && isManagementInterfaceEnabled) {
                recorder.addRoute(managementRouter, route2.getRouteFunction(), route2.getHandler(), route2.getType());
                continue;
            }
            if (nonApplicationRootPath.isDedicatedRouterRequired() && route2.isRouterFramework()) {
                if (!frameworkRouterCreated) {
                    frameworkRouter = recorder.initializeRouter(vertx.getVertx());
                    frameworkRouterCreated = true;
                }
                recorder.addRoute(frameworkRouter, route2.getRouteFunction(), route2.getHandler(), route2.getType());
                continue;
            }
            if (route2.isRouterAbsolute()) {
                if (!mainRouterCreated) {
                    mainRouter = recorder.initializeRouter(vertx.getVertx());
                    mainRouterCreated = true;
                }
                recorder.addRoute(mainRouter, route2.getRouteFunction(), route2.getHandler(), route2.getType());
                continue;
            }
            recorder.addRoute(httpRouteRouter, route2.getRouteFunction(), route2.getHandler(), route2.getType());
        }
        if (!httpBuildTimeConfig.rootPath.equals("/") && !mainRouterCreated) {
            mainRouter = recorder.initializeRouter(vertx.getVertx());
        }
        if (frameworkRouterCreated && redirectRoutes.size() > 0) {
            recorder.setNonApplicationRedirectHandler(nonApplicationRootPath.getNonApplicationRootPath(), nonApplicationRootPath.getNormalizedHttpRootPath());
            redirectRoutes.forEach(route -> recorder.addRoute(httpRouteRouter, route.getRouteFunction(), recorder.getNonApplicationRedirectHandler(), route.getType()));
        }
        return new VertxWebRouterBuildItem(httpRouteRouter, (RuntimeValue<Router>)mainRouter, frameworkRouter, (RuntimeValue<Router>)managementRouter, mutinyRouter);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    BodyHandlerBuildItem bodyHandler(VertxHttpRecorder recorder) {
        return new BodyHandlerBuildItem((Handler<RoutingContext>)recorder.createBodyHandler());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem finalizeRouter(Optional<LoggingDecorateBuildItem> decorateBuildItem, LogBuildTimeConfig logBuildTimeConfig, VertxHttpRecorder recorder, BeanContainerBuildItem beanContainer, CoreVertxBuildItem vertx, LaunchModeBuildItem launchMode, List<DefaultRouteBuildItem> defaultRoutes, List<FilterBuildItem> filters, List<ManagementInterfaceFilterBuildItem> managementInterfacefilters, VertxWebRouterBuildItem httpRouteRouter, HttpRootPathBuildItem httpRootPathBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, HttpBuildTimeConfig httpBuildTimeConfig, List<RequireBodyHandlerBuildItem> requireBodyHandlerBuildItems, BodyHandlerBuildItem bodyHandlerBuildItem, List<ErrorPageActionsBuildItem> errorPageActionsBuildItems, BuildProducer<ShutdownListenerBuildItem> shutdownListenerBuildItemBuildProducer, ShutdownConfig shutdownConfig, LiveReloadConfig lrc, CoreVertxBuildItem core, ExecutorBuildItem executorBuildItem, TlsRegistryBuildItem tlsRegistryBuildItem) throws BuildException {
        Optional<Object> mainRouter;
        Optional<Object> defaultRoute;
        if (defaultRoutes == null || defaultRoutes.isEmpty()) {
            defaultRoute = Optional.empty();
        } else {
            if (defaultRoutes.size() > 1) {
                throw new BuildException("Too many default routes.", Collections.emptyList());
            }
            defaultRoute = Optional.of(defaultRoutes.get(0));
        }
        HttpRemoteDevClientProvider.liveReloadConfig = lrc;
        GracefulShutdownFilter gracefulShutdownFilter = recorder.createGracefulShutdownHandler();
        shutdownListenerBuildItemBuildProducer.produce((BuildItem)new ShutdownListenerBuildItem((ShutdownListener)gracefulShutdownFilter));
        List listOfFilters = filters.stream().filter(f -> f.getHandler() != null).map(FilterBuildItem::toFilter).collect(Collectors.toList());
        List listOfManagementInterfaceFilters = managementInterfacefilters.stream().filter(f -> f.getHandler() != null).map(ManagementInterfaceFilterBuildItem::toFilter).collect(Collectors.toList());
        Optional<Object> optional = mainRouter = httpRouteRouter.getMainRouter() != null ? Optional.of(httpRouteRouter.getMainRouter()) : Optional.empty();
        if (httpRouteRouter.getFrameworkRouter() != null) {
            if (nonApplicationRootPathBuildItem.isAttachedToMainRouter()) {
                recorder.mountFrameworkRouter(httpRouteRouter.getHttpRouter(), httpRouteRouter.getFrameworkRouter(), nonApplicationRootPathBuildItem.getVertxRouterPath());
            } else {
                if (!mainRouter.isPresent()) {
                    mainRouter = Optional.of(recorder.initializeRouter(vertx.getVertx()));
                }
                recorder.mountFrameworkRouter((RuntimeValue)mainRouter.get(), httpRouteRouter.getFrameworkRouter(), nonApplicationRootPathBuildItem.getVertxRouterPath());
            }
        }
        ArrayList<ErrorPageAction> combinedActions = new ArrayList<ErrorPageAction>();
        for (ErrorPageActionsBuildItem errorPageActionsBuildItem : errorPageActionsBuildItems) {
            combinedActions.addAll(errorPageActionsBuildItem.getActions());
        }
        String srcMainJava = null;
        List knowClasses = null;
        if (decorateBuildItem.isPresent()) {
            srcMainJava = decorateBuildItem.get().getSrcMainJava().toString();
            knowClasses = decorateBuildItem.get().getKnowClasses();
        }
        recorder.finalizeRouter(beanContainer.getValue(), (Consumer)defaultRoute.map(DefaultRouteBuildItem::getRoute).orElse(null), listOfFilters, listOfManagementInterfaceFilters, vertx.getVertx(), lrc, mainRouter, httpRouteRouter.getHttpRouter(), httpRouteRouter.getMutinyRouter(), httpRouteRouter.getFrameworkRouter(), httpRouteRouter.getManagementRouter(), httpRootPathBuildItem.getRootPath(), nonApplicationRootPathBuildItem.getNonApplicationRootPath(), launchMode.getLaunchMode(), RequireBodyHandlerBuildItem.getBodyHandlerRequiredConditions(requireBodyHandlerBuildItems), bodyHandlerBuildItem.getHandler(), gracefulShutdownFilter, shutdownConfig, (Executor)executorBuildItem.getExecutorProxy(), logBuildTimeConfig, srcMainJava, knowClasses, combinedActions);
        return new ServiceStartBuildItem("vertx-http");
    }

    @BuildStep
    void config(BuildProducer<RunTimeConfigBuilderBuildItem> runtimeConfigBuilder) {
        runtimeConfigBuilder.produce((BuildItem)new RunTimeConfigBuilderBuildItem(VertxConfigBuilder.class));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void openSocket(ApplicationStartBuildItem start, LaunchModeBuildItem launchMode, CoreVertxBuildItem vertx, ShutdownContextBuildItem shutdown, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, HttpBuildTimeConfig httpBuildTimeConfig, Optional<RequireVirtualHttpBuildItem> requireVirtual, Optional<RequireSocketHttpBuildItem> requireSocket, EventLoopCountBuildItem eventLoopCount, List<WebsocketSubProtocolsBuildItem> websocketSubProtocols, Capabilities capabilities, VertxHttpRecorder recorder) throws IOException {
        boolean startVirtual;
        boolean bl = startVirtual = requireVirtual.isPresent() || httpBuildTimeConfig.virtual;
        if (startVirtual) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{VirtualServerChannel.class}).reason(this.getClass().getName()).build());
        }
        boolean startSocket = requireSocket.isPresent() || (!startVirtual || launchMode.getLaunchMode() != LaunchMode.NORMAL) && (requireVirtual.isEmpty() || !requireVirtual.get().isAlwaysVirtual());
        recorder.startServer(vertx.getVertx(), (ShutdownContext)shutdown, launchMode.getLaunchMode(), startVirtual, startSocket, eventLoopCount.getEventLoopCount(), websocketSubProtocols.stream().map(bi -> bi.getWebsocketSubProtocols()).collect(Collectors.toList()), launchMode.isAuxiliaryApplication(), !capabilities.isPresent("io.quarkus.vertx.websockets"));
    }

    @BuildStep
    void configureNativeCompilation(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.ext.web.handler.sockjs.impl.XhrTransport"));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.ext.auth.impl.jose.JWT"));
    }

    @BuildStep
    void registerExchangeAttributeBuilders(BuildProducer<ServiceProviderBuildItem> exchangeAttributeBuilderService) throws BuildException {
        List elements = QuarkusClassLoader.getElements((String)META_INF_SERVICES_EXCHANGE_ATTRIBUTE_BUILDER, (boolean)false);
        if (elements.isEmpty()) {
            logger.debug((Object)("Skipping registration of service providers for " + ExchangeAttributeBuilder.class));
            return;
        }
        for (ClassPathElement cpe : elements) {
            cpe.apply(tree -> {
                tree.accept(META_INF_SERVICES_EXCHANGE_ATTRIBUTE_BUILDER, visit -> {
                    if (visit == null) {
                        logger.debug((Object)("Skipping registration of service providers for " + ExchangeAttributeBuilder.class + " since no service descriptor file found"));
                    } else {
                        ServiceProviderBuildItem serviceProviderBuildItem;
                        try {
                            serviceProviderBuildItem = ServiceProviderBuildItem.allProviders((String)ExchangeAttributeBuilder.class.getName(), (Path)visit.getPath());
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        exchangeAttributeBuilderService.produce((BuildItem)serviceProviderBuildItem);
                    }
                });
                return null;
            });
        }
    }

    private static boolean isSslConfigured() {
        Config config = ConfigProvider.getConfig();
        HttpConfiguration.InsecureRequests insecureRequests = config.getOptionalValue("quarkus.http.insecure-requests", HttpConfiguration.InsecureRequests.class).orElse(HttpConfiguration.InsecureRequests.ENABLED);
        if (insecureRequests == HttpConfiguration.InsecureRequests.DISABLED) {
            return false;
        }
        for (String sslProperty : HTTP_SSL_PROPERTIES) {
            Optional property = config.getOptionalValues(HTTP_SSL_PREFIX + sslProperty, String.class);
            if (!property.isPresent()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void brotliResources(HttpBuildTimeConfig httpBuildTimeConfig, BuildProducer<NativeImageResourcePatternsBuildItem> resources, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses, NativeImageRunnerBuildItem nativeImageRunnerBuildItem) throws BuildException {
        GraalVM.Version v;
        String lib;
        if (!httpBuildTimeConfig.compressors.isPresent() || !((List)httpBuildTimeConfig.compressors.get()).stream().anyMatch(s -> s.equalsIgnoreCase("br"))) return;
        String arch = System.getProperty("os.arch");
        boolean amd64 = arch.matches("^(amd64|x64|x86_64)$");
        boolean aarch64 = "aarch64".equals(arch);
        if (OS.determineOS() == OS.LINUX) {
            if (amd64) {
                lib = "linux-x86_64/libbrotli.so";
            } else {
                if (!aarch64) throw new BuildException("Brotli compressor: No library for linux-" + arch);
                lib = "linux-aarch64/libbrotli.so";
            }
        } else if (OS.determineOS() == OS.WINDOWS) {
            if (amd64) {
                lib = "windows-x86_64/brotli.dll";
            } else {
                if (!aarch64) throw new BuildException("Brotli compressor: No library for windows-" + arch);
                lib = "windows-aarch64/brotli.dll";
            }
        } else {
            if (OS.determineOS() != OS.MAC) throw new BuildException("Brotli compressor: Your platform is not supported.");
            if (amd64) {
                lib = "osx-x86_64/libbrotli.dylib";
            } else {
                if (!aarch64) throw new BuildException("Brotli compressor: No library for osx-" + arch);
                lib = "osx-aarch64/libbrotli.dylib";
            }
        }
        resources.produce((BuildItem)NativeImageResourcePatternsBuildItem.builder().includePattern("\\QMETA-INF/services/com.aayushatharva.brotli4j.service.BrotliNativeProvider\\E").includePattern("\\Qlib/" + lib + "\\E").build());
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("com.aayushatharva.brotli4j.Brotli4jLoader"));
        if (nativeImageRunnerBuildItem.getBuildRunner() instanceof NoopNativeImageBuildRunner) {
            v = GraalVM.Version.CURRENT;
            logger.warnf("native-image is not installed. Using the default %s version as a reference to build native-sources step.", (Object)v.getVersionAsString());
        } else {
            v = nativeImageRunnerBuildItem.getBuildRunner().getGraalVMVersion();
        }
        if (v.compareTo(GraalVM.Version.VERSION_23_1_0) > 0) return;
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.handler.codec.compression.Brotli"));
    }
}

