/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.TypeUtil;
import io.smallrye.openapi.runtime.util.UtilLogging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public final class Annotations {
    private static final String VALUE = "value";
    private static final Map<PrimitiveType.Primitive, AnnotationValue.Kind> PRIMITIVES;
    private static final DotName CLASS_NAME;
    private static final Type ENUM_TYPE;
    private static final Type ANNOTATION_TYPE;
    private final AnnotationScannerContext context;
    private final Set<String> excludedPackages;

    public Annotations(AnnotationScannerContext context) {
        this.context = context;
        this.excludedPackages = context.getConfig().getScanCompositionExcludePackages().stream().map(pkg -> pkg.concat(".")).collect(Collectors.toSet());
    }

    private static List<AnnotationInstance> declaredAnnotations(ClassInfo target) {
        return new ArrayList<AnnotationInstance>(target.classAnnotations());
    }

    private static List<AnnotationInstance> filter(AnnotationTarget target, List<AnnotationInstance> annotations) {
        return annotations.stream().filter(a -> target.equals(a.target())).collect(Collectors.toList());
    }

    private static List<AnnotationInstance> getDeclaredAnnotations(AnnotationTarget target) {
        switch (target.kind()) {
            case CLASS: {
                return Annotations.declaredAnnotations(target.asClass());
            }
            case FIELD: {
                return Annotations.filter(target, target.asField().annotations());
            }
            case METHOD: {
                return Annotations.filter(target, target.asMethod().annotations());
            }
            case METHOD_PARAMETER: {
                return Annotations.filter(target, target.asMethodParameter().method().annotations());
            }
            case RECORD_COMPONENT: {
                return Annotations.filter(target, target.asRecordComponent().annotations());
            }
            case TYPE: {
                return Annotations.filter(target, Optional.ofNullable(target.asType().target()).map(Type::annotations).orElseGet(Collections::emptyList));
            }
        }
        return Collections.emptyList();
    }

    private boolean composable(DotName annotation) {
        String name = annotation.toString();
        for (String pkg : this.excludedPackages) {
            if (!name.startsWith(pkg)) continue;
            return false;
        }
        return true;
    }

    private Stream<AnnotationInstance> getComposedAnnotation(Collection<AnnotationInstance> declaredAnnotations, DotName name, Set<DotName> scanned) {
        return declaredAnnotations.stream().filter(AnnotationInstance::runtimeVisible).map(AnnotationInstance::name).filter(this::composable).map(this.context.getAugmentedIndex()::getClassByName).filter(Objects::nonNull).flatMap(annotationClass -> {
            if (scanned.contains(annotationClass.name())) {
                return null;
            }
            scanned.add(annotationClass.name());
            UtilLogging.logger.composedAnnotationSearch(name, annotationClass.name());
            return this.getDeclaredAnnotation((AnnotationTarget)annotationClass, name, scanned);
        }).filter(Objects::nonNull);
    }

    private Stream<AnnotationInstance> getDeclaredAnnotation(AnnotationTarget target, DotName name, Set<DotName> scanned) {
        if (target == null) {
            return Stream.empty();
        }
        List<AnnotationInstance> declaredAnnotations = Annotations.getDeclaredAnnotations(target);
        if (declaredAnnotations.isEmpty()) {
            return Stream.empty();
        }
        Stream<AnnotationInstance> direct = declaredAnnotations.stream().filter(a -> name.equals((Object)a.name()));
        Stream<AnnotationInstance> composed = this.getComposedAnnotation(declaredAnnotations, name, scanned);
        return Stream.concat(direct, composed);
    }

    private Stream<AnnotationInstance> getDeclaredAnnotation(AnnotationTarget target, DotName name) {
        return this.getDeclaredAnnotation(target, name, new HashSet<DotName>());
    }

    public <T> T value(AnnotationInstance annotation) {
        return annotation != null ? (T)this.value(annotation, VALUE) : null;
    }

    private AnnotationValue.Kind valueKind(AnnotationInstance annotation, AnnotationValue value) {
        boolean isArray = AnnotationValue.Kind.ARRAY == value.kind();
        AnnotationValue.Kind kind = isArray ? value.componentKind() : value.kind();
        AugmentedIndexView index = this.context.getAugmentedIndex();
        ClassInfo annoClass = index.getClassByName(annotation.name());
        if (kind == AnnotationValue.Kind.UNKNOWN && annoClass != null) {
            MethodInfo valueMethod = annoClass.method(value.name(), new Type[0]);
            Type valueType = valueMethod.returnType().asArrayType().component();
            switch (valueType.kind()) {
                case PRIMITIVE: {
                    return PRIMITIVES.get(valueType.asPrimitiveType().primitive());
                }
                case CLASS: 
                case PARAMETERIZED_TYPE: {
                    if (valueType.name().equals((Object)DotName.STRING_NAME)) {
                        return AnnotationValue.Kind.STRING;
                    }
                    if (valueType.name().equals((Object)CLASS_NAME)) {
                        return AnnotationValue.Kind.CLASS;
                    }
                    if (TypeUtil.isA(this.context, valueType, ENUM_TYPE)) {
                        return AnnotationValue.Kind.ENUM;
                    }
                    if (!TypeUtil.isA(this.context, valueType, ANNOTATION_TYPE)) break;
                    return AnnotationValue.Kind.NESTED;
                }
            }
        }
        return kind;
    }

    public <T> T value(AnnotationInstance annotation, String name) {
        AnnotationValue value = annotation.value(name);
        if (value == null) {
            return null;
        }
        boolean isArray = AnnotationValue.Kind.ARRAY == value.kind();
        switch (this.valueKind(annotation, value)) {
            case BOOLEAN: {
                return (T)(isArray ? value.asBooleanArray() : (boolean[])value.asBoolean());
            }
            case BYTE: {
                return (T)(isArray ? value.asByteArray() : (byte[])value.asByte());
            }
            case CHARACTER: {
                return (T)(isArray ? value.asCharArray() : (char[])Character.valueOf(value.asChar()));
            }
            case CLASS: {
                return (T)(isArray ? value.asClassArray() : value.asClass());
            }
            case DOUBLE: {
                return (T)(isArray ? value.asDoubleArray() : (double[])value.asDouble());
            }
            case ENUM: {
                return (T)(isArray ? value.asEnumArray() : value.asEnum());
            }
            case FLOAT: {
                return (T)(isArray ? value.asFloatArray() : (float[])Float.valueOf(value.asFloat()));
            }
            case INTEGER: {
                return (T)(isArray ? value.asIntArray() : (int[])value.asInt());
            }
            case LONG: {
                return (T)(isArray ? value.asLongArray() : (long[])value.asLong());
            }
            case NESTED: {
                return (T)(isArray ? value.asNestedArray() : value.asNested());
            }
            case SHORT: {
                return (T)(isArray ? value.asShortArray() : (short[])value.asShort());
            }
            case STRING: {
                return (T)(isArray ? value.asStringArray() : value.asString());
            }
        }
        return null;
    }

    public <T> T value(AnnotationInstance annotation, String name, T defaultValue) {
        T value = this.value(annotation, name);
        return value != null ? value : defaultValue;
    }

    public <T extends Enum<T>> T enumValue(AnnotationInstance annotation, String propertyName, Class<T> clazz) {
        String value;
        String string = value = annotation != null ? (String)this.value(annotation, propertyName) : null;
        if (value == null) {
            return null;
        }
        return (T)((Enum)Stream.of((Enum[])clazz.getEnumConstants()).filter(c -> c.name().equals(value)).findFirst().orElse(null));
    }

    public List<AnnotationInstance> getRepeatableAnnotation(AnnotationTarget target, DotName singleAnnotationName, DotName repeatableAnnotationName) {
        Stream<AnnotationInstance> single = this.getDeclaredAnnotation(target, singleAnnotationName);
        Stream<AnnotationInstance> wrapped = this.getDeclaredAnnotation(target, repeatableAnnotationName).map(a -> (AnnotationInstance[])this.value((AnnotationInstance)a, VALUE)).filter(Objects::nonNull).flatMap(Arrays::stream).map(a -> AnnotationInstance.create((DotName)a.name(), (AnnotationTarget)target, (List)a.values()));
        return Stream.concat(single, wrapped).collect(Collectors.toList());
    }

    public AnnotationInstance getMethodParameterAnnotation(MethodInfo method, int parameterIndex, DotName annotationName) {
        return this.getDeclaredAnnotation((AnnotationTarget)MethodParameterInfo.create((MethodInfo)method, (short)((short)parameterIndex)), annotationName).findFirst().orElse(null);
    }

    public AnnotationInstance getMethodParameterAnnotation(MethodInfo method, Type parameterType, DotName annotationName) {
        int parameterIndex = method.parameterTypes().indexOf(parameterType);
        return this.getMethodParameterAnnotation(method, parameterIndex, annotationName);
    }

    public List<AnnotationInstance> getMethodParameterAnnotations(MethodInfo method, int parameterIndex) {
        return Annotations.getDeclaredAnnotations((AnnotationTarget)MethodParameterInfo.create((MethodInfo)method, (short)((short)parameterIndex)));
    }

    public List<AnnotationInstance> getMethodParameterAnnotations(MethodInfo method, Type parameterType) {
        int parameterIndex = method.parameterTypes().indexOf(parameterType);
        return this.getMethodParameterAnnotations(method, parameterIndex);
    }

    public boolean hasAnnotation(AnnotationTarget target, Collection<DotName> annotationNames) {
        return Objects.nonNull(this.getAnnotation(target, annotationNames));
    }

    public boolean hasAnnotation(AnnotationTarget target, DotName ... annotationNames) {
        return Objects.nonNull(this.getAnnotation(target, annotationNames));
    }

    public AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, DotName ... annotationName) {
        return this.getAnnotation(annotationTarget, Arrays.asList(annotationName));
    }

    public AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, Collection<DotName> annotationNames) {
        return annotationNames.stream().flatMap(annotationName -> this.getDeclaredAnnotation(annotationTarget, (DotName)annotationName)).findFirst().orElse(null);
    }

    public <T> T getAnnotationValue(AnnotationTarget target, DotName ... annotationNames) {
        return this.getAnnotationValue(target, Arrays.asList(annotationNames), VALUE, null);
    }

    public <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames) {
        return this.getAnnotationValue(target, annotationNames, VALUE, null);
    }

    public <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName, String propertyName) {
        return this.getAnnotationValue(target, Arrays.asList(annotationName), propertyName);
    }

    public <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames, String propertyName) {
        return this.getAnnotationValue(target, annotationNames, propertyName, null);
    }

    public <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames, String propertyName, T defaultValue) {
        AnnotationInstance annotation = this.getAnnotation(target, annotationNames);
        T value = null;
        if (annotation != null) {
            value = this.value(annotation, propertyName);
        }
        return value != null ? value : (T)defaultValue;
    }

    static {
        CLASS_NAME = DotName.createSimple((String)"java.lang.Class");
        ENUM_TYPE = Type.create((DotName)DotName.ENUM_NAME, (Type.Kind)Type.Kind.CLASS);
        ANNOTATION_TYPE = Type.create((DotName)DotName.createSimple((String)"java.lang.annotation.Annotation"), (Type.Kind)Type.Kind.CLASS);
        PRIMITIVES = new EnumMap<PrimitiveType.Primitive, AnnotationValue.Kind>(PrimitiveType.Primitive.class);
        PRIMITIVES.put(PrimitiveType.Primitive.BOOLEAN, AnnotationValue.Kind.BOOLEAN);
        PRIMITIVES.put(PrimitiveType.Primitive.BYTE, AnnotationValue.Kind.BYTE);
        PRIMITIVES.put(PrimitiveType.Primitive.CHAR, AnnotationValue.Kind.CHARACTER);
        PRIMITIVES.put(PrimitiveType.Primitive.DOUBLE, AnnotationValue.Kind.DOUBLE);
        PRIMITIVES.put(PrimitiveType.Primitive.FLOAT, AnnotationValue.Kind.FLOAT);
        PRIMITIVES.put(PrimitiveType.Primitive.INT, AnnotationValue.Kind.INTEGER);
        PRIMITIVES.put(PrimitiveType.Primitive.LONG, AnnotationValue.Kind.LONG);
        PRIMITIVES.put(PrimitiveType.Primitive.SHORT, AnnotationValue.Kind.SHORT);
    }
}

