/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.config.ConfigSupportLevel;
import org.keycloak.config.DeprecatedMetadata;
import org.keycloak.config.Option;
import org.keycloak.config.OptionCategory;

public class OptionBuilder<T> {
    private static final List<String> BOOLEAN_TYPE_VALUES = List.of(Boolean.TRUE.toString(), Boolean.FALSE.toString());
    private final Class<T> type;
    private final Class<?> auxiliaryType;
    private final String key;
    private OptionCategory category;
    private boolean hidden;
    private boolean build;
    private String description;
    private Optional<T> defaultValue;
    private List<String> expectedValues = List.of();
    private boolean strictExpectedValues;
    private DeprecatedMetadata deprecatedMetadata;

    public static <A> OptionBuilder<List<A>> listOptionBuilder(String key, Class<A> type) {
        return new OptionBuilder<List<A>>(key, List.class, type);
    }

    public OptionBuilder(String key, Class<T> type) {
        this(key, type, null);
    }

    private OptionBuilder(String key, Class<T> type, Class<?> auxiliaryType) {
        this.type = type;
        this.auxiliaryType = auxiliaryType;
        if (type.isArray() || (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) && type != List.class) {
            throw new IllegalArgumentException("Non-List multi-valued options are not yet supported");
        }
        this.key = key;
        this.category = OptionCategory.GENERAL;
        this.hidden = false;
        this.build = false;
        this.description = null;
        this.defaultValue = Optional.empty();
        this.strictExpectedValues = true;
    }

    public OptionBuilder<T> category(OptionCategory category) {
        this.category = category;
        return this;
    }

    public OptionBuilder<T> hidden() {
        this.hidden = true;
        return this;
    }

    public OptionBuilder<T> buildTime(boolean build) {
        this.build = build;
        return this;
    }

    public OptionBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public OptionBuilder<T> defaultValue(Optional<T> defaultV) {
        this.defaultValue = defaultV;
        return this;
    }

    public OptionBuilder<T> defaultValue(T defaultV) {
        this.defaultValue = Optional.ofNullable(defaultV);
        return this;
    }

    public OptionBuilder<T> expectedValues(List<String> expected) {
        return this.expectedValues(true, expected);
    }

    public OptionBuilder<T> expectedValues(boolean strict, List<String> expected) {
        this.strictExpectedValues = strict;
        this.expectedValues = expected;
        return this;
    }

    public OptionBuilder<T> expectedValues(Class<? extends Enum> expected) {
        return this.expectedValues(true, expected);
    }

    public OptionBuilder<T> expectedValues(boolean strict, Class<? extends Enum> expected) {
        this.strictExpectedValues = strict;
        this.expectedValues = Stream.of(expected.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
        return this;
    }

    public OptionBuilder<T> expectedValues(T ... expected) {
        return this.expectedValues(true, expected);
    }

    public OptionBuilder<T> expectedValues(boolean strict, T ... expected) {
        this.strictExpectedValues = strict;
        this.expectedValues = Stream.of(expected).map(Object::toString).collect(Collectors.toList());
        return this;
    }

    public OptionBuilder<T> deprecated() {
        this.deprecatedMetadata = DeprecatedMetadata.deprecateOption(null, new String[0]);
        return this;
    }

    public OptionBuilder<T> deprecatedMetadata(DeprecatedMetadata deprecatedMetadata) {
        this.deprecatedMetadata = deprecatedMetadata;
        return this;
    }

    public OptionBuilder<T> deprecatedValues(String note, T ... values) {
        this.deprecatedMetadata = DeprecatedMetadata.deprecateValues(note, (String[])Stream.of(values).map(Object::toString).toArray(String[]::new));
        return this;
    }

    public Option<T> build() {
        if (this.deprecatedMetadata == null && this.category.getSupportLevel() == ConfigSupportLevel.DEPRECATED) {
            this.deprecated();
        }
        Class<Object> expected = this.type;
        if (this.auxiliaryType != null) {
            expected = this.auxiliaryType;
        }
        if (CollectionUtil.isEmpty(this.expectedValues)) {
            if (Boolean.class.equals(expected)) {
                this.expectedValues(this.strictExpectedValues, BOOLEAN_TYPE_VALUES);
            }
            if (Enum.class.isAssignableFrom(expected)) {
                this.expectedValues(this.strictExpectedValues, expected);
            }
        }
        if (this.defaultValue.isEmpty() && Boolean.class.equals(expected)) {
            this.defaultValue = Optional.of(Boolean.FALSE);
        }
        return new Option<T>(this.type, this.key, this.category, this.hidden, this.build, this.description, this.defaultValue, this.expectedValues, this.strictExpectedValues, this.deprecatedMetadata);
    }
}

