/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.cors;

import jakarta.ws.rs.core.Response;
import java.util.concurrent.TimeUnit;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.Provider;
import org.keycloak.representations.AccessToken;
import org.keycloak.utils.KeycloakSessionUtil;

public interface Cors
extends Provider {
    public static final long DEFAULT_MAX_AGE = TimeUnit.HOURS.toSeconds(1L);
    public static final String DEFAULT_ALLOW_METHODS = "GET, HEAD, OPTIONS";
    public static final String DEFAULT_ALLOW_HEADERS = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers, DPoP";
    public static final String ORIGIN_HEADER = "Origin";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD = "*";

    public static Cors builder() {
        KeycloakSession session = KeycloakSessionUtil.getKeycloakSession();
        return (Cors)session.getProvider(Cors.class);
    }

    public Cors builder(Response.ResponseBuilder var1);

    public Cors preflight();

    public Cors auth();

    public Cors allowAllOrigins();

    public Cors allowedOrigins(KeycloakSession var1, ClientModel var2);

    public Cors allowedOrigins(AccessToken var1);

    public Cors allowedOrigins(String ... var1);

    public Cors allowedMethods(String ... var1);

    public Cors exposedHeaders(String ... var1);

    public void add();

    default public Response add(Response.ResponseBuilder builder) {
        if (builder == null) {
            throw new IllegalStateException("builder is not set");
        }
        this.add();
        return builder.build();
    }
}

