/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.OracleArrayJdbcType;
import org.hibernate.dialect.SqlAstTranslatorWithUpsert;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.UnionTableGroup;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class OracleSqlAstTranslator<T extends JdbcOperation>
extends SqlAstTranslatorWithUpsert<T> {
    public OracleSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
        }
    }

    @Override
    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        if (OracleSqlAstTranslator.hasNonTrivialFromClause(statement.getFromClause())) {
            this.visitUpdateStatementEmulateInlineView(statement);
        } else {
            this.renderUpdateClause(statement);
            this.renderSetClause(statement.getAssignments());
            this.visitWhereClause(statement.getRestriction());
            this.visitReturningColumns(statement.getReturningColumns());
        }
    }

    @Override
    protected void renderMergeUpdateClause(List<Assignment> assignments, Predicate wherePredicate) {
        this.appendSql(" then update");
        this.renderSetClause(assignments);
        this.visitWhereClause(wherePredicate);
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    @Override
    protected boolean needsRecursiveKeywordInWithClause() {
        return false;
    }

    @Override
    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    protected boolean supportsRecursiveSearchClause() {
        return true;
    }

    @Override
    protected boolean supportsRecursiveCycleClause() {
        return true;
    }

    @Override
    public void visitSqlSelection(SqlSelection sqlSelection) {
        if (this.getCurrentCteStatement() != null && this.getCurrentCteStatement().getMaterialization() == CteMaterialization.MATERIALIZED) {
            this.appendSql("/*+ materialize */ ");
        }
        super.visitSqlSelection(sqlSelection);
    }

    @Override
    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        AbstractSqlAstTranslator.LockStrategy strategy = super.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
        boolean followOnLockingDisabled = Boolean.FALSE.equals(followOnLocking);
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.isPartOfQueryGroup()) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.hasSetOperations(querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.needsLockingWrapper(querySpec) && !this.canApplyLockingWrapper(querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with OFFSET/FETCH is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        return strategy;
    }

    private boolean hasSetOperations(QuerySpec querySpec) {
        return querySpec.getFromClause().queryTableGroups(group -> group instanceof UnionTableGroup ? group : null) != null;
    }

    private boolean isPartOfQueryGroup() {
        return this.getQueryPartStack().findCurrentFirst(OracleSqlAstTranslator::partIsQueryGroup) != null;
    }

    private static QueryPart partIsQueryGroup(QueryPart part) {
        return part instanceof QueryGroup ? part : null;
    }

    @Override
    protected boolean shouldEmulateLateralWithIntersect(QueryPart queryPart) {
        return !queryPart.hasOffsetOrFetchClause();
    }

    @Override
    protected boolean supportsNestedSubqueryCorrelation() {
        return false;
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        boolean hasLimit;
        if (this.getQueryPartForRowNumbering() == queryPart) {
            return false;
        }
        boolean bl = hasLimit = queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseExpression() != null || queryPart.getOffsetClauseExpression() != null;
        if (!hasLimit) {
            return false;
        }
        if (this.supportsOffsetFetchClause()) {
            return queryPart instanceof QueryGroup && this.getClauseStack().isEmpty() && this.getStatement() instanceof InsertSelectStatement;
        }
        return true;
    }

    @Override
    protected void visitValuesList(List<Values> valuesList) {
        if (this.getDialect().getVersion().isSameOrAfter(23) || valuesList.size() < 2) {
            this.visitValuesListStandard(valuesList);
        } else {
            this.visitValuesListEmulateSelectUnion(valuesList);
        }
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    @Override
    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        this.append("table(");
        tableReference.getFunctionExpression().accept(this);
        this.append(')');
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        FetchClauseType fetchClauseType;
        Expression fetchExpression;
        Expression offsetExpression;
        EntityIdentifierMapping identifierMappingForLockingWrapper = this.identifierMappingForLockingWrapper(querySpec);
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            offsetExpression = this.getOffsetParameter();
            fetchExpression = this.getLimitParameter();
            fetchClauseType = FetchClauseType.ROWS_ONLY;
        } else {
            offsetExpression = querySpec.getOffsetClauseExpression();
            fetchExpression = querySpec.getFetchClauseExpression();
            fetchClauseType = querySpec.getFetchClauseType();
        }
        if (this.shouldEmulateFetchClause(querySpec)) {
            if (identifierMappingForLockingWrapper == null) {
                this.emulateFetchOffsetWithWindowFunctions(querySpec, offsetExpression, fetchExpression, fetchClauseType, true);
            } else {
                super.visitQuerySpec(this.createLockingWrapper(querySpec, offsetExpression, fetchExpression, fetchClauseType, identifierMappingForLockingWrapper));
                this.visitForUpdateClause(querySpec);
            }
        } else if (identifierMappingForLockingWrapper == null) {
            super.visitQuerySpec(querySpec);
        } else {
            super.visitQuerySpec(this.createLockingWrapper(querySpec, offsetExpression, fetchExpression, fetchClauseType, identifierMappingForLockingWrapper));
            this.visitForUpdateClause(querySpec);
        }
    }

    private QuerySpec createLockingWrapper(QuerySpec querySpec, Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, EntityIdentifierMapping identifierMappingForLockingWrapper) {
        TableGroup rootTableGroup = querySpec.getFromClause().getRoots().get(0);
        ArrayList idColumnReferences = new ArrayList(identifierMappingForLockingWrapper.getJdbcTypeCount());
        identifierMappingForLockingWrapper.forEachSelectable(0, (selectionIndex, selectableMapping) -> idColumnReferences.add(new ColumnReference(rootTableGroup.getPrimaryTableReference(), selectableMapping)));
        Expression idExpression = identifierMappingForLockingWrapper instanceof EmbeddableValuedModelPart ? new SqlTuple(idColumnReferences, identifierMappingForLockingWrapper) : (Expression)idColumnReferences.get(0);
        QuerySpec subquery = new QuerySpec(false, 1);
        for (ColumnReference idColumnReference : idColumnReferences) {
            subquery.getSelectClause().addSqlSelection(new SqlSelectionImpl(idColumnReference));
        }
        subquery.getFromClause().addRoot(rootTableGroup);
        subquery.applyPredicate(querySpec.getWhereClauseRestrictions());
        if (querySpec.hasSortSpecifications()) {
            for (SortSpecification sortSpecification : querySpec.getSortSpecifications()) {
                subquery.addSortSpecification(sortSpecification);
            }
        }
        subquery.setOffsetClauseExpression(offsetExpression);
        subquery.setFetchClauseExpression(fetchExpression, fetchClauseType);
        QuerySpec lockingWrapper = new QuerySpec(false, 1);
        lockingWrapper.getFromClause().addRoot(rootTableGroup);
        for (SqlSelection sqlSelection : querySpec.getSelectClause().getSqlSelections()) {
            lockingWrapper.getSelectClause().addSqlSelection(sqlSelection);
        }
        lockingWrapper.applyPredicate(new InSubQueryPredicate(idExpression, subquery, false));
        return lockingWrapper;
    }

    private EntityIdentifierMapping identifierMappingForLockingWrapper(QuerySpec querySpec) {
        if (this.canApplyLockingWrapper(querySpec) && this.needsLocking(querySpec) && this.needsLockingWrapper(querySpec) && querySpec.getGroupByClauseExpressions().isEmpty() && querySpec.getHavingClauseRestrictions() == null && !querySpec.getSelectClause().isDistinct() && !this.hasAggregateFunctions(querySpec)) {
            return ((EntityMappingType)querySpec.getFromClause().getRoots().get(0).getModelPart()).getIdentifierMapping();
        }
        return null;
    }

    private boolean canApplyLockingWrapper(QuerySpec querySpec) {
        FromClause fromClause;
        return querySpec.isRoot() && (fromClause = querySpec.getFromClause()).getRoots().size() == 1 && !fromClause.hasJoins() && fromClause.getRoots().get(0).getModelPart() instanceof EntityMappingType;
    }

    private boolean needsLockingWrapper(QuerySpec querySpec) {
        return querySpec.getFetchClauseType() != FetchClauseType.ROWS_ONLY || this.hasOffset(querySpec) || this.hasLimit(querySpec);
    }

    @Override
    protected boolean supportsSimpleQueryGrouping() {
        return this.supportsOffsetFetchClause();
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetFetchClause()) {
                if (this.getQueryPartStack().depth() > 1 && queryPart.hasSortSpecifications() && this.getQueryPartStack().peek(1) instanceof QueryGroup && (queryPart.isRoot() && !this.hasLimit() || !queryPart.hasOffsetOrFetchClause())) {
                    this.appendSql(" offset 0 rows");
                } else {
                    this.renderOffsetFetchClause(queryPart, true);
                }
            } else {
                this.assertRowsOnlyFetchClauseType(queryPart);
            }
        }
    }

    @Override
    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (!queryPart.hasSortSpecifications()) {
            this.appendSql("rownum");
        } else {
            super.renderRowNumber(selectClause, queryPart);
        }
    }

    @Override
    public void visitOver(Over<?> over) {
        Expression expression = over.getExpression();
        if (expression instanceof FunctionExpression && "row_number".equals(((FunctionExpression)expression).getFunctionName()) && over.getPartitions().isEmpty() && over.getOrderList().isEmpty() && over.getStartKind() == FrameKind.UNBOUNDED_PRECEDING && over.getEndKind() == FrameKind.CURRENT_ROW && over.getExclusion() == FrameExclusion.NO_OTHERS) {
            this.append("row_number() over(order by 1)");
            return;
        }
        super.visitOver(over);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType == null || lhsExpressionType.getJdbcTypeCount() != 1) {
            this.renderComparisonEmulateDecode(lhs, operator, rhs);
            return;
        }
        JdbcType jdbcType = lhsExpressionType.getSingleJdbcMapping().getJdbcType();
        switch (jdbcType.getDdlTypeCode()) {
            case 2009: {
                switch (operator) {
                    case EQUAL: 
                    case NOT_DISTINCT_FROM: {
                        this.appendSql("0=");
                        break;
                    }
                    case NOT_EQUAL: 
                    case DISTINCT_FROM: {
                        this.appendSql("1=");
                        break;
                    }
                    default: {
                        this.renderComparisonEmulateDecode(lhs, operator, rhs);
                        return;
                    }
                }
                this.appendSql("existsnode(xmldiff(");
                lhs.accept(this);
                this.appendSql(',');
                rhs.accept(this);
                this.appendSql("),'/*[local-name()=''xdiff'']/*')");
                break;
            }
            case 2004: 
            case 2005: 
            case 2011: {
                switch (operator) {
                    case EQUAL: {
                        this.appendSql("0=");
                        break;
                    }
                    case NOT_EQUAL: {
                        this.appendSql("-1=");
                        break;
                    }
                    default: {
                        this.renderComparisonEmulateDecode(lhs, operator, rhs);
                        return;
                    }
                }
                this.appendSql("dbms_lob.compare(");
                lhs.accept(this);
                this.appendSql(',');
                rhs.accept(this);
                this.appendSql(')');
                break;
            }
            case 2003: {
                String arrayTypeName = ((OracleArrayJdbcType)jdbcType).getSqlTypeName();
                switch (operator) {
                    case NOT_DISTINCT_FROM: 
                    case DISTINCT_FROM: {
                        this.appendSql(arrayTypeName);
                        this.appendSql("_distinct(");
                        this.visitSqlSelectExpression(lhs);
                        this.appendSql(',');
                        this.visitSqlSelectExpression(rhs);
                        this.appendSql(")");
                        break;
                    }
                    default: {
                        this.appendSql(arrayTypeName);
                        this.appendSql("_cmp(");
                        this.visitSqlSelectExpression(lhs);
                        this.appendSql(',');
                        this.visitSqlSelectExpression(rhs);
                        this.appendSql(")");
                    }
                }
                switch (operator) {
                    case DISTINCT_FROM: {
                        this.appendSql("=1");
                        break;
                    }
                    case NOT_DISTINCT_FROM: {
                        this.appendSql("=0");
                        break;
                    }
                    case EQUAL: {
                        this.appendSql("=0");
                        break;
                    }
                    case NOT_EQUAL: {
                        this.appendSql("<>0");
                        break;
                    }
                    case LESS_THAN: {
                        this.appendSql("=-1");
                        break;
                    }
                    case GREATER_THAN: {
                        this.appendSql("=1");
                        break;
                    }
                    case LESS_THAN_OR_EQUAL: {
                        this.appendSql("<=0");
                        break;
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        this.appendSql(">=0");
                    }
                }
                break;
            }
            default: {
                this.renderComparisonEmulateDecode(lhs, operator, rhs);
            }
        }
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        if (this.getDialect().getVersion().isSameOrAfter(23)) {
            super.renderSelectTupleComparison(lhsExpressions, tuple, operator);
        } else {
            this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql("floor");
        }
        super.visitBinaryArithmeticExpression(arithmeticExpression);
    }

    @Override
    protected boolean supportsDuplicateSelectItemsInQueryGroup() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected String getDual() {
        return "dual";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getDialect().getVersion().isSameOrAfter(23) ? "" : " from " + this.getDual();
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().supportsFetchClause(FetchClauseType.ROWS_ONLY);
    }

    @Override
    protected void visitSetAssignment(Assignment assignment) {
        List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
        if (columnReferences.size() == 1) {
            columnReferences.get(0).appendColumnForWrite(this);
            this.appendSql('=');
            Expression assignedValue = assignment.getAssignedValue();
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(assignedValue);
            if (sqlTuple != null) {
                assert (sqlTuple.getExpressions().size() == 1);
                sqlTuple.getExpressions().get(0).accept(this);
            } else {
                assignedValue.accept(this);
            }
        } else {
            int separator = 40;
            for (ColumnReference columnReference : columnReferences) {
                this.appendSql((char)separator);
                columnReference.appendColumnForWrite(this);
                separator = 44;
            }
            this.appendSql(")=");
            assignment.getAssignedValue().accept(this);
        }
    }

    @Override
    protected void renderMergeTargetAlias() {
        this.appendSql(" t");
    }

    @Override
    protected void renderMergeSourceAlias() {
        this.appendSql(" s");
    }

    @Override
    protected void renderMergeSource(OptionalTableUpdate optionalTableUpdate) {
        int i;
        List<ColumnValueBinding> valueBindings = optionalTableUpdate.getValueBindings();
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        this.appendSql("(select ");
        for (i = 0; i < keyBindings.size(); ++i) {
            ColumnValueBinding keyBinding = keyBindings.get(i);
            if (i > 0) {
                this.appendSql(", ");
            }
            this.renderCasted(keyBinding.getValueExpression());
            this.appendSql(" ");
            this.appendSql(keyBinding.getColumnReference().getColumnExpression());
        }
        for (i = 0; i < valueBindings.size(); ++i) {
            this.appendSql(", ");
            ColumnValueBinding valueBinding = valueBindings.get(i);
            this.renderCasted(valueBinding.getValueExpression());
            this.appendSql(" ");
            this.appendSql(valueBinding.getColumnReference().getColumnExpression());
        }
        this.appendSql(this.getFromDualForSelectOnly());
        this.appendSql(")");
        this.renderMergeSourceAlias();
    }
}

