/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.saml.mappers.UsernameTemplateMapper;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;

public class UsernameTemplateMapper
extends AbstractClaimMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc", "bitbucket", "facebook", "github", "gitlab", "google", "instagram", "linkedin-openid-connect", "microsoft", "openshift-v3", "openshift-v4", "paypal", "stackoverflow", "twitter"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
    public static final String TEMPLATE = "template";
    public static final String PROVIDER_ID = "oidc-username-idp-mapper";
    private static final Pattern SUBSTITUTION;

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Preprocessor";
    }

    public String getDisplayType() {
        return "Username Template Importer";
    }

    public void updateBrokeredUserLegacy(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        if (org.keycloak.broker.saml.mappers.UsernameTemplateMapper.getTarget((String)mapperModel.getConfig().get("target")) == UsernameTemplateMapper.Target.LOCAL && !realm.isRegistrationEmailAsUsername()) {
            user.setUsername(context.getModelUsername());
        }
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        this.setUserNameFromTemplate(mapperModel, context);
    }

    private void setUserNameFromTemplate(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String template = (String)mapperModel.getConfig().get(TEMPLATE);
        Matcher m = SUBSTITUTION.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String variable = m.group(1);
            UnaryOperator<String> transformer = Optional.ofNullable(m.group(2)).map(org.keycloak.broker.saml.mappers.UsernameTemplateMapper.TRANSFORMERS::get).orElse(UnaryOperator.identity());
            if (variable.equals("ALIAS")) {
                m.appendReplacement(sb, (String)transformer.apply(context.getIdpConfig().getAlias()));
                continue;
            }
            if (variable.equals("UUID")) {
                m.appendReplacement(sb, (String)transformer.apply(KeycloakModelUtils.generateId()));
                continue;
            }
            if (variable.startsWith("CLAIM.")) {
                String name = variable.substring("CLAIM.".length());
                Object value = AbstractClaimMapper.getClaimValue(context, name);
                if (value == null) {
                    value = "";
                } else if (value instanceof Collection && ((Collection)value).size() == 1) {
                    value = ((Collection)value).iterator().next();
                }
                m.appendReplacement(sb, (String)transformer.apply(value.toString()));
                continue;
            }
            m.appendReplacement(sb, m.group(1));
        }
        m.appendTail(sb);
        UsernameTemplateMapper.Target t = org.keycloak.broker.saml.mappers.UsernameTemplateMapper.getTarget((String)mapperModel.getConfig().get("target"));
        t.set(context, sb.toString());
    }

    public String getHelpText() {
        return "Format the username to import.";
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(TEMPLATE);
        property.setLabel("Template");
        property.setHelpText("Template to use to format the username to import.  Substitutions are enclosed in ${}.  For example: '${ALIAS}.${CLAIM.sub}'.  ALIAS is the provider alias.  CLAIM.<NAME> references an ID or Access token claim. \nThe substitution can be converted to upper or lower case by appending |uppercase or |lowercase to the substituted value, e.g. '${CLAIM.sub | lowercase}");
        property.setType("String");
        property.setDefaultValue((Object)"${ALIAS}.${CLAIM.preferred_username}");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("target");
        property.setLabel("Target");
        property.setHelpText("Destination field for the mapper. LOCAL (default) means that the changes are applied to the username stored in local database upon user import. BROKER_ID and BROKER_USERNAME means that the changes are stored into the ID or username used for federation user lookup, respectively.");
        property.setType("List");
        property.setOptions(org.keycloak.broker.saml.mappers.UsernameTemplateMapper.TARGETS);
        property.setDefaultValue((Object)UsernameTemplateMapper.Target.LOCAL.toString());
        configProperties.add(property);
        SUBSTITUTION = Pattern.compile("\\$\\{([^}]+?)(?:\\s*\\|\\s*(\\S+)\\s*)?\\}");
    }
}

