/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@ProtoTypeId(value=65596)
public class AuthenticatedClientSessionEntity
extends SessionEntity {
    public static final Logger logger = Logger.getLogger(AuthenticatedClientSessionEntity.class);
    public static final String LAST_TIMESTAMP_REMOTE = "lstr";
    public static final String CLIENT_ID_NOTE = "clientId";
    private String authMethod;
    private String redirectUri;
    private volatile int timestamp;
    private String action;
    private Map<String, String> notes = new ConcurrentHashMap<String, String>();
    private final UUID id;
    private transient String userSessionId;

    public AuthenticatedClientSessionEntity(UUID id) {
        this.id = id;
    }

    @ProtoField(value=2)
    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    @ProtoField(value=3)
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @ProtoField(value=4)
    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public int getUserSessionStarted() {
        String started = this.getNotes().get("userSessionStartedAt");
        return started == null ? this.timestamp : Integer.parseInt(started);
    }

    public int getStarted() {
        String started = this.getNotes().get("startedAt");
        return started == null ? this.timestamp : Integer.parseInt(started);
    }

    public boolean isUserSessionRememberMe() {
        return Boolean.parseBoolean(this.getNotes().get("userSessionRememberMe"));
    }

    public String getClientId() {
        return this.getNotes().get(CLIENT_ID_NOTE);
    }

    public void setClientId(String clientId) {
        this.getNotes().put(CLIENT_ID_NOTE, clientId);
    }

    @ProtoField(value=5)
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @ProtoField(value=6, mapImplementation=ConcurrentHashMap.class)
    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    @ProtoField(value=7)
    public UUID getId() {
        return this.id;
    }

    public String toString() {
        return "AuthenticatedClientSessionEntity [id=" + this.id + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticatedClientSessionEntity)) {
            return false;
        }
        AuthenticatedClientSessionEntity that = (AuthenticatedClientSessionEntity)o;
        return Objects.equals(this.id, that.id);
    }

    @ProtoFactory
    AuthenticatedClientSessionEntity(String realmId, String authMethod, String redirectUri, int timestamp, String action, Map<String, String> notes, UUID id) {
        super(realmId);
        this.authMethod = authMethod;
        this.redirectUri = redirectUri;
        this.timestamp = timestamp;
        this.action = action;
        this.notes = notes;
        this.id = id;
    }

    @Override
    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    @Override
    public SessionEntityWrapper mergeRemoteEntityWithLocalEntity(SessionEntityWrapper localEntityWrapper) {
        SessionEntityWrapper<AuthenticatedClientSessionEntity> entityWrapper;
        int timestampRemote = this.getTimestamp();
        if (localEntityWrapper == null) {
            entityWrapper = new SessionEntityWrapper<AuthenticatedClientSessionEntity>(this);
        } else {
            AuthenticatedClientSessionEntity localClientSession = (AuthenticatedClientSessionEntity)localEntityWrapper.getEntity();
            if (timestampRemote < localClientSession.getTimestamp()) {
                this.setTimestamp(localClientSession.getTimestamp());
            }
            entityWrapper = new SessionEntityWrapper<AuthenticatedClientSessionEntity>(localEntityWrapper.getLocalMetadata(), this);
        }
        entityWrapper.putLocalMetadataNoteInt(LAST_TIMESTAMP_REMOTE, timestampRemote);
        logger.debugf("Updating client session entity %s. timestamp=%d, timestampRemote=%d", (Object)this.getId(), (Object)this.getTimestamp(), (Object)timestampRemote);
        return entityWrapper;
    }

    public String getUserSessionId() {
        return this.userSessionId;
    }

    public void setUserSessionId(String userSessionId) {
        this.userSessionId = userSessionId;
    }

    public static AuthenticatedClientSessionEntity create(UUID clientSessionId, RealmModel realm, ClientModel client, UserSessionModel userSession) {
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity(clientSessionId);
        entity.setRealmId(realm.getId());
        entity.setClientId(client.getId());
        entity.setTimestamp(Time.currentTime());
        entity.getNotes().put("startedAt", String.valueOf(entity.getTimestamp()));
        entity.getNotes().put("userSessionStartedAt", String.valueOf(userSession.getStarted()));
        if (userSession.isRememberMe()) {
            entity.getNotes().put("userSessionRememberMe", "true");
        }
        return entity;
    }

    public static AuthenticatedClientSessionEntity createFromModel(AuthenticatedClientSessionModel model) {
        AuthenticatedClientSessionEntity entity = AuthenticatedClientSessionEntity.create(UUID.fromString(model.getId()), model.getRealm(), model.getClient(), model.getUserSession());
        entity.setNotes(model.getNotes() == null ? new ConcurrentHashMap() : model.getNotes());
        return entity;
    }
}

