/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.representations.idm.MembershipType;

@NamedQueries(value={@NamedQuery(name="userMemberOf", query="select m from UserGroupMembershipEntity m where m.user = :user and m.groupId = :groupId"), @NamedQuery(name="userGroupMembership", query="select m from UserGroupMembershipEntity m where m.user = :user"), @NamedQuery(name="groupMembership", query="select g.user from UserGroupMembershipEntity g where g.groupId = :groupId order by g.user.username"), @NamedQuery(name="groupMembershipByUser", query="select g.user from UserGroupMembershipEntity g where g.groupId = :groupId and (g.user.username = :search or g.user.email = :search or g.user.firstName = :search or g.user.lastName = :search) order by g.user.username"), @NamedQuery(name="groupMembershipByUserContained", query="select g.user from UserGroupMembershipEntity g where g.groupId = :groupId and (g.user.username like concat('%',:search,'%') or g.user.email like concat('%',:search,'%') or lower(g.user.firstName) like concat('%',:search,'%') or lower(g.user.lastName) like concat('%',:search,'%')) order by g.user.username"), @NamedQuery(name="deleteUserGroupMembershipByRealm", query="delete from  UserGroupMembershipEntity mapping where mapping.user IN (select u from UserEntity u where u.realmId=:realmId)"), @NamedQuery(name="deleteUserGroupMembershipsByRealmAndLink", query="delete from  UserGroupMembershipEntity mapping where mapping.user IN (select u from UserEntity u where u.realmId=:realmId and u.federationLink=:link)"), @NamedQuery(name="deleteUserGroupMembershipsByGroup", query="delete from UserGroupMembershipEntity m where m.groupId = :groupId"), @NamedQuery(name="deleteUserGroupMembershipsByUser", query="delete from UserGroupMembershipEntity m where m.user = :user"), @NamedQuery(name="userCountInGroups", query="select count(m.user) from UserGroupMembershipEntity m where m.user.realmId = :realmId and m.groupId in :groupIds")})
@Table(name="USER_GROUP_MEMBERSHIP")
@Entity
@IdClass(value=Key.class)
@EnhancementInfo(version="6.6.0.Final")
public class UserGroupMembershipEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_ID")
    protected UserEntity user;
    @Id
    @Column(name="GROUP_ID")
    protected String groupId;
    @Column(name="MEMBERSHIP_TYPE")
    String membershipType;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public UserEntity getUser() {
        return this.$$_hibernate_read_user();
    }

    public void setUser(UserEntity user) {
        this.$$_hibernate_write_user(user);
    }

    public String getGroupId() {
        return this.$$_hibernate_read_groupId();
    }

    public void setGroupId(String groupId) {
        this.$$_hibernate_write_groupId(groupId);
    }

    public MembershipType getMembershipType() {
        return MembershipType.valueOf((String)this.$$_hibernate_read_membershipType());
    }

    public void setMembershipType(MembershipType membershipType) {
        this.$$_hibernate_write_membershipType(membershipType.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UserGroupMembershipEntity)) {
            return false;
        }
        UserGroupMembershipEntity key = (UserGroupMembershipEntity)o;
        if (!this.$$_hibernate_read_groupId().equals(key.$$_hibernate_read_groupId())) {
            return false;
        }
        return this.$$_hibernate_read_user().equals(key.$$_hibernate_read_user());
    }

    public int hashCode() {
        int result = this.$$_hibernate_read_user().hashCode();
        result = 31 * result + this.$$_hibernate_read_groupId().hashCode();
        return result;
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        UserGroupMembershipEntity userGroupMembershipEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        UserGroupMembershipEntity userGroupMembershipEntity = this;
        userGroupMembershipEntity = null;
        userGroupMembershipEntity = NoopCollectionTracker.INSTANCE;
        return userGroupMembershipEntity;
    }

    public UserEntity $$_hibernate_read_user() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.user = (UserEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "user", (Object)this.user);
        }
        return this.user;
    }

    public void $$_hibernate_write_user(UserEntity userEntity) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.user = (UserEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "user", (Object)this.user, (Object)userEntity);
            return;
        }
        this.user = userEntity;
    }

    public String $$_hibernate_read_groupId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.groupId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "groupId", (Object)this.groupId);
        }
        return this.groupId;
    }

    public void $$_hibernate_write_groupId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.groupId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "groupId", (Object)this.groupId, (Object)string);
            return;
        }
        this.groupId = string;
    }

    public String $$_hibernate_read_membershipType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.membershipType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "membershipType", (Object)this.membershipType);
        }
        return this.membershipType;
    }

    public void $$_hibernate_write_membershipType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"membershipType", (Object)string, (Object)this.membershipType)) {
            this.$$_hibernate_trackChange("membershipType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.membershipType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "membershipType", (Object)this.membershipType, (Object)string);
            return;
        }
        this.membershipType = string;
    }

    public static class Key
    implements Serializable {
        protected UserEntity user;
        protected String groupId;

        public Key() {
        }

        public Key(UserEntity user, String groupId) {
            this.user = user;
            this.groupId = groupId;
        }

        public UserEntity getUser() {
            return this.user;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.groupId.equals(key.groupId)) {
                return false;
            }
            return this.user.equals(key.user);
        }

        public int hashCode() {
            int result = this.user.hashCode();
            result = 31 * result + this.groupId.hashCode();
            return result;
        }
    }
}

