/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ResolvableDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.paths.PathTree;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ResolvedArtifactDependency
extends ArtifactDependency
implements ResolvableDependency,
Serializable {
    private static final long serialVersionUID = 4038042391733012566L;
    private PathCollection paths;
    private final WorkspaceModule module;
    private final Collection<ArtifactCoords> deps;
    private volatile transient PathTree contentTree;

    public ResolvedArtifactDependency(ArtifactCoords coords) {
        this(coords, (PathCollection)null);
    }

    public ResolvedArtifactDependency(ArtifactCoords coords, Path resolvedPath) {
        this(coords, PathList.of(resolvedPath));
    }

    public ResolvedArtifactDependency(String groupId, String artifactId, String classifier, String type, String version, Path resolvedPath) {
        this(groupId, artifactId, classifier, type, version, PathList.of(resolvedPath));
    }

    public ResolvedArtifactDependency(String groupId, String artifactId, String classifier, String type, String version, PathCollection resolvedPath) {
        super(groupId, artifactId, classifier, type, version);
        this.paths = resolvedPath;
        this.module = null;
        this.deps = List.of();
    }

    public ResolvedArtifactDependency(ArtifactCoords coords, PathCollection resolvedPaths) {
        super(coords, new int[0]);
        this.paths = resolvedPaths;
        this.module = null;
        this.deps = List.of();
    }

    public ResolvedArtifactDependency(ResolvedDependencyBuilder builder) {
        super(builder);
        this.paths = builder.getResolvedPaths();
        this.module = builder.getWorkspaceModule();
        this.deps = builder.getDependencies();
    }

    @Override
    public PathCollection getResolvedPaths() {
        return this.paths;
    }

    @Override
    public void setResolvedPaths(PathCollection paths) {
        this.paths = paths;
    }

    @Override
    public WorkspaceModule getWorkspaceModule() {
        return this.module;
    }

    @Override
    public PathTree getContentTree() {
        return this.contentTree == null ? (this.contentTree = ResolvableDependency.super.getContentTree()) : this.contentTree;
    }

    @Override
    public Collection<ArtifactCoords> getDependencies() {
        return this.deps;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.module, this.paths);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ResolvableDependency)) {
            return false;
        }
        ResolvableDependency other = (ResolvableDependency)obj;
        return Objects.equals(this.module, other.getWorkspaceModule()) && Objects.equals(this.paths, other.getResolvedPaths());
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.toGACTVString()).append(this.paths);
        if (this.module != null) {
            buf.append(" " + this.module);
        }
        return buf.toString();
    }
}

