/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import jakarta.ws.rs.ForbiddenException;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.services.resources.admin.AdminAuth;

class RealmAuth {
    private AdminAuth.Resource resource;
    private AdminAuth auth;
    private ClientModel realmAdminApp;

    public RealmAuth(AdminAuth auth, ClientModel realmAdminApp) {
        this.auth = auth;
        this.realmAdminApp = realmAdminApp;
    }

    public RealmAuth init(AdminAuth.Resource resource) {
        this.resource = resource;
        return this;
    }

    public AdminAuth getAuth() {
        return this.auth;
    }

    public void requireAny() {
        if (!this.hasAny()) {
            throw new ForbiddenException();
        }
    }

    public boolean hasAny() {
        return this.auth.hasOneOfAppRole(this.realmAdminApp, AdminRoles.ALL_REALM_ROLES);
    }

    public boolean hasView() {
        return this.auth.hasOneOfAppRole(this.realmAdminApp, this.getViewRole(this.resource), this.getManageRole(this.resource));
    }

    public boolean hasManage() {
        return this.auth.hasOneOfAppRole(this.realmAdminApp, this.getManageRole(this.resource));
    }

    public void requireView() {
        if (!this.hasView()) {
            throw new ForbiddenException();
        }
    }

    public void requireManage() {
        if (!this.hasManage()) {
            throw new ForbiddenException();
        }
    }

    private String getViewRole(AdminAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.VIEW_CLIENTS;
            }
            case USER: {
                return AdminRoles.VIEW_USERS;
            }
            case REALM: {
                return AdminRoles.VIEW_REALM;
            }
            case EVENTS: {
                return AdminRoles.VIEW_EVENTS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.VIEW_IDENTITY_PROVIDERS;
            }
            case AUTHORIZATION: {
                return AdminRoles.VIEW_AUTHORIZATION;
            }
        }
        throw new IllegalStateException();
    }

    private String getManageRole(AdminAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.MANAGE_CLIENTS;
            }
            case USER: {
                return AdminRoles.MANAGE_USERS;
            }
            case REALM: {
                return AdminRoles.MANAGE_REALM;
            }
            case EVENTS: {
                return AdminRoles.MANAGE_EVENTS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.MANAGE_IDENTITY_PROVIDERS;
            }
            case IMPERSONATION: {
                return ImpersonationConstants.IMPERSONATION_ROLE;
            }
            case AUTHORIZATION: {
                return AdminRoles.MANAGE_AUTHORIZATION;
            }
        }
        throw new IllegalStateException();
    }
}

