/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.utils.OAuth2Error;

public class UserSessionUtil {
    private static final Logger logger = Logger.getLogger(UserSessionUtil.class);

    public static UserSessionModel findValidSession(KeycloakSession session, RealmModel realm, AccessToken token, EventBuilder event, ClientModel client) {
        OAuth2Error error = new OAuth2Error().json(false).realm(realm);
        return UserSessionUtil.findValidSession(session, realm, token, event, client, error);
    }

    public static UserSessionModel findValidSession(KeycloakSession session, RealmModel realm, AccessToken token, EventBuilder event, ClientModel client, OAuth2Error error) {
        if (token.getSessionId() == null) {
            return UserSessionUtil.createTransientSessionForClient(session, realm, token, client, event);
        }
        UserSessionProvider userSessionProvider = session.sessions();
        UserSessionModel userSession = userSessionProvider.getUserSessionIfClientExists(realm, token.getSessionId(), false, client.getId());
        if (userSession == null) {
            userSession = UserSessionUtil.getUserSessionWithImpersonatorClient(session, realm, token.getSessionId(), false, client.getId());
        }
        if (AuthenticationManager.isSessionValid(realm, userSession)) {
            UserSessionUtil.checkTokenIssuedAt(realm, token, userSession, event, client);
            event.session(userSession);
            return userSession;
        }
        UserSessionModel offlineUserSession = userSessionProvider.getUserSessionIfClientExists(realm, token.getSessionId(), true, client.getId());
        if (AuthenticationManager.isSessionValid(realm, offlineUserSession)) {
            UserSessionUtil.checkTokenIssuedAt(realm, token, offlineUserSession, event, client);
            event.session(offlineUserSession);
            return offlineUserSession;
        }
        if (userSession == null && offlineUserSession == null) {
            logger.debug((Object)"User session not found or doesn't have client attached on it");
            event.error("user_session_not_found");
            throw error.invalidToken("User session not found or doesn't have client attached on it");
        }
        event.session(Objects.requireNonNullElse(userSession, offlineUserSession));
        logger.debug((Object)"Session expired");
        event.error("session_expired");
        throw error.invalidToken("Session expired");
    }

    private static UserSessionModel createTransientSessionForClient(KeycloakSession session, RealmModel realm, AccessToken token, ClientModel client, EventBuilder event) {
        OAuth2Error error = new OAuth2Error().json(false).realm(realm);
        UserModel user = TokenManager.lookupUserFromStatelessToken(session, realm, token);
        if (user == null) {
            logger.debug((Object)"Transient User not found");
            event.error("user_not_found");
            throw error.invalidToken("User not found");
        }
        ClientConnection clientConnection = session.getContext().getConnection();
        UserSessionModel userSession = new UserSessionManager(session).createUserSession(KeycloakModelUtils.generateId(), realm, user, user.getUsername(), clientConnection.getRemoteAddr(), "client_auth", false, null, null, UserSessionModel.SessionPersistenceState.TRANSIENT);
        RootAuthenticationSessionModel rootAuthSession = session.authenticationSessions().createRootAuthenticationSession(realm);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client);
        authSession.setAuthenticatedUser(userSession.getUser());
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(session.getContext().getUri().getBaseUri(), realm.getName()));
        AuthenticationManager.setClientScopesInSession(session, authSession);
        TokenManager.attachAuthenticationSession(session, userSession, authSession);
        return userSession;
    }

    public static void checkTokenIssuedAt(RealmModel realm, AccessToken token, UserSessionModel userSession, EventBuilder event, ClientModel client) {
        OAuth2Error error = new OAuth2Error().json(false).realm(realm);
        if (token.isIssuedBeforeSessionStart((long)userSession.getStarted())) {
            logger.debug((Object)"Stale token for user session");
            event.error("invalid_token");
            throw error.invalidToken("Stale token");
        }
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        if (clientSession != null && token.isIssuedBeforeSessionStart((long)clientSession.getStarted())) {
            logger.debug((Object)"Stale token for client session");
            event.error("invalid_token");
            throw error.invalidToken("Stale token");
        }
    }

    public static UserSessionModel getUserSessionWithImpersonatorClient(KeycloakSession session, RealmModel realm, String userSessionId, boolean offline, String clientUUID) {
        return session.sessions().getUserSessionWithPredicate(realm, userSessionId, offline, userSession -> Objects.equals(clientUUID, userSession.getNote(ImpersonationSessionNote.IMPERSONATOR_CLIENT.toString())));
    }
}

