/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.AbstractNamedQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.sql.internal.NamedNativeQueryMementoImpl;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;

public class NamedNativeQueryDefinitionImpl
extends AbstractNamedQueryDefinition
implements NamedNativeQueryDefinition {
    private final String sqlString;
    private final String resultSetMappingName;
    private final String resultSetMappingClassName;
    private final Set<String> querySpaces;
    private final Integer firstResult;
    private final Integer maxResults;

    public NamedNativeQueryDefinitionImpl(String name, String sqlString, String resultSetMappingName, String resultSetMappingClassName, Set<String> querySpaces, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, Integer timeout, Integer fetchSize, String comment, Integer firstResult, Integer maxResults, Map<String, Object> hints) {
        super(name, cacheable, cacheRegion, cacheMode, flushMode, readOnly, null, timeout, fetchSize, comment, hints);
        this.sqlString = sqlString;
        this.resultSetMappingName = resultSetMappingName;
        this.resultSetMappingClassName = resultSetMappingClassName;
        this.querySpaces = querySpaces;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    @Override
    public String getSqlQueryString() {
        return this.sqlString;
    }

    @Override
    public String getResultSetMappingName() {
        return this.resultSetMappingName;
    }

    @Override
    public String getResultSetMappingClassName() {
        return this.resultSetMappingClassName;
    }

    @Override
    public NamedNativeQueryMemento resolve(SessionFactoryImplementor factory) {
        return new NamedNativeQueryMementoImpl(this.getRegistrationName(), this.sqlString, this.sqlString, this.resultSetMappingName, StringHelper.isNotEmpty(this.resultSetMappingClassName) ? factory.getServiceRegistry().requireService(ClassLoaderService.class).classForName(this.resultSetMappingClassName) : null, this.querySpaces, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.firstResult, this.maxResults, this.getHints());
    }
}

