/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.impl;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.interceptors.ExceptionSyncInvocationStage;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.SimpleAsyncInvocationStage;
import org.infinispan.util.concurrent.locks.DeadlockChecker;
import org.infinispan.util.concurrent.locks.DeadlockDetectedException;
import org.infinispan.util.concurrent.locks.ExtendedLockPromise;
import org.infinispan.util.concurrent.locks.LockListener;
import org.infinispan.util.concurrent.locks.LockReleasedException;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanLock {
    private static final Log log = LogFactory.getLog(InfinispanLock.class);
    private static final AtomicReferenceFieldUpdater<InfinispanLock, LockRequest> OWNER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InfinispanLock.class, LockRequest.class, "current");
    private static final AtomicReferenceFieldUpdater<LockPlaceHolder, LockState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LockPlaceHolder.class, LockState.class, "lockState");
    private volatile Queue<LockRequest> pendingRequest;
    private final ConcurrentMap<Object, LockRequest> lockOwners;
    private final Runnable releaseRunnable;
    private final Executor nonBlockingExecutor;
    private TimeService timeService;
    private volatile LockRequest current;

    public InfinispanLock(Executor nonBlockingExecutor, TimeService timeService) {
        this(nonBlockingExecutor, timeService, null);
    }

    public InfinispanLock(Executor nonBlockingExecutor, TimeService timeService, Runnable releaseRunnable) {
        this.nonBlockingExecutor = nonBlockingExecutor;
        this.timeService = timeService;
        this.lockOwners = new ConcurrentHashMap<Object, LockRequest>();
        this.current = null;
        this.releaseRunnable = releaseRunnable;
    }

    public InfinispanLock(Executor nonBlockingExecutor, TimeService timeService, Runnable releaseRunnable, Object owner, ByRef<ExtendedLockPromise> lockPromise) {
        this.nonBlockingExecutor = nonBlockingExecutor;
        this.timeService = timeService;
        this.lockOwners = new ConcurrentHashMap<Object, LockRequest>();
        this.releaseRunnable = releaseRunnable;
        LockAcquired promise = new LockAcquired(owner);
        this.current = promise;
        this.lockOwners.put(owner, promise);
        lockPromise.set((Object)promise);
        if (log.isTraceEnabled()) {
            log.tracef("%s successfully acquired the lock.", owner);
        }
    }

    public void setTimeService(TimeService timeService) {
        if (timeService != null) {
            this.timeService = timeService;
        }
    }

    public ExtendedLockPromise acquire(Object lockOwner, long time, TimeUnit timeUnit) {
        LockRequest lockPlaceHolder;
        Objects.requireNonNull(lockOwner, "Lock Owner should be non-null");
        Objects.requireNonNull(timeUnit, "Time Unit should be non-null");
        if (log.isTraceEnabled()) {
            log.tracef("Acquire lock for %s. Timeout=%s (%s)", lockOwner, time, (Object)timeUnit);
        }
        if ((lockPlaceHolder = (LockRequest)this.lockOwners.get(lockOwner)) != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Lock owner already exists: %s", lockPlaceHolder);
            }
            return lockPlaceHolder;
        }
        lockPlaceHolder = this.createLockInfo(lockOwner, time, timeUnit);
        LockRequest other = this.lockOwners.putIfAbsent(lockOwner, lockPlaceHolder);
        if (other != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Lock owner already exists: %s", other);
            }
            return other;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Created a new one: %s", lockPlaceHolder);
        }
        this.addToPendingRequests(lockPlaceHolder);
        this.tryAcquire(null);
        return lockPlaceHolder;
    }

    public void release(Object lockOwner) {
        LockRequest currentLocked;
        LockRequest wantToRelease;
        Objects.requireNonNull(lockOwner, "Lock Owner should be non-null");
        if (log.isTraceEnabled()) {
            log.tracef("Release lock for %s.", lockOwner);
        }
        if ((wantToRelease = (LockRequest)this.lockOwners.get(lockOwner)) == null) {
            if (log.isTraceEnabled()) {
                log.tracef("%s not found!", lockOwner);
            }
            return;
        }
        boolean released = wantToRelease.setReleased();
        if (log.isTraceEnabled()) {
            log.tracef("Release lock for %s? %s", wantToRelease, released);
        }
        if ((currentLocked = this.current) == wantToRelease) {
            this.tryAcquire(wantToRelease);
        }
    }

    public Object getLockOwner() {
        LockRequest lockPlaceHolder = this.current;
        return lockPlaceHolder == null ? null : lockPlaceHolder.owner;
    }

    public boolean isLocked() {
        return this.current != null;
    }

    public void deadlockCheck(DeadlockChecker deadlockChecker) {
        if (deadlockChecker == null) {
            return;
        }
        LockRequest holder = this.current;
        if (holder != null) {
            this.forEachPendingRequest(request -> request.checkDeadlock(deadlockChecker, holder));
        }
    }

    public boolean containsLockOwner(Object lockOwner) {
        return this.lockOwners.containsKey(lockOwner);
    }

    private void onCanceled(LockRequest canceled) {
        LockRequest currentLocked;
        if (log.isTraceEnabled()) {
            log.tracef("Release lock for %s. It was canceled.", canceled.getRequestor());
        }
        if ((currentLocked = this.current) == canceled) {
            this.tryAcquire(canceled);
        }
    }

    private boolean casRelease(LockRequest lockPlaceHolder) {
        return this.cas(lockPlaceHolder, null);
    }

    private boolean remove(Object lockOwner) {
        return this.lockOwners.remove(lockOwner) != null;
    }

    private void triggerReleased() {
        if (this.releaseRunnable != null) {
            this.releaseRunnable.run();
        }
    }

    private boolean cas(LockRequest release, LockRequest acquire) {
        boolean cas = OWNER_UPDATER.compareAndSet(this, release, acquire);
        if (log.isTraceEnabled()) {
            log.tracef("Lock Owner CAS(%s, %s) => %s", release, acquire, cas);
        }
        return cas;
    }

    private void tryAcquire(LockRequest release) {
        LockRequest toRelease = release;
        while (true) {
            LockRequest toAcquire = this.peekNextPendingRequest();
            if (log.isTraceEnabled()) {
                log.tracef("Try acquire. Next in queue=%s. Current=%s", toAcquire, this.current);
            }
            if (toAcquire == null && toRelease == null) {
                return;
            }
            if (toAcquire == null) {
                if (this.casRelease(toRelease)) {
                    toRelease = null;
                    continue;
                }
                return;
            }
            if (!this.cas(toRelease, toAcquire)) break;
            this.removeFromPendingRequest(toAcquire);
            if (toAcquire.setAcquire()) {
                if (log.isTraceEnabled()) {
                    log.tracef("%s successfully acquired the lock.", toAcquire);
                }
                return;
            }
            if (log.isTraceEnabled()) {
                log.tracef("%s failed to acquire (invalid state). Retrying.", toAcquire);
            }
            toRelease = toAcquire;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Unable to acquire. Lock is held.", new Object[0]);
        }
    }

    private LockRequest createLockInfo(Object lockOwner, long time, TimeUnit timeUnit) {
        return new LockPlaceHolder(lockOwner, this.timeService.expectedEndTime(time, timeUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPendingRequests(LockRequest request) {
        if (this.pendingRequest == null) {
            InfinispanLock infinispanLock = this;
            synchronized (infinispanLock) {
                if (this.pendingRequest == null) {
                    this.pendingRequest = new ConcurrentLinkedQueue<LockRequest>();
                }
            }
        }
        this.pendingRequest.add(request);
    }

    private LockRequest peekNextPendingRequest() {
        if (this.pendingRequest == null) {
            return null;
        }
        return this.pendingRequest.peek();
    }

    private void removeFromPendingRequest(LockRequest request) {
        assert (this.pendingRequest != null);
        this.pendingRequest.remove(request);
    }

    private void forEachPendingRequest(Consumer<LockRequest> consumer) {
        if (this.pendingRequest == null) {
            return;
        }
        this.pendingRequest.forEach(consumer);
    }

    private static void checkValidCancelState(LockState state) {
        if (state != LockState.TIMED_OUT && state != LockState.DEADLOCKED) {
            throw new IllegalArgumentException("LockState " + String.valueOf((Object)state) + " is not valid to cancel.");
        }
    }

    private abstract class LockRequest
    implements ExtendedLockPromise {
        final Object owner;

        LockRequest(Object owner) {
            this.owner = owner;
        }

        abstract boolean setAcquire();

        abstract void checkDeadlock(DeadlockChecker var1, LockRequest var2);

        abstract boolean setReleased();

        @Override
        public final Object getRequestor() {
            return this.owner;
        }

        @Override
        public final Object getOwner() {
            return InfinispanLock.this.getLockOwner();
        }
    }

    private class LockAcquired
    extends LockRequest {
        private volatile boolean released;

        LockAcquired(Object owner) {
            super(owner);
        }

        @Override
        public void cancel(LockState cause) {
            InfinispanLock.checkValidCancelState(cause);
        }

        @Override
        public InvocationStage toInvocationStage(Supplier<TimeoutException> timeoutSupplier) {
            return this.toInvocationStage();
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public void lock() {
        }

        @Override
        public void addListener(LockListener listener) {
            listener.onEvent(this.released ? LockState.RELEASED : LockState.ACQUIRED);
        }

        @Override
        public InvocationStage toInvocationStage() {
            return InvocationStage.completedNullStage();
        }

        @Override
        public boolean setAcquire() {
            throw new IllegalStateException("setAcquire() should never be invoked");
        }

        @Override
        public void checkDeadlock(DeadlockChecker deadlockChecker, LockRequest holder) {
            throw new IllegalStateException("checkDeadlock() should never be invoked");
        }

        @Override
        public boolean setReleased() {
            this.released = true;
            if (InfinispanLock.this.remove(this.owner)) {
                if (log.isTraceEnabled()) {
                    log.tracef("State changed for %s. ACQUIRED => RELEASED", this);
                }
                InfinispanLock.this.triggerReleased();
                return true;
            }
            return false;
        }

        public String toString() {
            return "LockAcquired{released?=" + this.released + ", owner=" + String.valueOf(this.owner) + "}";
        }
    }

    private class LockPlaceHolder
    extends LockRequest {
        private final long timeout;
        private final CompletableFuture<LockState> notifier;
        volatile LockState lockState;

        private LockPlaceHolder(Object owner, long timeout) {
            super(owner);
            this.timeout = timeout;
            this.lockState = LockState.WAITING;
            this.notifier = new CompletableFuture();
        }

        @Override
        public boolean isAvailable() {
            this.checkTimeout();
            return this.lockState != LockState.WAITING;
        }

        @Override
        public void lock() throws InterruptedException, TimeoutException {
            LockState currentState;
            block7: while (true) {
                currentState = this.lockState;
                switch (currentState) {
                    case WAITING: {
                        this.checkTimeout();
                        CompletableFutures.await(this.notifier, (long)InfinispanLock.this.timeService.remainingTime(this.timeout, TimeUnit.NANOSECONDS), (TimeUnit)TimeUnit.NANOSECONDS);
                        continue block7;
                    }
                    case ACQUIRED: {
                        return;
                    }
                    case RELEASED: {
                        throw new LockReleasedException("Requestor '" + String.valueOf(this.owner) + "' failed to acquire lock. Lock already released!");
                    }
                    case TIMED_OUT: {
                        this.cleanup();
                        throw new TimeoutException("Timeout waiting for lock.");
                    }
                    case DEADLOCKED: {
                        this.cleanup();
                        throw new DeadlockDetectedException("DeadLock detected");
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown lock state: " + String.valueOf((Object)currentState));
        }

        @Override
        public void addListener(LockListener listener) {
            if (this.notifier.isDone() && !this.notifier.isCompletedExceptionally()) {
                listener.onEvent(this.notifier.join());
            } else {
                this.notifier.thenAccept(listener::onEvent);
            }
        }

        @Override
        public InvocationStage toInvocationStage() {
            return this.toInvocationStage(() -> new TimeoutException("Timeout waiting for lock."));
        }

        @Override
        public void cancel(LockState state) {
            LockState currentState;
            InfinispanLock.checkValidCancelState(state);
            block4: while (true) {
                currentState = this.lockState;
                switch (currentState) {
                    case WAITING: {
                        if (!this.casState(LockState.WAITING, state)) continue block4;
                        InfinispanLock.this.onCanceled(this);
                        this.notifyListeners();
                        return;
                    }
                    case ACQUIRED: 
                    case RELEASED: 
                    case TIMED_OUT: 
                    case DEADLOCKED: {
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown lock state " + String.valueOf((Object)currentState));
        }

        @Override
        public InvocationStage toInvocationStage(Supplier<TimeoutException> timeoutSupplier) {
            if (this.notifier.isDone()) {
                return this.checkState(this.notifier.getNow(this.lockState), InvocationStage::completedNullStage, ExceptionSyncInvocationStage::new, timeoutSupplier);
            }
            return new SimpleAsyncInvocationStage(this.notifier.thenApplyAsync(state -> {
                Throwable rv = this.checkState((LockState)((Object)state), () -> null, throwable -> throwable, timeoutSupplier);
                if (rv != null) {
                    throw (RuntimeException)rv;
                }
                return null;
            }, InfinispanLock.this.nonBlockingExecutor));
        }

        public String toString() {
            return "LockPlaceHolder{lockState=" + String.valueOf((Object)this.lockState) + ", owner=" + String.valueOf(this.owner) + "}";
        }

        @Override
        public void checkDeadlock(DeadlockChecker checker, LockRequest holder) {
            this.checkTimeout();
            Object currentOwner = holder.owner;
            if (this.lockState == LockState.WAITING && !this.owner.equals(currentOwner) && checker.deadlockDetected(this.owner, currentOwner) && this.casState(LockState.WAITING, LockState.DEADLOCKED)) {
                InfinispanLock.this.onCanceled(this);
                this.notifyListeners();
            }
        }

        @Override
        public boolean setAcquire() {
            if (this.casState(LockState.WAITING, LockState.ACQUIRED)) {
                this.notifyListeners();
            }
            return this.lockState == LockState.ACQUIRED;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean setReleased() {
            block5: while (true) lbl-1000:
            // 3 sources

            {
                state = this.lockState;
                switch (1.$SwitchMap$org$infinispan$util$concurrent$locks$LockState[state.ordinal()]) {
                    case 1: {
                        if (!this.casState(state, LockState.RELEASED)) ** GOTO lbl-1000
                        this.cleanup();
                        this.notifyListeners();
                        return true;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        if (!this.casState(state, LockState.RELEASED)) continue block5;
                        this.cleanup();
                        return true;
                    }
                    case 3: {
                        return false;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown lock state " + String.valueOf((Object)state));
        }

        private <T> T checkState(LockState state, Supplier<T> acquired, Function<Throwable, T> exception, Supplier<TimeoutException> timeoutSupplier) {
            switch (state) {
                case ACQUIRED: {
                    return acquired.get();
                }
                case RELEASED: {
                    return exception.apply((Throwable)((Object)new LockReleasedException("Requestor '" + String.valueOf(this.owner) + "' failed to acquire lock. Lock already released!")));
                }
                case TIMED_OUT: {
                    this.cleanup();
                    return exception.apply((Throwable)timeoutSupplier.get());
                }
                case DEADLOCKED: {
                    this.cleanup();
                    return exception.apply((Throwable)((Object)new DeadlockDetectedException("DeadLock detected")));
                }
            }
            return exception.apply(new IllegalStateException("Unknown lock state: " + String.valueOf((Object)state)));
        }

        private boolean casState(LockState expect, LockState update) {
            boolean updated = STATE_UPDATER.compareAndSet(this, expect, update);
            if (updated && log.isTraceEnabled()) {
                log.tracef("State changed for %s. %s => %s", this, (Object)expect, (Object)update);
            }
            return updated;
        }

        private void cleanup() {
            if (InfinispanLock.this.remove(this.owner)) {
                InfinispanLock.this.triggerReleased();
            }
        }

        private void checkTimeout() {
            if (this.lockState == LockState.WAITING && InfinispanLock.this.timeService.isTimeExpired(this.timeout) && this.casState(LockState.WAITING, LockState.TIMED_OUT)) {
                InfinispanLock.this.onCanceled(this);
                this.notifyListeners();
            }
        }

        private void notifyListeners() {
            LockState state = this.lockState;
            if (state != LockState.WAITING) {
                this.notifier.complete(state);
            }
        }
    }
}

