/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CommonAbstractCriteria;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.PluralJoin;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaCrossJoin;
import org.hibernate.query.criteria.JpaCteContainer;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedCrossJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedEntityJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedListJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedSingularJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmSubQuery<T>
extends AbstractSqmSelectQuery<T>
implements SqmSelectQuery<T>,
JpaSubQuery<T>,
SqmExpression<T> {
    private final SqmQuery<?> parent;
    private SqmExpressible<T> expressibleType;
    private String alias;

    public SqmSubQuery(SqmQuery<?> parent, SqmQueryPart<T> queryPart, Class<T> resultType, NodeBuilder builder) {
        super(queryPart, resultType, builder);
        this.parent = parent;
        this.applyInferableType(resultType);
    }

    public SqmSubQuery(SqmQuery<?> parent, SqmQueryPart<T> queryPart, Class<T> resultType, Map<String, SqmCteStatement<?>> cteStatements, NodeBuilder builder) {
        super(builder, cteStatements, resultType);
        this.parent = parent;
        this.setQueryPart(queryPart);
        this.applyInferableType(resultType);
    }

    public SqmSubQuery(SqmQuery<?> parent, Class<T> resultType, NodeBuilder builder) {
        super(resultType, builder);
        this.parent = parent;
        this.applyInferableType(resultType);
    }

    public SqmSubQuery(SqmQuery<?> parent, NodeBuilder builder) {
        super(null, builder);
        this.parent = parent;
    }

    private SqmSubQuery(NodeBuilder builder, Map<String, SqmCteStatement<?>> cteStatements, Class<T> resultType, SqmQuery<?> parent, SqmExpressible<T> expressibleType, String alias) {
        super(builder, cteStatements, resultType);
        this.parent = parent;
        this.expressibleType = expressibleType;
        this.alias = alias;
    }

    @Override
    public SqmSubQuery<T> copy(SqmCopyContext context) {
        SqmSubQuery existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmSubQuery statement = context.registerCopy(this, new SqmSubQuery(this.nodeBuilder(), this.copyCteStatements(context), this.getResultType(), (SqmQuery<?>)this.parent.copy(context), this.getExpressible(), this.getAlias()));
        statement.setQueryPart(((SqmQueryPart)this.getQueryPart()).copy(context));
        return statement;
    }

    @Override
    public Integer getTupleLength() {
        SqmSelectClause selectClause = ((SqmQuerySpec)this.getQuerySpec()).getSelectClause();
        return selectClause != null ? Integer.valueOf(this.getTupleLength(selectClause.getSelectionItems())) : null;
    }

    private int getTupleLength(List<SqmSelectableNode<?>> selectionItems) {
        int count = 0;
        for (SqmSelectableNode<?> selection : selectionItems) {
            count += selection.getTupleLength().intValue();
        }
        return count;
    }

    @Override
    public SqmCteStatement<?> getCteStatement(String cteLabel) {
        SqmCteStatement<?> cteCriteria = super.getCteStatement(cteLabel);
        if (cteCriteria != null || !(this.parent instanceof SqmCteContainer)) {
            return cteCriteria;
        }
        return ((SqmCteContainer)((Object)this.parent)).getCteStatement(cteLabel);
    }

    @Override
    public <X> JpaCteCriteria<X> getCteCriteria(String cteName) {
        JpaCteCriteria cteCriteria = super.getCteCriteria(cteName);
        if (cteCriteria != null || !(this.parent instanceof JpaCteContainer)) {
            return cteCriteria;
        }
        return ((JpaCteContainer)((Object)this.parent)).getCteCriteria(cteName);
    }

    public SqmQuery<?> getContainingQuery() {
        return this.parent;
    }

    public SqmSelectQuery<?> getParent() {
        CommonAbstractCriteria containingQuery = this.getContainingQuery();
        if (!(containingQuery instanceof AbstractQuery)) {
            throw new IllegalStateException("Cannot call getParent on update/delete criterias");
        }
        return (SqmSelectQuery)containingQuery;
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public SqmSubQuery<T> alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public SqmSubQuery<T> select(Expression<T> expression) {
        JpaQueryStructure querySpec = this.getQuerySpec();
        if (((SqmQuerySpec)querySpec).getSelectClause() == null) {
            ((SqmQuerySpec)querySpec).setSelectClause(new SqmSelectClause(false, 1, this.nodeBuilder()));
        }
        ((SqmQuerySpec)querySpec).setSelection((JpaSelection)expression);
        return this;
    }

    @Override
    public SqmSubQuery<T> multiselect(Selection<?> ... selections) {
        this.validateComplianceMultiselect();
        Selection resultSelection = this.getResultSelection(selections);
        JpaQueryStructure querySpec = this.getQuerySpec();
        if (((SqmQuerySpec)querySpec).getSelectClause() == null) {
            ((SqmQuerySpec)querySpec).setSelectClause(new SqmSelectClause(false, 1, this.nodeBuilder()));
        }
        ((SqmQuerySpec)querySpec).setSelection((JpaSelection)resultSelection);
        return this;
    }

    @Override
    public SqmSubQuery<T> multiselect(List<Selection<?>> selectionList) {
        Selection<?> resultSelection;
        this.validateComplianceMultiselect();
        Class resultType = this.getResultType();
        List<Selection<?>> selections = selectionList;
        if (resultType == null || resultType == Object.class) {
            switch (selections.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty selections passed to criteria query typed as Object");
                }
                case 1: {
                    resultSelection = selections.get(0);
                    break;
                }
                default: {
                    resultSelection = this.nodeBuilder().array(selections);
                    break;
                }
            }
        } else {
            resultSelection = Tuple.class.isAssignableFrom(resultType) ? this.nodeBuilder().tuple(selections) : (resultType.isArray() ? this.nodeBuilder().array(resultType, selections) : this.nodeBuilder().construct(resultType, selections));
        }
        JpaQueryStructure querySpec = this.getQuerySpec();
        if (((SqmQuerySpec)querySpec).getSelectClause() == null) {
            ((SqmQuerySpec)querySpec).setSelectClause(new SqmSelectClause(false, 1, this.nodeBuilder()));
        }
        ((SqmQuerySpec)querySpec).setSelection((JpaSelection)resultSelection);
        return this;
    }

    @Override
    public SqmExpression<T> getSelection() {
        SqmSelectClause selectClause = ((SqmQuerySpec)this.getQuerySpec()).getSelectClause();
        if (selectClause == null) {
            return null;
        }
        return this;
    }

    public boolean isCompoundSelection() {
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection().isCompoundSelection();
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return null;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        if (!this.isCompoundSelection()) {
            throw new IllegalStateException("JPA selection is not compound");
        }
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection().getCompoundSelectionItems();
    }

    @Override
    public SqmSubQuery<T> distinct(boolean distinct) {
        return (SqmSubQuery)super.distinct(distinct);
    }

    @Override
    public SqmSubQuery<T> where(Expression<Boolean> restriction) {
        return (SqmSubQuery)super.where((Expression)restriction);
    }

    @Override
    public SqmSubQuery<T> where(Predicate ... restrictions) {
        return (SqmSubQuery)super.where(restrictions);
    }

    @Override
    public SqmSubQuery<T> groupBy(Expression<?> ... expressions) {
        return (SqmSubQuery)super.groupBy((Expression[])expressions);
    }

    @Override
    public SqmSubQuery<T> groupBy(List<Expression<?>> grouping) {
        return (SqmSubQuery)super.groupBy((List)grouping);
    }

    @Override
    public SqmSubQuery<T> having(Expression<Boolean> booleanExpression) {
        return (SqmSubQuery)super.having((Expression)booleanExpression);
    }

    @Override
    public SqmSubQuery<T> having(Predicate ... predicates) {
        return (SqmSubQuery)super.having(predicates);
    }

    @Override
    public JpaExpression<Number> getOffset() {
        return ((SqmQueryPart)this.getQueryPart()).getOffset();
    }

    @Override
    public JpaSubQuery<T> offset(JpaExpression<? extends Number> offset) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setOffset((JpaExpression)offset);
        return this;
    }

    @Override
    public JpaSubQuery<T> offset(Number offset) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setOffset(this.nodeBuilder().value(offset));
        return this;
    }

    @Override
    public JpaExpression<Number> getFetch() {
        return ((SqmQueryPart)this.getQueryPart()).getFetch();
    }

    @Override
    public JpaSubQuery<T> fetch(JpaExpression<? extends Number> fetch) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch((JpaExpression)fetch);
        return this;
    }

    @Override
    public JpaSubQuery<T> fetch(JpaExpression<? extends Number> fetch, FetchClauseType fetchClauseType) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(fetch, fetchClauseType);
        return this;
    }

    @Override
    public JpaSubQuery<T> fetch(Number fetch) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch));
        return this;
    }

    @Override
    public JpaSubQuery<T> fetch(Number fetch, FetchClauseType fetchClauseType) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch), fetchClauseType);
        return this;
    }

    @Override
    public FetchClauseType getFetchClauseType() {
        return ((SqmQueryPart)this.getQueryPart()).getFetchClauseType();
    }

    @Override
    public List<JpaOrder> getOrderList() {
        return ((SqmQueryPart)this.getQueryPart()).getSortSpecifications();
    }

    @Override
    public JpaSubQuery<T> orderBy(Order ... orders) {
        this.validateComplianceOrderBy();
        SqmOrderByClause sqmOrderByClause = new SqmOrderByClause(orders.length);
        for (Order order : orders) {
            sqmOrderByClause.addSortSpecification((SqmSortSpecification)order);
        }
        ((SqmQueryPart)this.getQueryPart()).setOrderByClause(sqmOrderByClause);
        return this;
    }

    @Override
    public JpaSubQuery<T> orderBy(List<Order> orders) {
        this.validateComplianceOrderBy();
        SqmOrderByClause sqmOrderByClause = new SqmOrderByClause(orders.size());
        for (Order order : orders) {
            sqmOrderByClause.addSortSpecification((SqmSortSpecification)order);
        }
        ((SqmQueryPart)this.getQueryPart()).setOrderByClause(sqmOrderByClause);
        return this;
    }

    private void validateComplianceMultiselect() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support subqueries having multiple select items. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    private void validateComplianceOrderBy() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support subqueries having an order by clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    private void validateComplianceFetchOffset() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support subqueries having a fetch or offset clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    @Override
    public <Y> SqmRoot<Y> correlate(Root<Y> parentRoot) {
        SqmCorrelation correlated = ((SqmRoot)parentRoot).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((Object)correlated));
        return correlated;
    }

    @Override
    public <X, Y> SqmAttributeJoin<X, Y> correlate(Join<X, Y> join) {
        if (join instanceof PluralJoin) {
            PluralJoin pluralJoin = (PluralJoin)join;
            switch (pluralJoin.getModel().getCollectionType()) {
                case COLLECTION: {
                    return this.correlate((CollectionJoin)join);
                }
                case LIST: {
                    return this.correlate((ListJoin)join);
                }
                case SET: {
                    return this.correlate((SetJoin)join);
                }
                case MAP: {
                    return this.correlate((MapJoin)join);
                }
            }
        }
        SqmCorrelation correlated = ((SqmSingularJoin)join).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedSingularJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X, Y> SqmBagJoin<X, Y> correlate(CollectionJoin<X, Y> parentCollection) {
        SqmCorrelation correlated = ((SqmBagJoin)parentCollection).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedBagJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X, Y> SqmSetJoin<X, Y> correlate(SetJoin<X, Y> parentSet) {
        SqmCorrelation correlated = ((SqmSetJoin)parentSet).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedSetJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X, Y> SqmListJoin<X, Y> correlate(ListJoin<X, Y> parentList) {
        SqmCorrelation correlated = ((SqmListJoin)parentList).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedListJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X, K, V> SqmMapJoin<X, K, V> correlate(MapJoin<X, K, V> parentMap) {
        SqmCorrelation correlated = ((SqmMapJoin)parentMap).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedMapJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X> SqmCrossJoin<X> correlate(JpaCrossJoin<X> parentCrossJoin) {
        SqmCorrelation correlated = ((SqmCrossJoin)parentCrossJoin).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedCrossJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    @Override
    public <X> SqmEntityJoin<X> correlate(JpaEntityJoin<X> parentEntityJoin) {
        SqmCorrelation correlated = ((SqmEntityJoin)parentEntityJoin).createCorrelation();
        ((SqmQuerySpec)this.getQuerySpec()).addRoot((JpaRoot)((SqmCorrelatedEntityJoin)correlated).getCorrelatedRoot());
        return correlated;
    }

    public Set<Join<?, ?>> getCorrelatedJoins() {
        HashSet correlatedJoins = new HashSet();
        SqmFromClause fromClause = ((SqmQuerySpec)this.getQuerySpec()).getFromClause();
        if (fromClause == null) {
            return correlatedJoins;
        }
        for (SqmRoot<?> root : fromClause.getRoots()) {
            if (!(root instanceof SqmCorrelation)) continue;
            for (SqmJoin sqmJoin : root.getSqmJoins()) {
                if (!(sqmJoin instanceof SqmCorrelation) || !(sqmJoin instanceof Join)) continue;
                correlatedJoins.add((Join)sqmJoin);
            }
        }
        return correlatedJoins;
    }

    @Override
    public SqmPredicate isNull() {
        return this.nodeBuilder().isNull(this);
    }

    @Override
    public SqmPredicate isNotNull() {
        return this.nodeBuilder().isNotNull(this);
    }

    @Override
    public SqmPredicate equalTo(Expression<T> that) {
        return this.nodeBuilder().equal((Expression)this, (Expression)that);
    }

    @Override
    public SqmPredicate equalTo(T that) {
        return this.nodeBuilder().equal((Expression)this, (Object)that);
    }

    @Override
    public SqmInPredicate<?> in(Object ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmInPredicate<?> in(Expression<?> ... values) {
        return this.nodeBuilder().in((Expression)this, (Expression[])values);
    }

    @Override
    public SqmInPredicate<?> in(Collection<?> values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmInPredicate<?> in(Expression<Collection<?>> values) {
        return this.nodeBuilder().in((Expression)this, new Expression[]{values});
    }

    @Override
    public @Nullable SqmExpressible<T> getNodeType() {
        return this.expressibleType;
    }

    @Override
    public void applyInferableType(@Nullable SqmExpressible<?> type) {
        this.expressibleType = type;
    }

    @Override
    private void applyInferableType(Class<T> type) {
        if (type != null) {
            EntityDomainType<T> entityDescriptor = this.nodeBuilder().getDomainModel().findEntityType(type);
            this.expressibleType = entityDescriptor != null ? entityDescriptor : this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(type);
        }
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(Long.class));
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(Integer.class));
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(Float.class));
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(Double.class));
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(BigDecimal.class));
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(BigInteger.class));
    }

    @Override
    public SqmExpression<String> asString() {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(String.class));
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)type);
    }

    @Override
    public JavaType<T> getJavaTypeDescriptor() {
        if (this.getNodeType() == null) {
            return null;
        }
        return this.getNodeType().getExpressibleJavaType();
    }

    @Override
    public Class<? extends T> getJavaType() {
        return this.getResultType();
    }

    public <U> SqmSubQuery<U> subquery(Class<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    @Override
    public String asLoggableText() {
        return "<sub-query>";
    }

    public <T1> T1 accept(SemanticQueryWalker<T1> walker) {
        return walker.visitSubQueryExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append('(');
        super.appendHqlString(sb);
        sb.append(')');
    }
}

