/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.annotations.QuarkusMain;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.DryRunMixin;
import org.keycloak.quarkus.runtime.cli.command.Start;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;

@QuarkusMain(name="keycloak")
@ApplicationScoped
public class KeycloakMain
implements QuarkusApplication {
    private static final String INFINISPAN_VIRTUAL_THREADS_PROP = "org.infinispan.threads.virtual";

    public static void main(String[] args) {
        KeycloakMain.ensureForkJoinPoolThreadFactoryHasBeenSetToQuarkus();
        System.setProperty("kc.version", Version.VERSION);
        KeycloakMain.main(args, new Picocli());
    }

    public static void main(String[] args, Picocli picocli) {
        List<String> cliArgs = null;
        try {
            cliArgs = Picocli.parseArgs(args);
        }
        catch (PropertyException e) {
            picocli.usageException(e.getMessage(), e.getCause());
            return;
        }
        if (DryRunMixin.isDryRunBuild() && (cliArgs.contains("--dry-run") || Boolean.valueOf(System.getenv().get("KC_DRY_RUN")).booleanValue())) {
            PersistedConfigSource.getInstance().useDryRunProperties();
        }
        if (cliArgs.isEmpty()) {
            cliArgs = new ArrayList<String>(cliArgs);
            cliArgs.add("-h");
        } else if (KeycloakMain.isFastStart(cliArgs)) {
            Start.fastStart(picocli, Boolean.valueOf(System.getenv().get("KC_DRY_RUN")));
            return;
        }
        picocli.parseAndRun(cliArgs);
    }

    private static void ensureForkJoinPoolThreadFactoryHasBeenSetToQuarkus() {
        String FORK_JOIN_POOL_COMMON_THREAD_FACTORY = "java.util.concurrent.ForkJoinPool.common.threadFactory";
        String sf = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
        if (!ForkJoinPool.commonPool().getFactory().getClass().getName().equals(sf)) {
            Logger.getLogger(KeycloakMain.class).errorf("The ForkJoinPool has been initialized with the wrong thread factory. The property '%s' should be set on the Java CLI to ensure Java's ForkJoinPool will always be initialized with '%s' even if there are Java agents which might initialize logging or other capabilities earlier than the main method.", (Object)"java.util.concurrent.ForkJoinPool.common.threadFactory", (Object)sf);
            throw new RuntimeException("The ForkJoinPool has been initialized with the wrong thread factory");
        }
    }

    private static boolean isFastStart(List<String> cliArgs) {
        return cliArgs.size() == 2 && cliArgs.get(0).equals("start") && cliArgs.stream().anyMatch("--optimized"::equals);
    }

    public static void start(ExecutionExceptionHandler errorHandler, PrintWriter errStream) {
        try {
            Quarkus.run(KeycloakMain.class, (exitCode, cause) -> {
                if (cause != null) {
                    errorHandler.error(errStream, String.format("Failed to start server in (%s) mode", Environment.getKeycloakModeFromProfile(org.keycloak.common.util.Environment.getProfile())), cause.getCause());
                }
                if (Environment.isDistribution()) {
                    System.exit(exitCode);
                }
            }, (String[])new String[0]);
        }
        catch (Throwable cause2) {
            errorHandler.error(errStream, String.format("Unexpected error when starting the server in (%s) mode", Environment.getKeycloakModeFromProfile(org.keycloak.common.util.Environment.getProfile())), cause2.getCause());
            System.exit(1);
        }
    }

    public int run(String ... args) throws Exception {
        int exitCode = ApplicationLifecycleManager.getExitCode();
        if (Environment.isTestLaunchMode() || Environment.isNonServerMode()) {
            Quarkus.asyncExit((int)exitCode);
        } else {
            Quarkus.waitForExit();
        }
        return exitCode;
    }

    static {
        if (System.getProperty(INFINISPAN_VIRTUAL_THREADS_PROP) == null) {
            System.setProperty(INFINISPAN_VIRTUAL_THREADS_PROP, "true");
        }
    }
}

