/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.Version;
import org.keycloak.common.util.MimeTypeUtil;
import org.keycloak.encoding.ResourceEncodingHelper;
import org.keycloak.encoding.ResourceEncodingProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.resources.KeySource;
import org.keycloak.services.resources.Source;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.LocaleUtil;
import org.keycloak.theme.Theme;

@Provider
@Path(value="/resources")
public class ThemeResource {
    @Context
    KeycloakSession session;

    @GET
    @Path(value="/{version}/{themeType}/{themeName}/{path:.*}")
    public Response getResource(@PathParam(value="version") String version, @PathParam(value="themeType") String themeType, @PathParam(value="themeName") String themeName, @PathParam(value="path") String path) {
        Optional<Theme.Type> type = ThemeResource.getThemeType(themeType);
        if (!version.equals(Version.RESOURCES_VERSION) || type.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            String contentType = MimeTypeUtil.getContentType((String)path);
            Theme theme = this.session.theme().getTheme(themeName, type.get());
            ResourceEncodingProvider encodingProvider = this.session.theme().isCacheEnabled() ? ResourceEncodingHelper.getResourceEncodingProvider((KeycloakSession)this.session, (String)contentType) : null;
            InputStream resource = encodingProvider != null ? encodingProvider.getEncodedStream(() -> theme.getResourceAsStream(path), new String[]{themeType, themeName, path.replace('/', File.separatorChar)}) : theme.getResourceAsStream(path);
            if (resource != null) {
                Response.ResponseBuilder rb = Response.ok((Object)resource).type(contentType).cacheControl(CacheControlUtil.getDefaultCacheControl());
                if (encodingProvider != null) {
                    rb.encoding(encodingProvider.getEncoding());
                }
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToGetThemeRequest(e);
            return Response.serverError().build();
        }
    }

    @Path(value="/{realm}/{themeType}/{locale}")
    @OPTIONS
    public Response localizationTextPreflight() {
        return Cors.builder().auth().preflight().add(Response.ok());
    }

    @GET
    @Path(value="/{realm}/{themeType}/{locale}")
    @Produces(value={"application/json"})
    public Response getLocalizationTexts(@PathParam(value="realm") String realmName, @QueryParam(value="theme") String theme, @PathParam(value="locale") String localeString, @PathParam(value="themeType") String themeType, @QueryParam(value="source") boolean showSource) throws IOException {
        List result;
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        Optional<Theme.Type> type = ThemeResource.getThemeType(themeType);
        if (realm == null || type.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.session.getContext().setRealm(realm);
        Theme theTheme = theme == null ? this.session.theme().getTheme(type.get()) : this.session.theme().getTheme(theme, type.get());
        Locale locale = Locale.forLanguageTag(localeString);
        if (showSource) {
            Properties messagesByLocale = theTheme.getMessages("messages", locale);
            Set resultSet = messagesByLocale.entrySet().stream().map(e -> new KeySource((String)e.getKey(), (String)e.getValue(), Source.THEME)).collect(Collectors.toSet());
            Map realmLocalizationMessages = LocaleUtil.getRealmLocalizationTexts((RealmModel)realm, (Locale)locale);
            Locale currentLocale = locale;
            while (currentLocale != null) {
                List realmOverride = ((Properties)realmLocalizationMessages.get(currentLocale)).entrySet().stream().map(e -> new KeySource((String)e.getKey(), (String)e.getValue(), Source.REALM)).collect(Collectors.toList());
                resultSet.addAll(realmOverride);
                currentLocale = LocaleUtil.getParentLocale((Locale)currentLocale);
            }
            result = new ArrayList(resultSet);
        } else {
            result = theTheme.getEnhancedMessages(realm, locale).entrySet().stream().map(e -> new KeySource((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
        return Cors.builder().allowedOrigins(new String[]{"*"}).auth().add(Response.ok(result));
    }

    private static Optional<Theme.Type> getThemeType(String themeType) {
        try {
            return Optional.of(Theme.Type.valueOf((String)themeType.toUpperCase()));
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
    }
}

