/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.http.WebSocketBase;
import io.vertx.mutiny.core.http.WebSocketFrame;
import io.vertx.mutiny.core.net.HostAndPort;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

@MutinyGen(value=io.vertx.core.http.ServerWebSocket.class)
public class ServerWebSocket
implements WebSocketBase {
    public static final TypeArg<ServerWebSocket> __TYPE_ARG = new TypeArg(obj -> new ServerWebSocket((io.vertx.core.http.ServerWebSocket)obj), ServerWebSocket::getDelegate);
    private final io.vertx.core.http.ServerWebSocket delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;
    private Multi<Buffer> multi;

    public ServerWebSocket(io.vertx.core.http.ServerWebSocket delegate) {
        this.delegate = delegate;
    }

    public ServerWebSocket(Object delegate) {
        this.delegate = (io.vertx.core.http.ServerWebSocket)delegate;
    }

    ServerWebSocket() {
        this.delegate = null;
    }

    public io.vertx.core.http.ServerWebSocket getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerWebSocket that = (ServerWebSocket)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber((WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> write(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.write((Object)data.getDelegate(), handler));
    }

    @Override
    public Void writeAndAwait(Buffer data) {
        return (Void)this.write(data).await().indefinitely();
    }

    @Override
    public void writeAndForget(Buffer data) {
        this.write(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.end((Object)data.getDelegate(), handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return (Void)this.end(data).await().indefinitely();
    }

    @Override
    public void endAndForget(Buffer data) {
        this.end(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Fluent
    private WebSocketBase __textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase textMessageHandler(Consumer<String> handler) {
        return this.__textMessageHandler((Handler<String>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private WebSocketBase __binaryMessageHandler(Handler<Buffer> handler) {
        this.delegate.binaryMessageHandler((Handler)new DelegatingHandler(handler, event -> Buffer.newInstance(event)));
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(Consumer<Buffer> handler) {
        return this.__binaryMessageHandler((Handler<Buffer>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private WebSocketBase __pongHandler(Handler<Buffer> handler) {
        this.delegate.pongHandler((Handler)new DelegatingHandler(handler, event -> Buffer.newInstance(event)));
        return this;
    }

    @Override
    public WebSocketBase pongHandler(Consumer<Buffer> handler) {
        return this.__pongHandler((Handler<Buffer>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end(handler));
    }

    @Override
    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    @Override
    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    @Override
    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    @Override
    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> close(short statusCode) {
        return AsyncResultUni.toUni(handler -> this.delegate.close(statusCode, handler));
    }

    @Override
    public Void closeAndAwait(short statusCode) {
        return (Void)this.close(statusCode).await().indefinitely();
    }

    @Override
    public void closeAndForget(short statusCode) {
        this.close(statusCode).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> close(short statusCode, String reason) {
        return AsyncResultUni.toUni(handler -> this.delegate.close(statusCode, reason, handler));
    }

    @Override
    public Void closeAndAwait(short statusCode, String reason) {
        return (Void)this.close(statusCode, reason).await().indefinitely();
    }

    @Override
    public void closeAndForget(short statusCode, String reason) {
        this.close(statusCode, reason).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    @Fluent
    private ServerWebSocket __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public ServerWebSocket exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private ServerWebSocket __handler(Handler<Buffer> handler) {
        this.delegate.handler((Handler)new DelegatingHandler(handler, event -> Buffer.newInstance(event)));
        return this;
    }

    @Override
    public ServerWebSocket handler(Consumer<Buffer> handler) {
        return this.__handler((Handler<Buffer>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Override
    @Fluent
    public ServerWebSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    @Fluent
    public ServerWebSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    @Fluent
    public ServerWebSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Fluent
    private ServerWebSocket __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public ServerWebSocket endHandler(Runnable endHandler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> endHandler.run()));
    }

    @Override
    @Fluent
    public ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Fluent
    private ServerWebSocket __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public ServerWebSocket drainHandler(Runnable handler) {
        return this.__drainHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeFrame(WebSocketFrame frame) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeFrame(frame.getDelegate(), handler));
    }

    @Override
    public Void writeFrameAndAwait(WebSocketFrame frame) {
        return (Void)this.writeFrame(frame).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeFrameAndForget(WebSocketFrame frame) {
        this.writeFrame(frame).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeFinalTextFrame(String text) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeFinalTextFrame(text, handler));
    }

    @Override
    public Void writeFinalTextFrameAndAwait(String text) {
        return (Void)this.writeFinalTextFrame(text).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeFinalTextFrameAndForget(String text) {
        this.writeFinalTextFrame(text).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeFinalBinaryFrame(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeFinalBinaryFrame(data.getDelegate(), handler));
    }

    @Override
    public Void writeFinalBinaryFrameAndAwait(Buffer data) {
        return (Void)this.writeFinalBinaryFrame(data).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeFinalBinaryFrameAndForget(Buffer data) {
        this.writeFinalBinaryFrame(data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeBinaryMessage(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeBinaryMessage(data.getDelegate(), handler));
    }

    @Override
    public Void writeBinaryMessageAndAwait(Buffer data) {
        return (Void)this.writeBinaryMessage(data).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeBinaryMessageAndForget(Buffer data) {
        this.writeBinaryMessage(data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeTextMessage(String text) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeTextMessage(text, handler));
    }

    @Override
    public Void writeTextMessageAndAwait(String text) {
        return (Void)this.writeTextMessage(text).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeTextMessageAndForget(String text) {
        this.writeTextMessage(text).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writePing(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.writePing(data.getDelegate(), handler));
    }

    @Override
    public Void writePingAndAwait(Buffer data) {
        return (Void)this.writePing(data).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writePingAndForget(Buffer data) {
        this.writePing(data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writePong(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.writePong(data.getDelegate(), handler));
    }

    @Override
    public Void writePongAndAwait(Buffer data) {
        return (Void)this.writePong(data).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writePongAndForget(Buffer data) {
        this.writePong(data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private ServerWebSocket __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public ServerWebSocket closeHandler(Runnable handler) {
        return this.__closeHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    private ServerWebSocket __frameHandler(Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler((Handler)new DelegatingHandler(handler, event -> WebSocketFrame.newInstance(event)));
        return this;
    }

    @Override
    public ServerWebSocket frameHandler(Consumer<WebSocketFrame> handler) {
        return this.__frameHandler((Handler<WebSocketFrame>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    public String scheme() {
        String ret = this.delegate.scheme();
        return ret;
    }

    @Deprecated
    public String host() {
        String ret = this.delegate.host();
        return ret;
    }

    public HostAndPort authority() {
        HostAndPort ret = HostAndPort.newInstance(this.delegate.authority());
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    @Deprecated
    public void accept() {
        this.delegate.accept();
    }

    @Deprecated
    public void reject() {
        this.delegate.reject();
    }

    @Deprecated
    public void reject(int status) {
        this.delegate.reject(status);
    }

    @CheckReturnValue
    @Deprecated
    public Uni<Integer> setHandshake(Uni<Integer> future) {
        return AsyncResultUni.toUni(handler -> this.delegate.setHandshake(UniHelper.toFuture((Uni)future), handler));
    }

    @Deprecated
    public Integer setHandshakeAndAwait(Uni<Integer> future) {
        return (Integer)this.setHandshake(future).await().indefinitely();
    }

    @Deprecated
    public void setHandshakeAndForget(Uni<Integer> future) {
        this.setHandshake(future).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    @Override
    @CheckReturnValue
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti((ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static ServerWebSocket newInstance(io.vertx.core.http.ServerWebSocket arg) {
        return arg != null ? new ServerWebSocket(arg) : null;
    }
}

