/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner.bootstrap;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.bootstrap.app.ArtifactResult;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.SbomResult;
import io.quarkus.bootstrap.classloading.ClassLoaderEventListener;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceHandledBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.DeploymentResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.sbom.SbomBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.runner.bootstrap.StartupActionImpl;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class AugmentActionImpl
implements AugmentAction {
    private static final Logger log = Logger.getLogger(AugmentActionImpl.class);
    private static final Class[] NON_NORMAL_MODE_OUTPUTS = new Class[]{GeneratedClassBuildItem.class, GeneratedResourceBuildItem.class, ApplicationClassNameBuildItem.class, MainClassBuildItem.class, GeneratedFileSystemResourceHandledBuildItem.class, TransformedClassesBuildItem.class};
    private final QuarkusBootstrap quarkusBootstrap;
    private final CuratedApplication curatedApplication;
    private final LaunchMode launchMode;
    private final DevModeType devModeType;
    private final List<Consumer<BuildChainBuilder>> chainCustomizers;
    private final List<ClassLoaderEventListener> classLoadListeners;
    private final Map<Class<?>, Object> reloadContext = new ConcurrentHashMap();

    public AugmentActionImpl(CuratedApplication curatedApplication) {
        this(curatedApplication, Collections.emptyList(), Collections.emptyList());
    }

    @Deprecated
    public AugmentActionImpl(CuratedApplication curatedApplication, List<Consumer<BuildChainBuilder>> chainCustomizers) {
        this(curatedApplication, chainCustomizers, Collections.emptyList());
    }

    public AugmentActionImpl(CuratedApplication curatedApplication, List<Consumer<BuildChainBuilder>> chainCustomizers, List<ClassLoaderEventListener> classLoadListeners) {
        LaunchMode launchMode;
        this.quarkusBootstrap = curatedApplication.getQuarkusBootstrap();
        this.curatedApplication = curatedApplication;
        this.chainCustomizers = chainCustomizers;
        this.classLoadListeners = classLoadListeners;
        DevModeType devModeType = switch (this.quarkusBootstrap.getMode()) {
            case QuarkusBootstrap.Mode.DEV -> {
                launchMode = LaunchMode.DEVELOPMENT;
                yield DevModeType.LOCAL;
            }
            case QuarkusBootstrap.Mode.PROD -> {
                launchMode = LaunchMode.NORMAL;
                yield null;
            }
            case QuarkusBootstrap.Mode.TEST -> {
                launchMode = LaunchMode.TEST;
                yield null;
            }
            case QuarkusBootstrap.Mode.REMOTE_DEV_CLIENT -> {
                launchMode = LaunchMode.NORMAL;
                yield DevModeType.REMOTE_LOCAL_SIDE;
            }
            case QuarkusBootstrap.Mode.CONTINUOUS_TEST -> {
                launchMode = LaunchMode.DEVELOPMENT;
                yield DevModeType.TEST_ONLY;
            }
            case QuarkusBootstrap.Mode.REMOTE_DEV_SERVER -> {
                launchMode = LaunchMode.DEVELOPMENT;
                yield DevModeType.REMOTE_SERVER_SIDE;
            }
            default -> throw new RuntimeException("Unknown launch mode " + String.valueOf(this.quarkusBootstrap.getMode()));
        };
        this.launchMode = launchMode;
        this.devModeType = devModeType;
    }

    public void performCustomBuild(String resultHandler, Object context, String ... finalOutputs) {
        try (final QuarkusClassLoader classLoader = this.curatedApplication.createDeploymentClassLoader();){
            Class[] targets = (Class[])Arrays.stream(finalOutputs).map(new Function<String, Class<? extends BuildItem>>(){

                @Override
                public Class<? extends BuildItem> apply(String s) {
                    try {
                        return Class.forName(s, false, (ClassLoader)classLoader);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }).toArray(Class[]::new);
            BuildResult result = this.runAugment(true, Collections.emptySet(), null, (ClassLoader)classLoader, targets);
            this.writeDebugSourceFile(result);
            try {
                BiConsumer consumer = (BiConsumer)Class.forName(resultHandler, false, (ClassLoader)classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
                consumer.accept(context, result);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public AugmentResult createProductionApplication() {
        if (this.launchMode != LaunchMode.NORMAL) {
            throw new IllegalStateException("Can only create a production application when using NORMAL launch mode");
        }
        try (QuarkusClassLoader classLoader = this.curatedApplication.createDeploymentClassLoader();){
            BuildResult result = this.runAugment(true, Collections.emptySet(), null, (ClassLoader)classLoader, ArtifactResultBuildItem.class, DeploymentResultBuildItem.class, SbomBuildItem.class);
            this.writeDebugSourceFile(result);
            JarBuildItem jarBuildItem = (JarBuildItem)result.consumeOptional(JarBuildItem.class);
            NativeImageBuildItem nativeImageBuildItem = (NativeImageBuildItem)result.consumeOptional(NativeImageBuildItem.class);
            List artifactResultBuildItems = result.consumeMulti(ArtifactResultBuildItem.class);
            BuildSystemTargetBuildItem buildSystemTargetBuildItem = (BuildSystemTargetBuildItem)result.consume(BuildSystemTargetBuildItem.class);
            Map<Path, List<SbomResult>> sboms = this.getSboms(result.consumeMulti(SbomBuildItem.class));
            if (artifactResultBuildItems.isEmpty()) {
                throw new IllegalStateException("No artifact results were produced");
            }
            ArtifactResultBuildItem lastResult = (ArtifactResultBuildItem)((Object)artifactResultBuildItems.get(artifactResultBuildItems.size() - 1));
            this.writeArtifactResultMetadataFile(buildSystemTargetBuildItem, lastResult);
            AugmentResult augmentResult = new AugmentResult(artifactResultBuildItems.stream().map(a -> new ArtifactResult(a.getPath(), a.getType(), a.getMetadata())).collect(Collectors.toList()), jarBuildItem != null ? jarBuildItem.toJarResult(sboms.getOrDefault(jarBuildItem.getPath(), List.of())) : null, nativeImageBuildItem != null ? nativeImageBuildItem.getPath() : null, nativeImageBuildItem != null ? nativeImageBuildItem.getGraalVMInfo().toMap() : Map.of());
            return augmentResult;
        }
    }

    private Map<Path, List<SbomResult>> getSboms(List<SbomBuildItem> sbomBuildItems) {
        if (sbomBuildItems.isEmpty()) {
            return Map.of();
        }
        HashMap<Path, List<SbomResult>> result = new HashMap<Path, List<SbomResult>>();
        for (SbomBuildItem sbomBuildItem : sbomBuildItems) {
            result.computeIfAbsent(sbomBuildItem.getResult().getApplicationRunner(), p -> new ArrayList()).add(sbomBuildItem.getResult());
        }
        return result;
    }

    private void writeDebugSourceFile(BuildResult result) {
        String debugSourcesDir = BootstrapDebug.DEBUG_SOURCES_DIR;
        if (debugSourcesDir != null) {
            for (GeneratedClassBuildItem i : result.consumeMulti(GeneratedClassBuildItem.class)) {
                try {
                    if (i.getSource() != null) {
                        File debugPath = new File(debugSourcesDir);
                        if (!debugPath.exists()) {
                            debugPath.mkdir();
                        }
                        File sourceFile = new File(debugPath, i.getName() + ".zig");
                        sourceFile.getParentFile().mkdirs();
                        Files.write(sourceFile.toPath(), i.getSource().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                        log.infof("Wrote source: %s", (Object)sourceFile.getAbsolutePath());
                        continue;
                    }
                    log.infof("Source not available: %s", (Object)i.getName());
                }
                catch (Exception t) {
                    log.errorf((Throwable)t, "Failed to write debug source file: %s", (Object)i.getName());
                }
            }
        }
    }

    private void writeArtifactResultMetadataFile(BuildSystemTargetBuildItem outputTargetBuildItem, ArtifactResultBuildItem lastResult) {
        Map<String, String> metadata;
        Path quarkusArtifactMetadataPath = outputTargetBuildItem.getOutputDirectory().resolve("quarkus-artifact.properties");
        Properties properties = new Properties();
        properties.put("type", lastResult.getType());
        if (lastResult.getPath() != null) {
            properties.put("path", outputTargetBuildItem.getOutputDirectory().relativize(lastResult.getPath()).toString());
        }
        if ((metadata = lastResult.getMetadata()) != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                properties.put("metadata." + entry.getKey(), entry.getValue());
            }
        }
        try {
            PropertyUtils.store((Properties)properties, (Path)quarkusArtifactMetadataPath, (String)"Generated by Quarkus - Do not edit manually");
        }
        catch (IOException e) {
            log.debug((Object)"Unable to write artifact result metadata file", (Throwable)e);
        }
    }

    public StartupActionImpl createInitialRuntimeApplication() {
        if (this.launchMode == LaunchMode.NORMAL) {
            throw new IllegalStateException("Cannot launch a runtime application with NORMAL launch mode");
        }
        try (QuarkusClassLoader classLoader = this.curatedApplication.createDeploymentClassLoader();){
            BuildResult result = this.runAugment(true, Collections.emptySet(), null, (ClassLoader)classLoader, NON_NORMAL_MODE_OUTPUTS);
            StartupActionImpl startupActionImpl = new StartupActionImpl(this.curatedApplication, result);
            return startupActionImpl;
        }
    }

    public StartupActionImpl reloadExistingApplication(boolean hasStartedSuccessfully, Set<String> changedResources, ClassChangeInformation classChangeInformation) {
        if (this.launchMode != LaunchMode.DEVELOPMENT) {
            throw new IllegalStateException("Only application with launch mode DEVELOPMENT can restart");
        }
        try (QuarkusClassLoader classLoader = this.curatedApplication.createDeploymentClassLoader();){
            BuildResult result = this.runAugment(!hasStartedSuccessfully, changedResources, classChangeInformation, (ClassLoader)classLoader, NON_NORMAL_MODE_OUTPUTS);
            StartupActionImpl startupActionImpl = new StartupActionImpl(this.curatedApplication, result);
            return startupActionImpl;
        }
    }

    /*
     * Exception decompiling
     */
    private BuildResult runAugment(boolean firstRun, Set<String> changedResources, ClassChangeInformation classChangeInformation, ClassLoader deploymentClassLoader, Class<? extends BuildItem> ... finalOutputs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class BuildTask
    implements BiConsumer<CuratedApplication, Map<String, Object>> {
        @Override
        public void accept(CuratedApplication application, Map<String, Object> stringObjectMap) {
            AugmentActionImpl action = new AugmentActionImpl(application);
            action.createProductionApplication();
        }
    }
}

