/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.spi;

import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.callbacks.CallbackImpl;
import io.smallrye.openapi.api.models.examples.ExampleImpl;
import io.smallrye.openapi.api.models.headers.HeaderImpl;
import io.smallrye.openapi.api.models.info.ContactImpl;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.api.models.info.LicenseImpl;
import io.smallrye.openapi.api.models.links.LinkImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.DiscriminatorImpl;
import io.smallrye.openapi.api.models.media.EncodingImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.media.XMLImpl;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.api.models.parameters.RequestBodyImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.models.responses.APIResponsesImpl;
import io.smallrye.openapi.api.models.security.OAuthFlowImpl;
import io.smallrye.openapi.api.models.security.OAuthFlowsImpl;
import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import io.smallrye.openapi.api.models.security.SecuritySchemeImpl;
import io.smallrye.openapi.api.models.servers.ServerImpl;
import io.smallrye.openapi.api.models.servers.ServerVariableImpl;
import io.smallrye.openapi.api.models.tags.TagImpl;
import io.smallrye.openapi.spi.SpiMessages;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.eclipse.microprofile.openapi.spi.OASFactoryResolver;

public class OASFactoryResolverImpl
extends OASFactoryResolver {
    private static final Map<Class<? extends Constructible>, Supplier<? extends Constructible>> registry = new HashMap<Class<? extends Constructible>, Supplier<? extends Constructible>>();

    static <K extends Constructible, V extends K> void put(Class<K> key, Supplier<V> value) {
        registry.put(key, value);
    }

    public <T extends Constructible> T createObject(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return (T)registry.getOrDefault(clazz, () -> this.unknownType(clazz)).get();
    }

    <T extends Constructible> T unknownType(Class<T> clazz) {
        throw SpiMessages.msg.classNotConstructible(clazz.getName());
    }

    static {
        OASFactoryResolverImpl.put(APIResponse.class, APIResponseImpl::new);
        OASFactoryResolverImpl.put(APIResponses.class, APIResponsesImpl::new);
        OASFactoryResolverImpl.put(Callback.class, CallbackImpl::new);
        OASFactoryResolverImpl.put(Components.class, ComponentsImpl::new);
        OASFactoryResolverImpl.put(Contact.class, ContactImpl::new);
        OASFactoryResolverImpl.put(Content.class, ContentImpl::new);
        OASFactoryResolverImpl.put(Discriminator.class, DiscriminatorImpl::new);
        OASFactoryResolverImpl.put(Encoding.class, EncodingImpl::new);
        OASFactoryResolverImpl.put(Example.class, ExampleImpl::new);
        OASFactoryResolverImpl.put(ExternalDocumentation.class, ExternalDocumentationImpl::new);
        OASFactoryResolverImpl.put(Header.class, HeaderImpl::new);
        OASFactoryResolverImpl.put(Info.class, InfoImpl::new);
        OASFactoryResolverImpl.put(License.class, LicenseImpl::new);
        OASFactoryResolverImpl.put(Link.class, LinkImpl::new);
        OASFactoryResolverImpl.put(MediaType.class, MediaTypeImpl::new);
        OASFactoryResolverImpl.put(OAuthFlow.class, OAuthFlowImpl::new);
        OASFactoryResolverImpl.put(OAuthFlows.class, OAuthFlowsImpl::new);
        OASFactoryResolverImpl.put(OpenAPI.class, OpenAPIImpl::new);
        OASFactoryResolverImpl.put(Operation.class, OperationImpl::new);
        OASFactoryResolverImpl.put(Parameter.class, ParameterImpl::new);
        OASFactoryResolverImpl.put(PathItem.class, PathItemImpl::new);
        OASFactoryResolverImpl.put(Paths.class, PathsImpl::new);
        OASFactoryResolverImpl.put(RequestBody.class, RequestBodyImpl::new);
        OASFactoryResolverImpl.put(Schema.class, SchemaImpl::new);
        OASFactoryResolverImpl.put(SecurityRequirement.class, SecurityRequirementImpl::new);
        OASFactoryResolverImpl.put(SecurityScheme.class, SecuritySchemeImpl::new);
        OASFactoryResolverImpl.put(Server.class, ServerImpl::new);
        OASFactoryResolverImpl.put(ServerVariable.class, ServerVariableImpl::new);
        OASFactoryResolverImpl.put(Tag.class, TagImpl::new);
        OASFactoryResolverImpl.put(XML.class, XMLImpl::new);
    }
}

