/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.io.PrintWriter;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.KcUnmatchedArgumentException;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

public class ShortErrorMessageHandler
implements CommandLine.IParameterExceptionHandler {
    public int handleParseException(CommandLine.ParameterException ex, String[] args) {
        CommandLine.Model.ArgSpec spec;
        CommandLine.MissingParameterException mpe;
        CommandLine cmd = ex.getCommandLine();
        PrintWriter writer = cmd.getErr();
        Object errorMessage = ex.getMessage();
        String additionalSuggestion = null;
        if (ex instanceof CommandLine.UnmatchedArgumentException) {
            CommandLine.UnmatchedArgumentException uae = (CommandLine.UnmatchedArgumentException)ex;
            String[] unmatched = this.getUnmatchedPartsByOptionSeparator(uae, "=");
            String cliKey = unmatched[0];
            PropertyMapper<?> mapper = PropertyMappers.getMapper(cliKey);
            boolean isDisabledOption = mapper == null && PropertyMappers.isDisabledMapper(cliKey);
            BooleanSupplier isUnknownOption = () -> mapper == null || !(cmd.getCommand() instanceof AbstractCommand);
            if (isDisabledOption) {
                String enabledWhen = PropertyMappers.getDisabledMapper(cliKey).map(PropertyMapper::getEnabledWhen).filter(Optional::isPresent).map(desc -> String.format(". %s", desc.get())).orElse("");
                errorMessage = String.format("Disabled option: '%s'%s", cliKey, enabledWhen);
                additionalSuggestion = "Specify '--help-all' to obtain information on all options and their availability.";
            } else if (isUnknownOption.getAsBoolean()) {
                errorMessage = cliKey.split("\\s").length > 1 ? "Option: '" + cliKey + "' is not expected to contain whitespace, please remove any unnecessary quoting/escaping" : "Unknown option: '" + cliKey + "'";
            } else {
                AbstractCommand command = (AbstractCommand)cmd.getCommand();
                if (!command.getOptionCategories().contains(mapper.getCategory())) {
                    errorMessage = String.format("Option: '%s' not valid for command %s", cliKey, cmd.getCommandName());
                } else if (Stream.of(args).anyMatch("--optimized"::equals) && mapper.isBuildTime() && "start".equals(cmd.getCommandName())) {
                    errorMessage = String.format("Build time option: '%s' not usable with pre-built image and --optimized", cliKey);
                } else {
                    String optionType = mapper.isRunTime() ? "Run time" : "Build time";
                    errorMessage = String.format("%s option: '%s' not usable with %s", optionType, cliKey, cmd.getCommandName());
                }
            }
        } else if (ex instanceof CommandLine.MissingParameterException && (mpe = (CommandLine.MissingParameterException)ex).getMissing().size() == 1 && (spec = (CommandLine.Model.ArgSpec)mpe.getMissing().get(0)) instanceof CommandLine.Model.OptionSpec) {
            CommandLine.Model.OptionSpec option = (CommandLine.Model.OptionSpec)spec;
            errorMessage = this.getExpectedMessage(option);
        }
        writer.println(cmd.getColorScheme().errorText((String)errorMessage));
        if (!(ex instanceof KcUnmatchedArgumentException) && ex instanceof CommandLine.UnmatchedArgumentException) {
            ex = new KcUnmatchedArgumentException((CommandLine.UnmatchedArgumentException)ex);
        }
        CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)ex, (PrintWriter)writer);
        CommandLine.Model.CommandSpec spec2 = cmd.getCommandSpec();
        writer.printf("Try '%s --help' for more information on the available options.%n", spec2.qualifiedName());
        if (additionalSuggestion != null) {
            writer.println(additionalSuggestion);
        }
        return ShortErrorMessageHandler.getInvalidInputExitCode((Exception)ex, cmd);
    }

    static int getInvalidInputExitCode(Exception ex, CommandLine cmd) {
        return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : cmd.getCommandSpec().exitCodeOnInvalidInput();
    }

    private String[] getUnmatchedPartsByOptionSeparator(CommandLine.UnmatchedArgumentException uae, String separator) {
        return ((String)uae.getUnmatched().get(0)).split(separator);
    }

    private String getExpectedMessage(CommandLine.Model.OptionSpec option) {
        return String.format("Option '%s' (%s) expects %s.%s", String.join((CharSequence)", ", option.names()), option.paramLabel(), option.typeInfo().isMultiValue() ? "one or more comma separated values without whitespace" : "a single value", ShortErrorMessageHandler.getExpectedValuesMessage(option.completionCandidates(), this.isCaseInsensitive(option)));
    }

    private boolean isCaseInsensitive(CommandLine.Model.OptionSpec option) {
        PropertyMapper<?> mapper;
        if (option.longestName().startsWith("--") && (mapper = PropertyMappers.getMapper(option.longestName().substring(2))) != null) {
            return mapper.getOption().isCaseInsensitiveExpectedValues();
        }
        return false;
    }

    public static String getExpectedValuesMessage(Iterable<String> specCandidates, boolean caseInsensitive) {
        return specCandidates.iterator().hasNext() ? String.format(" Expected values are%s: %s", caseInsensitive ? " (case insensitive)" : "", String.join((CharSequence)", ", specCandidates)) : "";
    }
}

