/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.inviteorg;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Objects;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.inviteorg.InviteOrgActionToken;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;

public class InviteOrgActionTokenHandler
extends AbstractActionTokenHandler<InviteOrgActionToken> {
    public InviteOrgActionTokenHandler() {
        super("ORGIVT", InviteOrgActionToken.class, "staleInviteOrgLink", EventType.INVITE_ORG, "invalid_token");
    }

    @Override
    public TokenVerifier.Predicate<? super InviteOrgActionToken>[] getVerifiers(ActionTokenContext<InviteOrgActionToken> tokenContext) {
        return TokenUtils.predicates(TokenUtils.checkThat(t -> Objects.equals(t.getEmail(), tokenContext.getAuthenticationSession().getAuthenticatedUser().getEmail()), "invalid_email", this.getDefaultErrorMessage()));
    }

    @Override
    public Response preHandleToken(InviteOrgActionToken token, ActionTokenContext<InviteOrgActionToken> tokenContext) {
        KeycloakSession session = tokenContext.getSession();
        OrganizationProvider orgProvider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        OrganizationModel organization = orgProvider.getById(token.getOrgId());
        if (organization == null) {
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setInfo("orgNotFoundMessage", new Object[]{token.getOrgId()}).createInfoPage();
        }
        session.getContext().setOrganization(organization);
        return super.preHandleToken(token, tokenContext);
    }

    @Override
    public Response handleToken(InviteOrgActionToken token, ActionTokenContext<InviteOrgActionToken> tokenContext) {
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        KeycloakSession session = tokenContext.getSession();
        OrganizationProvider orgProvider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        EventBuilder event = tokenContext.getEvent();
        event.event(EventType.INVITE_ORG).detail("username", user.getUsername());
        OrganizationModel organization = orgProvider.getById(token.getOrgId());
        if (organization == null) {
            event.user(user).error("org_not_found");
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setInfo("orgNotFoundMessage", new Object[]{token.getOrgId()}).createInfoPage();
        }
        if (organization.isMember(user)) {
            event.user(user).error("user_org_member_already");
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setInfo("orgMemberAlready", new Object[]{user.getUsername()}).createInfoPage();
        }
        UriInfo uriInfo = tokenContext.getUriInfo();
        RealmModel realm = tokenContext.getRealm();
        if (tokenContext.isAuthenticationSessionFresh()) {
            String authSessionEncodedId = AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSession).getEncodedId();
            token.setCompoundAuthenticationSessionId(authSessionEncodedId);
            UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, uriInfo), authSession.getClient().getClientId(), authSession.getTabId(), AuthenticationProcessor.getClientData(session, authSession));
            String confirmUri = builder.build(new Object[]{realm.getName()}).toString();
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("organization.confirm-membership", new Object[]{organization.getName()}).setAttribute("messageHeader", (Object)"organization.confirm-membership.title").setAttribute("actionUri", (Object)confirmUri).setAttribute("kc.org.name", (Object)organization.getName()).createInfoPage();
        }
        orgProvider.addMember(orgProvider.getById(token.getOrgId()), user);
        String redirectUri = token.getRedirectUri();
        if (redirectUri != null) {
            authSession.setAuthNote("SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS", "true");
            authSession.setRedirectUri(redirectUri);
            authSession.setClientNote("redirect_uri", redirectUri);
        }
        event.success();
        tokenContext.setEvent(event.clone().removeDetail("email").event(EventType.LOGIN));
        String nextAction = AuthenticationManager.nextRequiredAction(session, authSession, tokenContext.getRequest(), event);
        if (nextAction == null) {
            authSession.removeAuthNote("END_AFTER_REQUIRED_ACTIONS");
            if (redirectUri != null) {
                return Response.status((Response.Status)Response.Status.FOUND).location(URI.create(redirectUri)).build();
            }
        }
        return AuthenticationManager.redirectToRequiredActions(session, realm, authSession, uriInfo, nextAction);
    }
}

