/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

public class PostgresPlusDatabase
extends PostgresDatabase {
    public static final String POSTGRESPLUS_PRODUCT_NAME = "EnterpriseDB";

    public String getShortName() {
        return "postgresplus";
    }

    protected String getDefaultDatabaseProductName() {
        return POSTGRESPLUS_PRODUCT_NAME;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return POSTGRESPLUS_PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        String defaultDriver = super.getDefaultDriver(url);
        if (defaultDriver == null && url.startsWith("jdbc:edb:")) {
            defaultDriver = "com.edb.Driver";
        }
        return defaultDriver;
    }

    protected String getConnectionSchemaName() {
        try {
            return (String)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this).queryForObject((SqlStatement)new RawSqlStatement("select current_schema"), String.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get current schema", e);
        }
    }
}

