/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.OAuthErrorException;
import org.keycloak.TokenVerifier;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.SystemClientUtil;
import org.keycloak.protocol.oidc.BackchannelLogoutResponse;
import org.keycloak.protocol.oidc.LogoutTokenValidationCode;
import org.keycloak.protocol.oidc.LogoutTokenValidationContext;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.oidc.utils.LogoutUtil;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.LogoutToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.LogoutRequestContext;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.LogoutSessionCodeChecks;
import org.keycloak.services.util.LocaleUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class LogoutEndpoint {
    private static final Logger logger = Logger.getLogger(LogoutEndpoint.class);
    private final KeycloakSession session;
    private final ClientConnection clientConnection;
    private final HttpRequest request;
    private final HttpHeaders headers;
    private final TokenManager tokenManager;
    private final RealmModel realm;
    private final EventBuilder event;
    private Cors cors;

    public LogoutEndpoint(KeycloakSession session, TokenManager tokenManager, EventBuilder event) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.tokenManager = tokenManager;
        this.realm = session.getContext().getRealm();
        this.event = event;
        this.request = session.getContext().getHttpRequest();
        this.headers = session.getContext().getRequestHeaders();
    }

    @Path(value="/")
    @OPTIONS
    public Response issueUserInfoPreflight() {
        return Cors.builder().auth().preflight().add(Response.ok());
    }

    @GET
    @NoCache
    public Response logout(@QueryParam(value="id_token_hint") String encodedIdToken, @QueryParam(value="client_id") String clientId, @QueryParam(value="post_logout_redirect_uri") String postLogoutRedirectUri, @QueryParam(value="state") String state, @QueryParam(value="ui_locales") String uiLocales, @QueryParam(value="initiating_idp") String initiatingIdp) {
        ClientModel client;
        if (postLogoutRedirectUri != null && encodedIdToken == null && clientId == null) {
            this.event.event(EventType.LOGOUT);
            String errorMessage = "Either the parameter 'client_id' or the parameter 'id_token_hint' is required when 'post_logout_redirect_uri' is used.";
            this.event.detail("reason", errorMessage);
            this.event.error("invalid_request");
            logger.warnf(errorMessage, new Object[0]);
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "missingParameterMessage", "id_token_hint");
        }
        boolean confirmationNeeded = true;
        boolean forcedConfirmation = false;
        ClientModel clientModel = client = clientId == null ? null : this.realm.getClientByClientId(clientId);
        if (clientId != null && client == null) {
            logger.warnf("Client '%s' not found.", (Object)clientId);
            forcedConfirmation = true;
        }
        IDToken idToken = null;
        if (encodedIdToken != null) {
            try {
                idToken = this.tokenManager.verifyIDTokenSignature(this.session, encodedIdToken);
                TokenVerifier.createWithoutSignature((JsonWebToken)idToken).tokenType(Arrays.asList("ID")).verify();
            }
            catch (OAuthErrorException | VerificationException e) {
                this.event.event(EventType.LOGOUT);
                this.event.detail("reason", e.getMessage());
                this.event.error("invalid_token");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "invalidParameterMessage", "id_token_hint");
            }
        }
        if (clientId == null) {
            ClientModel clientModel2 = client = idToken == null || idToken.getIssuedFor() == null ? null : this.realm.getClientByClientId(idToken.getIssuedFor());
            if (client != null) {
                confirmationNeeded = false;
            }
        } else if (idToken != null && idToken.getIssuedFor() != null) {
            if (!idToken.getIssuedFor().equals(clientId)) {
                this.event.event(EventType.LOGOUT);
                this.event.client(clientId);
                String errorMessage = "Parameter client_id is different than the client for which ID Token was issued.";
                this.event.detail("reason", errorMessage);
                this.event.error("invalid_token");
                logger.warnf("%s Parameter client_id: '%s', ID Token issued for: '%s'.", (Object)errorMessage, (Object)clientId, (Object)idToken.getIssuedFor());
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "invalidParameterMessage", "id_token_hint");
            }
            confirmationNeeded = false;
        }
        if (client != null) {
            this.session.getContext().setClient(client);
            this.event.client(client);
        }
        String validatedRedirectUri = null;
        if (postLogoutRedirectUri != null) {
            if (client != null) {
                OIDCAdvancedConfigWrapper wrapper = OIDCAdvancedConfigWrapper.fromClientModel(client);
                HashSet<String> postLogoutRedirectUris = wrapper.getPostLogoutRedirectUris() != null ? new HashSet<String>(wrapper.getPostLogoutRedirectUris()) : new HashSet();
                validatedRedirectUri = RedirectUtils.verifyRedirectUri(this.session, client.getRootUrl(), postLogoutRedirectUri, postLogoutRedirectUris, true);
            }
            if (validatedRedirectUri == null) {
                this.event.event(EventType.LOGOUT);
                this.event.detail("redirect_uri", postLogoutRedirectUri);
                this.event.error("invalid_redirect_uri");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "invalidRedirectUriMessage", new Object[0]);
            }
        }
        AuthenticationSessionModel logoutSession = AuthenticationManager.createOrJoinLogoutSession(this.session, this.realm, new AuthenticationSessionManager(this.session), null, true, true);
        this.session.getContext().setAuthenticationSession(logoutSession);
        if (uiLocales != null) {
            logoutSession.setClientNote("locale_client_requested", uiLocales);
        }
        if (validatedRedirectUri != null) {
            logoutSession.setAuthNote("OIDC_LOGOUT_REDIRECT_URI", validatedRedirectUri);
        }
        if (state != null) {
            logoutSession.setAuthNote("OIDC_LOGOUT_STATE_PARAM", state);
        }
        if (initiatingIdp != null) {
            logoutSession.setAuthNote("LOGOUT_INITIATING_IDP", initiatingIdp);
        }
        if (idToken != null) {
            logoutSession.setAuthNote("OIDC_LOGOUT_VALIDATED_ID_TOKEN_SESSION_STATE", idToken.getSessionState());
            logoutSession.setAuthNote("OIDC_LOGOUT_VALIDATED_ID_TOKEN_ISSUED_AT", String.valueOf(idToken.getIat()));
        }
        LoginFormsProvider loginForm = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(logoutSession);
        UserSessionModel userSession = null;
        AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie(this.session, this.realm, false);
        if (authResult != null) {
            userSession = authResult.getSession();
            if (idToken != null && idToken.getSessionState() != null && !idToken.getSessionState().equals(authResult.getSession().getId())) {
                forcedConfirmation = true;
            }
        } else if (encodedIdToken == null && client != null && validatedRedirectUri != null) {
            confirmationNeeded = false;
        }
        if (userSession == null && idToken != null && idToken.getSessionState() != null) {
            userSession = this.session.sessions().getUserSession(this.realm, idToken.getSessionState());
        }
        if (userSession != null) {
            UserModel user = userSession.getUser();
            logoutSession.setAuthenticatedUser(user);
            loginForm.setUser(user);
        }
        if (confirmationNeeded || forcedConfirmation) {
            return this.displayLogoutConfirmationScreen(loginForm, logoutSession);
        }
        return this.doBrowserLogout(logoutSession);
    }

    private Response displayLogoutConfirmationScreen(LoginFormsProvider loginForm, AuthenticationSessionModel authSession) {
        ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.realm, authSession);
        accessCode.setAction(CommonClientSessionModel.Action.LOGGING_OUT.name());
        return loginForm.setClientSessionCode(accessCode.getOrGenerateCode()).createLogoutConfirmPage();
    }

    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response logout() {
        MultivaluedMap form = this.request.getDecodedFormParameters();
        if (form.containsKey((Object)"refresh_token")) {
            return this.logoutToken();
        }
        return this.logout((String)form.getFirst((Object)"id_token_hint"), (String)form.getFirst((Object)"client_id"), (String)form.getFirst((Object)"post_logout_redirect_uri"), (String)form.getFirst((Object)"state"), (String)form.getFirst((Object)"ui_locales"), (String)form.getFirst((Object)"initiating_idp"));
    }

    @Path(value="/logout-confirm")
    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response logoutConfirmAction() {
        MultivaluedMap formData = this.request.getDecodedFormParameters();
        this.event.event(EventType.LOGOUT);
        String code = (String)formData.getFirst((Object)"session_code");
        String clientId = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"client_id");
        String tabId = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"tab_id");
        logger.tracef("Logout confirmed. sessionCode=%s, clientId=%s, tabId=%s", (Object)code, (Object)clientId, (Object)tabId);
        LogoutSessionCodeChecks checks = new LogoutSessionCodeChecks(this.realm, (UriInfo)this.session.getContext().getUri(), this.request, this.clientConnection, this.session, this.event, code, clientId, tabId);
        checks.initialVerify();
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.LOGGING_OUT.name(), ClientSessionCode.ActionType.USER) || !checks.isActionRequest()) {
            AuthenticationSessionModel logoutSession = checks.getAuthenticationSession();
            String errorMessage = "Failed verification during logout.";
            logger.debugf("%s logoutSessionId=%s, clientId=%s, tabId=%s", new Object[]{errorMessage, logoutSession != null ? logoutSession.getParentSession().getId() : "unknown", clientId, tabId});
            SystemClientUtil.checkSkipLink((KeycloakSession)this.session, (AuthenticationSessionModel)logoutSession);
            this.event.detail("reason", errorMessage);
            this.event.error("session_expired");
            return ErrorPage.error(this.session, logoutSession, Response.Status.BAD_REQUEST, "failedLogout", new Object[0]);
        }
        AuthenticationSessionModel logoutSession = checks.getAuthenticationSession();
        logger.tracef("Logout code successfully verified. Logout Session is '%s'. Client ID is '%s'.", (Object)logoutSession.getParentSession().getId(), (Object)logoutSession.getClient().getClientId());
        return this.doBrowserLogout(logoutSession);
    }

    @Path(value="/logout-confirm")
    @NoCache
    @GET
    public Response logoutConfirmGet() {
        this.event.event(EventType.LOGOUT);
        String clientId = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"client_id");
        String tabId = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"tab_id");
        logger.tracef("Changing localization by user during logout. clientId=%s, tabId=%s, kc_locale: %s", (Object)clientId, (Object)tabId, this.session.getContext().getUri().getQueryParameters().getFirst((Object)"kc_locale"));
        LogoutSessionCodeChecks checks = new LogoutSessionCodeChecks(this.realm, (UriInfo)this.session.getContext().getUri(), this.request, this.clientConnection, this.session, this.event, null, clientId, tabId);
        AuthenticationSessionModel logoutSession = checks.initialVerifyAuthSession();
        if (logoutSession == null) {
            String errorMessage = "Failed verification when changing locale during logout.";
            logger.debugf("%s clientId=%s, tabId=%s", (Object)errorMessage, (Object)clientId, (Object)tabId);
            SystemClientUtil.checkSkipLink((KeycloakSession)this.session, (AuthenticationSessionModel)logoutSession);
            AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie(this.session, this.realm, false);
            if (authResult != null) {
                this.event.detail("reason", errorMessage);
                this.event.error("logout_failed");
                return ErrorPage.error(this.session, logoutSession, Response.Status.BAD_REQUEST, "failedLogout", new Object[0]);
            }
            return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setSuccess("successLogout", new Object[0]).createInfoPage();
        }
        LocaleUtil.processLocaleParam(this.session, this.realm, logoutSession);
        LoginFormsProvider loginForm = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(logoutSession).setUser(logoutSession.getAuthenticatedUser());
        return this.displayLogoutConfirmationScreen(loginForm, logoutSession);
    }

    private Response doBrowserLogout(AuthenticationSessionModel logoutSession) {
        AuthenticationManager.AuthResult authResult;
        UserSessionModel userSession = null;
        String userSessionIdFromIdToken = logoutSession.getAuthNote("OIDC_LOGOUT_VALIDATED_ID_TOKEN_SESSION_STATE");
        String idTokenIssuedAtStr = logoutSession.getAuthNote("OIDC_LOGOUT_VALIDATED_ID_TOKEN_ISSUED_AT");
        if (userSessionIdFromIdToken != null && idTokenIssuedAtStr != null) {
            try {
                userSession = this.session.sessions().getUserSession(this.realm, userSessionIdFromIdToken);
                if (userSession == null) {
                    this.event.event(EventType.LOGOUT);
                    this.event.error("session_expired");
                } else {
                    Integer idTokenIssuedAt = Integer.parseInt(idTokenIssuedAtStr);
                    this.checkTokenIssuedAt(idTokenIssuedAt.intValue(), userSession);
                }
            }
            catch (OAuthErrorException e) {
                this.event.event(EventType.LOGOUT);
                this.event.detail("reason", e.getDescription());
                this.event.error("invalid_token");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "sessionNotActiveMessage", new Object[0]);
            }
        }
        if ((authResult = AuthenticationManager.authenticateIdentityCookie(this.session, this.realm, false)) != null) {
            userSession = userSession != null ? userSession : authResult.getSession();
            return this.initiateBrowserLogout(userSession);
        }
        if (userSession != null) {
            if (AuthenticationManager.compareSessionIdWithSessionCookie(this.session, userSessionIdFromIdToken)) {
                return this.initiateBrowserLogout(userSession);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT && userSession.getState() != UserSessionModel.State.LOGGED_OUT) {
                this.event.event(EventType.LOGOUT);
                AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, true);
                String redirectUri = logoutSession.getAuthNote("OIDC_LOGOUT_REDIRECT_URI");
                if (redirectUri != null) {
                    this.event.detail("redirect_uri", redirectUri);
                }
                this.event.user(userSession.getUser()).session(userSession).success();
            }
        }
        logger.tracef("Removing logout session '%s' used during logout.", (Object)logoutSession.getParentSession().getId());
        RootAuthenticationSessionModel rootAuthSession = logoutSession.getParentSession();
        rootAuthSession.removeAuthenticationSessionByTabId(logoutSession.getTabId());
        return LogoutUtil.sendResponseAfterLogoutFinished(this.session, logoutSession);
    }

    private Response logoutToken() {
        this.cors = Cors.builder().auth().allowedMethods(new String[]{"POST"}).auth().exposedHeaders(new String[]{"Access-Control-Allow-Methods"});
        MultivaluedMap form = this.request.getDecodedFormParameters();
        this.checkSsl();
        this.event.event(EventType.LOGOUT);
        ClientModel client = this.authorizeClient();
        String refreshToken = (String)form.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "No refresh token", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new LogoutRequestContext((MultivaluedMap<String, String>)form));
            refreshToken = (String)form.getFirst((Object)"refresh_token");
        }
        catch (ClientPolicyException cpe) {
            this.event.detail("reason", "client_policy_error");
            this.event.detail("client_policy_error", cpe.getError());
            this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        RefreshToken token = null;
        try {
            UserSessionModel userSessionModel;
            token = this.tokenManager.verifyRefreshToken(this.session, this.realm, client, this.request, refreshToken, false);
            boolean offline = "Offline".equals(token.getType());
            if (offline) {
                UserSessionManager sessionManager = new UserSessionManager(this.session);
                userSessionModel = sessionManager.findOfflineUserSession(this.realm, token.getSessionState());
            } else {
                String sessionState = token.getSessionState();
                userSessionModel = this.session.sessions().getUserSession(this.realm, sessionState);
            }
            if (userSessionModel != null) {
                this.checkTokenIssuedAt(token.getIat(), userSessionModel);
                this.logout(userSessionModel, offline);
            }
        }
        catch (OAuthErrorException e) {
            if ("Client certificate missing, or its thumbprint and one in the refresh token did NOT match".equals(e.getDescription())) {
                this.event.detail("reason", e.getDescription());
                this.event.error("not_allowed");
                throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.UNAUTHORIZED);
            }
            this.event.detail("reason", e.getDescription());
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.BAD_REQUEST);
        }
        return this.cors.add(Response.noContent());
    }

    @Path(value="/backchannel-logout")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response backchannelLogout() {
        MultivaluedMap form = this.request.getDecodedFormParameters();
        this.event.event(EventType.LOGOUT);
        String encodedLogoutToken = (String)form.getFirst((Object)"logout_token");
        if (encodedLogoutToken == null) {
            String errorMessage = "No logout token";
            this.event.detail("reason", errorMessage);
            this.event.error("invalid_token");
            throw new ErrorResponseException("invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        LogoutTokenValidationContext validationCtx = this.tokenManager.verifyLogoutToken(this.session, encodedLogoutToken);
        if (!validationCtx.getStatus().equals((Object)LogoutTokenValidationCode.VALIDATION_SUCCESS)) {
            String errorMessage = validationCtx.getStatus().getErrorMessage();
            this.event.detail("reason", errorMessage);
            this.event.error("invalid_token");
            throw new ErrorResponseException("invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        LogoutToken logoutToken = validationCtx.getLogoutToken();
        Stream<String> identityProviderAliases = validationCtx.getValidIdentityProviders().stream().map(idp -> ((OIDCIdentityProviderConfig)idp.getConfig()).getAlias());
        boolean logoutOfflineSessions = Boolean.parseBoolean(((Object)logoutToken.getEvents().getOrDefault("revoke_offline_access", false)).toString());
        BackchannelLogoutResponse backchannelLogoutResponse = logoutToken.getSid() != null ? this.backchannelLogoutWithSessionId(logoutToken.getSid(), identityProviderAliases, logoutOfflineSessions, logoutToken.getSubject()) : this.backchannelLogoutFederatedUserId(logoutToken.getSubject(), identityProviderAliases, logoutOfflineSessions);
        if (!backchannelLogoutResponse.getLocalLogoutSucceeded()) {
            String errorMessage = "There was an error during the local logout";
            this.event.detail("reason", errorMessage);
            this.event.error("logout_failed");
            throw new ErrorResponseException("server_error", errorMessage, Response.Status.NOT_IMPLEMENTED);
        }
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowEmptyContentType();
        if (this.oneOrMoreDownstreamLogoutsFailed(backchannelLogoutResponse)) {
            return Cors.builder().auth().add(Response.status((Response.Status)Response.Status.GATEWAY_TIMEOUT).type(MediaType.APPLICATION_JSON_TYPE));
        }
        return Cors.builder().auth().add(Response.ok().type(MediaType.APPLICATION_JSON_TYPE));
    }

    private BackchannelLogoutResponse backchannelLogoutWithSessionId(String sessionId, Stream<String> identityProviderAliases, boolean logoutOfflineSessions, String federatedUserId) {
        AtomicReference<BackchannelLogoutResponse> backchannelLogoutResponse = new AtomicReference<BackchannelLogoutResponse>(new BackchannelLogoutResponse());
        backchannelLogoutResponse.get().setLocalLogoutSucceeded(true);
        identityProviderAliases.forEach(identityProviderAlias -> {
            UserSessionModel userSession = this.session.sessions().getUserSessionByBrokerSessionId(this.realm, identityProviderAlias + "." + sessionId);
            if (logoutOfflineSessions) {
                this.logoutOfflineUserSessionByBrokerUserId(identityProviderAlias + "." + federatedUserId, identityProviderAlias + "." + sessionId);
            }
            if (userSession != null) {
                backchannelLogoutResponse.set(this.logoutUserSession(userSession));
            }
        });
        return backchannelLogoutResponse.get();
    }

    private BackchannelLogoutResponse backchannelLogoutFederatedUserId(String federatedUserId, Stream<String> identityProviderAliases, boolean logoutOfflineSessions) {
        BackchannelLogoutResponse backchannelLogoutResponse = new BackchannelLogoutResponse();
        backchannelLogoutResponse.setLocalLogoutSucceeded(true);
        identityProviderAliases.forEach(identityProviderAlias -> {
            if (logoutOfflineSessions) {
                this.logoutOfflineUserSessions(identityProviderAlias + "." + federatedUserId);
            }
            this.session.sessions().getUserSessionByBrokerUserIdStream(this.realm, identityProviderAlias + "." + federatedUserId).collect(Collectors.toList()).forEach(userSession -> {
                BackchannelLogoutResponse userBackchannelLogoutResponse = this.logoutUserSession((UserSessionModel)userSession);
                backchannelLogoutResponse.setLocalLogoutSucceeded(backchannelLogoutResponse.getLocalLogoutSucceeded() && userBackchannelLogoutResponse.getLocalLogoutSucceeded());
                userBackchannelLogoutResponse.getClientResponses().forEach(backchannelLogoutResponse::addClientResponses);
            });
        });
        return backchannelLogoutResponse;
    }

    private void logoutOfflineUserSessions(String brokerUserId) {
        UserSessionManager userSessionManager = new UserSessionManager(this.session);
        this.session.sessions().getOfflineUserSessionByBrokerUserIdStream(this.realm, brokerUserId).collect(Collectors.toList()).forEach(userSessionManager::revokeOfflineUserSession);
    }

    private void logoutOfflineUserSessionByBrokerUserId(String brokerUserId, String brokerSessionId) {
        UserSessionManager userSessionManager = new UserSessionManager(this.session);
        if (brokerUserId != null && brokerSessionId != null) {
            this.session.sessions().getOfflineUserSessionByBrokerUserIdStream(this.realm, brokerUserId).filter(userSession -> brokerSessionId.equals(userSession.getBrokerSessionId())).forEach(userSessionManager::revokeOfflineUserSession);
        }
    }

    private BackchannelLogoutResponse logoutUserSession(UserSessionModel userSession) {
        BackchannelLogoutResponse backchannelLogoutResponse = AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, false);
        if (backchannelLogoutResponse.getLocalLogoutSucceeded()) {
            this.event.user(userSession.getUser()).session(userSession).success();
        }
        return backchannelLogoutResponse;
    }

    private boolean oneOrMoreDownstreamLogoutsFailed(BackchannelLogoutResponse backchannelLogoutResponse) {
        BackchannelLogoutResponse filteredBackchannelLogoutResponse = new BackchannelLogoutResponse();
        for (BackchannelLogoutResponse.DownStreamBackchannelLogoutResponse response : backchannelLogoutResponse.getClientResponses()) {
            if (!response.isWithBackchannelLogoutUrl()) continue;
            filteredBackchannelLogoutResponse.addClientResponses(response);
        }
        return backchannelLogoutResponse.getClientResponses().stream().filter(BackchannelLogoutResponse.DownStreamBackchannelLogoutResponse::isWithBackchannelLogoutUrl).anyMatch(clientResponse -> !clientResponse.getResponseCode().isPresent() || clientResponse.getResponseCode().get().intValue() != Response.Status.OK.getStatusCode() && clientResponse.getResponseCode().get().intValue() != Response.Status.NO_CONTENT.getStatusCode());
    }

    private void logout(UserSessionModel userSession, boolean offline) {
        AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, true, offline);
        this.event.user(userSession.getUser()).session(userSession).success();
    }

    private ClientModel authorizeClient() {
        ClientModel client = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.cors).getClient();
        this.cors.allowedOrigins(this.session, client);
        if (client.isBearerOnly()) {
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
        return client;
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkTokenIssuedAt(long idTokenIssuedAt, UserSessionModel userSession) throws OAuthErrorException {
        if (idTokenIssuedAt + 1L < (long)userSession.getStarted()) {
            throw new OAuthErrorException("invalid_grant", "Toked issued before the user session started");
        }
    }

    private Response initiateBrowserLogout(UserSessionModel userSession) {
        userSession.setNote("KEYCLOAK_LOGOUT_PROTOCOL", "openid-connect");
        logger.tracef("Calling initiateBrowserLogout for user session '%s'", (Object)userSession.getId());
        Response response = AuthenticationManager.browserLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers);
        logger.tracef("Finished call of initiateBrowserLogout for user session '%s'", (Object)userSession.getId());
        return response;
    }
}

