/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.common.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.WildcardPropertyMapper;

public class KcEnvConfigSource
extends PropertiesConfigSource {
    public static final String NAME = "KcEnvVarConfigSource";

    public KcEnvConfigSource() {
        super(KcEnvConfigSource.buildProperties(), NAME, 500);
    }

    private static Map<String, String> buildProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String kcPrefix = StringUtil.replaceNonAlphanumericByUnderscores((String)"kc.".toUpperCase());
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith(kcPrefix)) continue;
            Object transformedKey = "kc." + key.substring(kcPrefix.length()).toLowerCase().replace("_", "-");
            PropertyMapper<?> mapper = PropertyMappers.getMapper((String)transformedKey);
            if (mapper != null && mapper.hasWildcard()) {
                transformedKey = ((WildcardPropertyMapper)mapper).getKcKeyForEnvKey(key, (String)transformedKey).orElseThrow();
            }
            properties.put((String)transformedKey, value);
        }
        return properties;
    }
}

