/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.query;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.internal.NamedHqlQueryDefinitionImpl;
import org.hibernate.boot.query.AbstractNamedQueryBuilder;
import org.hibernate.boot.query.NamedQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;

public interface NamedHqlQueryDefinition
extends NamedQueryDefinition {
    public String getHqlString();

    @Override
    public NamedSqmQueryMemento resolve(SessionFactoryImplementor var1);

    public static class Builder
    extends AbstractNamedQueryBuilder<Builder> {
        private String hqlString;
        private Integer firstResult;
        private Integer maxResults;
        private Map<String, String> parameterTypes;

        public Builder(String name) {
            super(name);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public String getHqlString() {
            return this.hqlString;
        }

        public Builder setHqlString(String hqlString) {
            this.hqlString = hqlString;
            return this;
        }

        public Builder setFirstResult(Integer firstResult) {
            this.firstResult = firstResult;
            return this.getThis();
        }

        public Builder setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this.getThis();
        }

        public NamedHqlQueryDefinitionImpl build() {
            return new NamedHqlQueryDefinitionImpl(this.getName(), this.hqlString, this.firstResult, this.maxResults, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.parameterTypes, this.getHints());
        }

        public void addParameterTypeHint(String name, String type) {
            if (this.parameterTypes == null) {
                this.parameterTypes = new HashMap<String, String>();
            }
            this.parameterTypes.put(name, type);
        }
    }
}

